/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.model.impl;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.sakaiproject.db.cover.SqlService;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.DataMigrationAgent;

public class SQLScriptMigration
implements DataMigrationAgent {
    private static Log log = LogFactory.getLog(SQLScriptMigration.class);
    private String from;
    private String to;
    private String scriptPattern;
    private SessionFactory sessionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String migrate(String current, String target, final boolean newdb) throws Exception {
        String string;
        if (current != null && this.from == null || current != null && !current.equals(this.from)) {
            log.info((Object)("Skipping Migration for " + this.from + " to " + this.to));
            return current;
        }
        String targetScript = null;
        String targetDialect = SqlService.getVendor();
        if (targetDialect == null || targetDialect.length() == 0) {
            targetDialect = "hsqldb";
        }
        targetScript = MessageFormat.format(this.scriptPattern, targetDialect);
        log.info((Object)("Migrating database schema from " + this.from + " to " + this.to + " using " + targetScript));
        InputStream inStream = this.getClass().getResourceAsStream(targetScript);
        if (inStream == null) {
            log.warn((Object)("Migration Script " + targetScript + " was not found "));
            return current;
        }
        InputStreamReader stream = null;
        BufferedReader br = null;
        try {
            stream = new InputStreamReader(inStream);
            br = new BufferedReader(stream);
            String line = br.readLine();
            StringBuffer currentLine = new StringBuffer();
            ArrayList<String> lines = new ArrayList<String>();
            while (line != null) {
                if (line.trim().endsWith(";")) {
                    currentLine.append(line);
                    String sqlcmd = currentLine.toString().trim();
                    sqlcmd = sqlcmd.substring(0, sqlcmd.length() - 1);
                    if (sqlcmd != null && sqlcmd.length() > 0) {
                        lines.add(sqlcmd);
                    }
                    currentLine = new StringBuffer();
                } else {
                    currentLine.append(line);
                }
                line = br.readLine();
            }
            final String[] sql = lines.toArray(new String[lines.size()]);
            HibernateTemplate hibernateTemplate = new HibernateTemplate(this.sessionFactory);
            hibernateTemplate.setFlushMode(0);
            hibernateTemplate.execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Connection con = session.connection();
                    SQLScriptMigration.this.executeSchemaScript(con, sql, newdb);
                    return null;
                }
            });
            string = this.to;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            IOUtils.closeQuietly(br);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)stream);
        IOUtils.closeQuietly((Reader)br);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeSchemaScript(Connection con, String[] sql, boolean newdb) throws SQLException {
        if (sql != null && sql.length > 0) {
            boolean oldAutoCommit = con.getAutoCommit();
            if (!oldAutoCommit) {
                con.setAutoCommit(true);
            }
            try {
                Statement stmt = con.createStatement();
                try {
                    for (int i = 0; i < sql.length; ++i) {
                        if (sql[i].startsWith("message")) {
                            log.info((Object)("Data Migration " + sql[i]));
                            continue;
                        }
                        log.debug((Object)("Executing data migration statement: " + sql[i]));
                        try {
                            long start = System.currentTimeMillis();
                            int l = stmt.executeUpdate(sql[i]);
                            log.debug((Object)("   Done " + l + " rows in " + (System.currentTimeMillis() - start) + " ms"));
                            continue;
                        }
                        catch (SQLException ex) {
                            if (newdb) {
                                log.debug((Object)("Unsuccessful data migration statement: " + sql[i]));
                                log.debug((Object)("Cause: " + ex.getMessage()));
                                continue;
                            }
                            log.warn((Object)("Unsuccessful data migration statement: " + sql[i]));
                            log.debug((Object)("Cause: " + ex.getMessage()));
                        }
                    }
                }
                finally {
                    JdbcUtils.closeStatement((Statement)stmt);
                }
            }
            finally {
                if (!oldAutoCommit) {
                    con.setAutoCommit(false);
                }
            }
        }
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getScriptPattern() {
        return this.scriptPattern;
    }

    public void setScriptPattern(String scriptPattern) {
        this.scriptPattern = scriptPattern;
    }
}

