/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.service.impl;

import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.site.api.Site;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import uk.ac.cam.caret.sakai.rwiki.component.Messages;
import uk.ac.cam.caret.sakai.rwiki.component.service.impl.Decoded;
import uk.ac.cam.caret.sakai.rwiki.component.service.impl.XSLTEntityHandler;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiObjectService;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiCurrentObject;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiEntity;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiHistoryObject;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.utils.NameHelper;
import uk.ac.cam.caret.sakai.rwiki.utils.UserDisplayHelper;

public class XLSTChangesHandler
extends XSLTEntityHandler {
    private static final String RFC822DATE = "EEE, dd MMM yyyy HH:mm:ss Z";
    private RWikiObjectService rwikiObjectService = null;

    @Override
    public void outputContent(Entity entity, Entity sidebar, HttpServletRequest request, HttpServletResponse res) {
        if (!this.isAvailable()) {
            return;
        }
        if (!(entity instanceof RWikiEntity)) {
            return;
        }
        try {
            RWikiObject rwo;
            RWikiEntity rwe;
            Map rheaders = this.getResponseHeaders();
            if (rheaders != null) {
                for (Map.Entry entry : rheaders.entrySet()) {
                    String name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    res.setHeader(name, value);
                }
            }
            ContentHandler opch = this.getOutputHandler((OutputStream)res.getOutputStream());
            ContentHandler ch = null;
            ch = opch;
            Decoded decodedReference = this.decode(entity.getReference() + this.getMinorType());
            AttributesImpl dummyAttributes = new AttributesImpl();
            ch.startDocument();
            ch.startElement("", "entity-service", "entity-service", dummyAttributes);
            AttributesImpl propA = new AttributesImpl();
            propA.addAttribute("", "request-path-info", "request-path-info", "string", request.getPathInfo());
            propA.addAttribute("", "request-user", "request-user", "string", request.getRemoteUser());
            propA.addAttribute("", "request-protocol", "request-protocol", "string", request.getProtocol());
            propA.addAttribute("", "request-servername", "request-servername", "string", request.getServerName());
            propA.addAttribute("", "request-serverport", "request-serverport", "string", String.valueOf(request.getServerPort()));
            propA.addAttribute("", "request-url", "request-url", "string", String.valueOf(request.getRequestURL()));
            propA.addAttribute("", "server-url", "server-url", "string", ServerConfigurationService.getServerUrl());
            ch.startElement("", "request-properties", "request-properties", propA);
            this.addRequestAttributes(ch, request);
            this.addRequestParameters(ch, request);
            ch.endElement("", "request-properties", "request-properties");
            ch.startElement("", "entity", "entity", dummyAttributes);
            ch.startElement("", "properties", "properties", dummyAttributes);
            ResourceProperties rp = entity.getProperties();
            Iterator i = rp.getPropertyNames();
            while (i.hasNext()) {
                Object key = i.next();
                String name = String.valueOf(key);
                String value = String.valueOf(rp.getProperty(name));
                AttributesImpl propA2 = new AttributesImpl();
                this.addPropertyElement(name, value, ch);
            }
            this.addPropertyElement("_handler", " XSLTEntity Handler", ch);
            Site site = (Site)this.m_siteService.getEntity(EntityManager.newReference((String)decodedReference.getContext()));
            String title = site != null ? site.getTitle() : decodedReference.getContext();
            this.addPropertyElement("_siteDisplay", title, ch);
            this.addPropertyElement("_container", decodedReference.getContainer(), ch);
            if (entity instanceof RWikiEntity) {
                rwe = (RWikiEntity)entity;
                if (!rwe.isContainer()) {
                    rwo = rwe.getRWikiObject();
                    title = Messages.getString("XLSTChangesHandler.19") + title + ":" + NameHelper.localizeName((String)rwo.getName(), (String)decodedReference.getContext());
                } else {
                    title = decodedReference.getContainer() != null && decodedReference.getContainer().length() > 1 ? Messages.getString("XLSTChangesHandler.21") + title + ":" + decodedReference.getContainer().substring(1) : Messages.getString("XLSTChangesHandler.23") + title;
                }
                this.addPropertyElement("_title", title, ch);
            }
            this.addPropertyElement("_description", ServerConfigurationService.getString((String)"ui.service"), ch);
            SimpleDateFormat sd = new SimpleDateFormat(RFC822DATE);
            this.addPropertyElement("_datestamp", sd.format(new Date()), ch);
            ch.endElement("", "properties", "properties");
            if (entity instanceof RWikiEntity) {
                rwe = (RWikiEntity)entity;
                if (!rwe.isContainer()) {
                    rwo = rwe.getRWikiObject();
                    ch.startElement("", "rendered-content", "rendered-content", dummyAttributes);
                    this.renderToXML(rwo, ch, true, true);
                    ch.endElement("", "rendered-content", "rendered-content");
                    ch.startElement("", "changes", "changes", dummyAttributes);
                    this.changeHistoryToXML(rwo, ch);
                    ch.endElement("", "changes", "changes");
                } else {
                    ch.startElement("", "changes", "changes", dummyAttributes);
                    this.recentChangesToXML(rwe, ch);
                    ch.endElement("", "changes", "changes");
                }
            }
            ch.endElement("", "entity", "xmlservice");
            ch.endElement("", "entity-service", "xmlservice");
            ch.endDocument();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("Failed to serialise " + ex.getLocalizedMessage(), ex);
        }
    }

    private void addPropertyElement(String property, String value, ContentHandler ch) throws SAXException {
        AttributesImpl propA = new AttributesImpl();
        propA.addAttribute("", "name", "name", "string", property);
        this.addElement(ch, "", "property", "property", propA, value);
    }

    public void changeHistoryToXML(RWikiObject rwo, ContentHandler ch) throws Exception {
        if (!this.isAvailable()) {
            return;
        }
        String name = rwo.getName();
        String localSpace = NameHelper.localizeSpace((String)name);
        String aliasSpace = this.m_siteAlias ? NameHelper.aliasSpace((String)localSpace) : localSpace;
        AttributesImpl propA = new AttributesImpl();
        propA.addAttribute("", "eid", "eid", "string", rwo.getId());
        String pageName = NameHelper.localizeName((String)name, (String)localSpace);
        name = aliasSpace + "/" + pageName;
        propA.addAttribute("", "name", "name", "string", name + "@" + rwo.getRevision());
        propA.addAttribute("", "local-name", "local-name", "string", NameHelper.localizeName((String)rwo.getName(), (String)rwo.getRealm()));
        propA.addAttribute("", "owner", "owner", "string", rwo.getOwner());
        propA.addAttribute("", "owner", "pagerealm", "string", rwo.getRealm());
        propA.addAttribute("", "referenced", "referenced", "string", rwo.getReferenced());
        propA.addAttribute("", "sha1", "sha1", "string", rwo.getSha1());
        propA.addAttribute("", "last-edited-by", "last-edited-by", "string", rwo.getUser());
        propA.addAttribute("", "user-display", "user-display", "string", UserDisplayHelper.formatDisplayName((String)rwo.getUser(), (String)rwo.getRealm()));
        propA.addAttribute("", "revision", "revision", "string", String.valueOf(rwo.getRevision()));
        SimpleDateFormat sd = new SimpleDateFormat(RFC822DATE);
        propA.addAttribute("", "last-modified", "last-modified", "string", sd.format(rwo.getVersion()));
        ch.startElement("", "change", "change", propA);
        this.renderToXML(rwo, ch, true, true);
        ch.endElement("", "change", "change");
        List changes = this.rwikiObjectService.findRWikiHistoryObjectsInReverse(rwo);
        if (changes == null) {
            return;
        }
        for (RWikiHistoryObject rwco : changes) {
            propA = new AttributesImpl();
            propA.addAttribute("", "eid", "eid", "string", rwco.getId());
            name = rwco.getName();
            pageName = NameHelper.localizeName((String)name, (String)localSpace);
            name = aliasSpace + "/" + pageName;
            propA.addAttribute("", "name", "name", "string", name + "@" + rwco.getRevision());
            propA.addAttribute("", "local-name", "local-name", "string", NameHelper.localizeName((String)rwo.getName(), (String)rwo.getRealm()));
            propA.addAttribute("", "owner", "owner", "string", rwco.getOwner());
            propA.addAttribute("", "owner", "pagerealm", "string", rwco.getRealm());
            propA.addAttribute("", "referenced", "referenced", "string", rwco.getReferenced());
            propA.addAttribute("", "sha1", "sha1", "string", rwco.getSha1());
            propA.addAttribute("", "last-edited-by", "last-edited-by", "string", rwco.getUser());
            propA.addAttribute("", "user-display", "user-display", "string", UserDisplayHelper.formatDisplayName((String)rwco.getUser(), (String)rwco.getRealm()));
            propA.addAttribute("", "revision", "revision", "string", String.valueOf(rwco.getRevision()));
            propA.addAttribute("", "last-modified", "last-modified", "string", sd.format(rwco.getVersion()));
            ch.startElement("", "change", "change", propA);
            this.renderToXML((RWikiObject)rwco, ch, true, true);
            ch.endElement("", "change", "change");
        }
    }

    public void recentChangesToXML(RWikiEntity rwe, ContentHandler ch) throws Exception {
        if (!this.isAvailable()) {
            return;
        }
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(new Date());
        g.add(1, -1);
        Decoded d = this.decode(rwe.getReference() + this.getMinorType());
        String basepath = d.getContext() + d.getContainer();
        List changes = this.rwikiObjectService.findAllChangedSince(g.getTime(), basepath);
        Iterator i = changes.iterator();
        for (int nchanges = 0; i.hasNext() && nchanges < 20; ++nchanges) {
            RWikiCurrentObject rwco = (RWikiCurrentObject)i.next();
            AttributesImpl propA = new AttributesImpl();
            propA.addAttribute("", "eid", "eid", "string", rwco.getId());
            propA.addAttribute("", "name", "name", "string", rwco.getName());
            propA.addAttribute("", "local-name", "local-name", "string", NameHelper.localizeName((String)rwco.getName(), (String)rwco.getRealm()));
            propA.addAttribute("", "owner", "owner", "string", rwco.getOwner());
            propA.addAttribute("", "pagerealm", "pagerealm", "string", rwco.getRealm());
            propA.addAttribute("", "referenced", "referenced", "string", rwco.getReferenced());
            propA.addAttribute("", "sha1", "sha1", "string", rwco.getSha1());
            propA.addAttribute("", "last-edited-by", "last-edited-by", "string", rwco.getUser());
            propA.addAttribute("", "user-display", "user-display", "string", UserDisplayHelper.formatDisplayName((String)rwco.getUser(), (String)rwco.getRealm()));
            propA.addAttribute("", "revision", "revision", "string", String.valueOf(rwco.getRevision()));
            SimpleDateFormat sd = new SimpleDateFormat(RFC822DATE);
            propA.addAttribute("", "last-modified", "last-modified", "string", sd.format(rwco.getVersion()));
            ch.startElement("", "change", "change", propA);
            this.renderToXML((RWikiObject)rwco, ch, true, true);
            ch.endElement("", "change", "change");
        }
    }

    public RWikiObjectService getRwikiObjectService() {
        return this.rwikiObjectService;
    }

    public void setRwikiObjectService(RWikiObjectService rwikiObjectService) {
        this.rwikiObjectService = rwikiObjectService;
    }
}

