/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.dao.impl;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import uk.ac.cam.caret.sakai.rwiki.model.RWikiHistoryObjectContentImpl;
import uk.ac.cam.caret.sakai.rwiki.service.api.dao.RWikiObjectContentDao;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiHistoryObjectContent;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObjectContent;
import uk.ac.cam.caret.sakai.rwiki.utils.TimeLogger;

public class RWikiHistoryObjectContentDaoImpl
extends HibernateDaoSupport
implements RWikiObjectContentDao {
    private static Log log = LogFactory.getLog(RWikiHistoryObjectContentDaoImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RWikiObjectContent getContentObject(final RWikiObject parent) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(RWikiHistoryObjectContent.class).add((Criterion)Expression.eq((String)"rwikiid", (Object)parent.getId())).list();
                }
            };
            List found = (List)this.getHibernateTemplate().execute(callback);
            if (found.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found " + found.size() + " objects with id " + parent.getId()));
                }
                RWikiObjectContent rWikiObjectContent = null;
                return rWikiObjectContent;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + found.size() + " objects with name " + parent.getId() + " returning most recent one."));
            }
            RWikiObjectContent rWikiObjectContent = (RWikiObjectContent)found.get(0);
            return rWikiObjectContent;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("RWikiHistroyObjectContentDaoImpl.getContentObject: " + parent.getId()), (long)start, (long)finish);
        }
    }

    public RWikiObjectContent createContentObject(RWikiObject parent) {
        RWikiHistoryObjectContentImpl rwco = new RWikiHistoryObjectContentImpl();
        rwco.setRwikiid(parent.getId());
        return rwco;
    }

    public void update(RWikiObjectContent content) {
        RWikiHistoryObjectContentImpl impl = (RWikiHistoryObjectContentImpl)content;
        this.getHibernateTemplate().saveOrUpdate((Object)impl);
    }
}

