/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.macros;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.radeox.api.macro.MacroParameter;
import org.radeox.macro.BaseMacro;
import org.sakaiproject.time.cover.TimeService;
import org.sakaiproject.util.ResourceLoader;
import uk.ac.cam.caret.sakai.rwiki.component.Messages;
import uk.ac.cam.caret.sakai.rwiki.component.radeox.service.impl.SpecializedRenderContext;
import uk.ac.cam.caret.sakai.rwiki.component.radeox.service.impl.SpecializedRenderEngine;
import uk.ac.cam.caret.sakai.rwiki.service.api.PageLinkRenderer;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiObjectService;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.service.exception.PermissionException;
import uk.ac.cam.caret.sakai.rwiki.utils.NameHelper;
import uk.ac.cam.caret.sakai.rwiki.utils.UserDisplayHelper;

public class RecentChangesMacro
extends BaseMacro {
    public String[] getParamDescription() {
        return new String[]{Messages.getString("RecentChangesMacro.0")};
    }

    public String getDescription() {
        return Messages.getString("RecentChangesMacro.1");
    }

    public String getName() {
        return "recent-changes";
    }

    public void execute(Writer writer, MacroParameter params) throws IllegalArgumentException, IOException {
        String dateAsString;
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, new ResourceLoader().getLocale());
        dateFormat.setTimeZone(TimeService.getLocalTimeZone());
        SpecializedRenderContext context = (SpecializedRenderContext)params.getContext();
        RWikiObjectService objectService = context.getObjectService();
        String realm = context.getRWikiObject().getRealm();
        SpecializedRenderEngine spRe = (SpecializedRenderEngine)context.getRenderEngine();
        PageLinkRenderer plr = spRe.getPageLinkRenderer();
        plr.setCachable(false);
        String localRenderSpace = spRe.getSpace();
        GregorianCalendar cal = new GregorianCalendar();
        cal.add(5, -30);
        Date since = cal.getTime();
        if (params.getLength() == 1 && (dateAsString = params.get("date", 0)) != null) {
            if (dateAsString.trim().endsWith("h")) {
                int nHours = Integer.parseInt(dateAsString.trim().substring(0, dateAsString.trim().length() - 1));
                cal = new GregorianCalendar();
                cal.add(10, -nHours);
                since = cal.getTime();
            } else if (dateAsString.trim().endsWith("d")) {
                int nDays = Integer.parseInt(dateAsString.trim().substring(0, dateAsString.trim().length() - 1));
                cal = new GregorianCalendar();
                cal.add(5, -nDays);
                since = cal.getTime();
            } else {
                SimpleDateFormat format = new SimpleDateFormat(Messages.getString("RecentChangesMacro.6"), new ResourceLoader().getLocale());
                format.setTimeZone(TimeService.getLocalTimeZone());
                try {
                    since = format.parse(dateAsString);
                }
                catch (ParseException e) {
                    writer.write(Messages.getString("RecentChangesMacro.7") + dateAsString + Messages.getString("RecentChangesMacro.8"));
                }
            }
        }
        writer.write(Messages.getString("RecentChangesMacro.9") + dateFormat.format(since) + "  </span>");
        try {
            List wikiObjects = objectService.findChangedSince(since, realm);
            writer.write("<div class=\"list\">");
            for (RWikiObject object : wikiObjects) {
                if (!objectService.checkRead(object)) continue;
                String linkName = NameHelper.localizeName((String)object.getName(), (String)localRenderSpace);
                StringBuffer buffer = new StringBuffer();
                spRe.appendLink(buffer, linkName, linkName, null, true);
                writer.write("\n* ");
                writer.write(buffer.toString());
                writer.write(Messages.getString("RecentChangesMacro.13") + dateFormat.format(object.getVersion()));
                writer.write(Messages.getString("RecentChangesMacro.14") + UserDisplayHelper.formatDisplayName((String)object.getUser(), (String)object.getRealm()));
            }
            writer.write("\n</div>");
        }
        catch (PermissionException e) {
            writer.write(Messages.getString("RecentChangesMacro.16"));
            writer.write(e.toString());
            e.printStackTrace(new PrintWriter(writer));
        }
    }
}

