/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.message;

import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.MessageService;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.dao.MessageDao;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.dao.PagePresenceDao;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.model.Message;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.model.PagePresence;

public class MessageServiceImpl
implements MessageService {
    private static Log log = LogFactory.getLog(MessageServiceImpl.class);
    private MessageDao messageDao;
    private PagePresenceDao pagePresenceDao;

    public void updatePresence(String session, String user, String page, String space) {
        PagePresence pp = this.pagePresenceDao.findBySession(session);
        if (pp != null) {
            pp.setUser(user);
            pp.setPagename(page);
            pp.setPagespace(space);
            pp.setLastseen(new Date());
            this.pagePresenceDao.update((Object)pp);
        } else {
            pp = this.pagePresenceDao.createPagePresence(page, space, session, user);
            this.pagePresenceDao.update((Object)pp);
        }
        log.debug((Object)("Page Presence " + space + ":" + page + ":" + user + ":" + session));
    }

    public void addMessage(String session, String user, String page, String space, String message) {
        Message messageobj = this.messageDao.createMessage(space, page, session, user, message);
        this.messageDao.update((Object)messageobj);
    }

    public List getSessionMessages(String session) {
        return this.messageDao.findBySession(session);
    }

    public List getMessagesInSpace(String space) {
        return this.messageDao.findBySpace(space);
    }

    public List getMessagesInPage(String space, String page) {
        return this.messageDao.findByPage(space, page);
    }

    public List getUsersInSpace(String space) {
        List l = this.pagePresenceDao.findBySpace(space);
        log.info((Object)("Found " + l.size() + " users in " + space));
        return l;
    }

    public List getUsersOnPage(String space, String page) {
        List l = this.pagePresenceDao.findByPage(space, page);
        log.info((Object)("Found " + l.size() + " users in " + space + " on " + page));
        return l;
    }

    public List getUsersInSpaceOnly(String pageSpace, String pageName) {
        log.info((Object)("Searching for users in " + pageSpace + " but not " + pageName));
        return this.pagePresenceDao.findBySpaceOnly(pageSpace, pageName);
    }

    public MessageDao getMessageDao() {
        return this.messageDao;
    }

    public void setMessageDao(MessageDao messageDao) {
        this.messageDao = messageDao;
    }

    public PagePresenceDao getPagePresenceDao() {
        return this.pagePresenceDao;
    }

    public void setPagePresenceDao(PagePresenceDao pagePresenceDao) {
        this.pagePresenceDao = pagePresenceDao;
    }
}

