/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.model.impl;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.cam.caret.sakai.rwiki.model.RWikiObjectImpl;
import uk.ac.cam.caret.sakai.rwiki.service.api.dao.RWikiObjectDao;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.DataMigrationAgent;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;

public class SHAHashMigration
implements DataMigrationAgent {
    private static Log log = LogFactory.getLog(SHAHashMigration.class);
    private String from;
    private String to;
    private RWikiObjectDao codao;
    private boolean background = false;

    public String migrate(String current, String target, boolean newdb) throws Exception {
        if (current != null && this.from == null || current != null && !current.equals(this.from)) {
            log.info((Object)("Skipping Migration for " + this.from + " to " + this.to));
            return current;
        }
        List rwikiObjects = this.codao.getAll();
        if (rwikiObjects != null) {
            long start = System.currentTimeMillis();
            for (RWikiObject rwo : rwikiObjects) {
                long start2 = System.currentTimeMillis();
                String hash = rwo.getSha1();
                if (hash != null && hash.length() != 0) continue;
                hash = RWikiObjectImpl.computeSha1((String)rwo.getContent());
                rwo.setSha1(hash);
                log.info((Object)(" Hash took " + (System.currentTimeMillis() - start2) + " ms for " + rwo.getName() + " revision " + rwo.getRevision()));
                this.codao.updateObject(rwo);
            }
            log.info((Object)(" Sha1 Conversion took " + (System.currentTimeMillis() - start) + " ms for " + rwikiObjects.size() + " items"));
        }
        log.info((Object)("Done Migration for " + this.from + " to " + this.to));
        return this.to;
    }

    public RWikiObjectDao getRwikiObjectDao() {
        return this.codao;
    }

    public void setRwikiObjectDao(RWikiObjectDao codao) {
        this.codao = codao;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public boolean isBackground() {
        return this.background;
    }

    public void setBackground(boolean background) {
        this.background = background;
    }
}

