/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.service.impl;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.search.api.EntityContentProducer;
import org.sakaiproject.search.api.SearchIndexBuilder;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.search.api.SearchUtils;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.sakaiproject.search.util.HTMLParser;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiObjectService;
import uk.ac.cam.caret.sakai.rwiki.service.api.RenderService;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiEntity;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.utils.NameHelper;

public class RWikiEntityContentProducer
implements EntityContentProducer {
    private static Log log = LogFactory.getLog(RWikiEntityContentProducer.class);
    private RenderService renderService = null;
    private RWikiObjectService objectService = null;
    private SearchService searchService = null;
    private SearchIndexBuilder searchIndexBuilder = null;
    private EntityManager entityManager = null;

    public void init() {
        try {
            ComponentManager cm = org.sakaiproject.component.cover.ComponentManager.getInstance();
            this.renderService = (RenderService)this.load(cm, RenderService.class.getName());
            this.objectService = (RWikiObjectService)this.load(cm, RWikiObjectService.class.getName());
            this.searchService = (SearchService)this.load(cm, SearchService.class.getName());
            this.searchIndexBuilder = (SearchIndexBuilder)this.load(cm, SearchIndexBuilder.class.getName());
            this.entityManager = (EntityManager)this.load(cm, EntityManager.class.getName());
            if ("true".equals(ServerConfigurationService.getString((String)"search.enable", (String)"false"))) {
                this.searchService.registerFunction("wiki.new");
                this.searchService.registerFunction("wiki.revise");
                this.searchIndexBuilder.registerEntityContentProducer((EntityContentProducer)this);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to init ", t);
        }
    }

    private Object load(ComponentManager cm, String name) {
        Object o = cm.get(name);
        if (o == null) {
            log.error((Object)("Cant find Spring component named " + name));
        }
        return o;
    }

    public boolean isContentFromReader(String cr) {
        return false;
    }

    public Reader getContentReader(String reference) {
        return null;
    }

    public String getContent(String reference) {
        Reference ref = this.getReference(reference);
        Entity cr = ref.getEntity();
        RWikiEntity rwe = (RWikiEntity)cr;
        RWikiObject rwo = rwe.getRWikiObject();
        String pageName = rwo.getName();
        String pageSpace = NameHelper.localizeSpace((String)pageName, (String)rwo.getRealm());
        String renderedPage = this.renderService.renderPage(rwo, pageSpace, this.objectService.getComponentPageLinkRender(pageSpace, true));
        StringBuilder sb = new StringBuilder();
        HTMLParser hp = new HTMLParser(renderedPage);
        while (hp.hasNext()) {
            SearchUtils.appendCleanString((String)hp.next(), (StringBuilder)sb);
        }
        String r = sb.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Wiki.getContent:" + reference + ":" + r));
        }
        return r;
    }

    public String getTitle(String reference) {
        Reference ref = this.getReference(reference);
        Entity cr = ref.getEntity();
        RWikiEntity rwe = (RWikiEntity)cr;
        RWikiObject rwo = rwe.getRWikiObject();
        String r = SearchUtils.appendCleanString((String)rwo.getName(), null).toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Wiki.getTitle:" + reference + ":" + r));
        }
        return r;
    }

    public boolean matches(String reference) {
        try {
            Reference ref = this.getReference(reference);
            EntityProducer ep = ref.getEntityProducer();
            return ep instanceof RWikiObjectService;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public List getAllContent() {
        List allPages = this.objectService.findAllPageNames();
        ArrayList<String> l = new ArrayList<String>();
        for (String pageName : allPages) {
            String reference = this.objectService.createReference(pageName);
            l.add(reference);
        }
        return l;
    }

    public Integer getAction(Event event) {
        String eventName = event.getEvent();
        if ("wiki.new".equals(eventName) || "wiki.revise".equals(eventName)) {
            return SearchBuilderItem.ACTION_ADD;
        }
        if ("wiki.delete".equals(eventName)) {
            return SearchBuilderItem.ACTION_DELETE;
        }
        return SearchBuilderItem.ACTION_UNKNOWN;
    }

    public boolean matches(Event event) {
        return !SearchBuilderItem.ACTION_UNKNOWN.equals(this.getAction(event));
    }

    public String getTool() {
        return "wiki";
    }

    public String getUrl(String reference) {
        Reference ref = this.getReference(reference);
        return ref.getUrl() + "html";
    }

    private String getSiteId(Reference ref) {
        int slash;
        String context = ref.getContext();
        if (context.startsWith("/site/")) {
            context = context.substring("/site/".length());
        }
        if (context.startsWith("/")) {
            context = context.substring(1);
        }
        if ((slash = context.indexOf("/")) > 0) {
            context = context.substring(0, slash);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Wiki.getSiteId" + ref + ":" + context));
        }
        return context;
    }

    public String getSiteId(String resourceName) {
        String r = this.getSiteId(this.entityManager.newReference(resourceName));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Wiki.getSiteId" + resourceName + ":" + r));
        }
        return r;
    }

    public List getSiteContent(String context) {
        List allPages = this.objectService.findRWikiSubPages("/site/" + context);
        ArrayList<String> l = new ArrayList<String>();
        for (RWikiObject page : allPages) {
            String reference = this.objectService.createReference(page.getName());
            l.add(reference);
        }
        return l;
    }

    public Iterator getSiteContentIterator(String context) {
        List allPages = this.objectService.findRWikiSubPages("/site/" + context);
        final Iterator allPagesIterator = allPages.iterator();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return allPagesIterator.hasNext();
            }

            public Object next() {
                RWikiObject page = (RWikiObject)allPagesIterator.next();
                return RWikiEntityContentProducer.this.objectService.createReference(page.getName());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported");
            }
        };
    }

    public boolean isForIndex(String reference) {
        try {
            Reference ref = this.getReference(reference);
            RWikiEntity rwe = (RWikiEntity)ref.getEntity();
            RWikiObject rwo = rwe.getRWikiObject();
            String pageName = rwo.getName();
            String pageSpace = NameHelper.localizeSpace((String)pageName, (String)rwo.getRealm());
            if (this.objectService.exists(pageName, pageSpace)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean canRead(String reference) {
        try {
            Reference ref = this.getReference(reference);
            RWikiEntity rwe = (RWikiEntity)ref.getEntity();
            RWikiObject rwo = rwe.getRWikiObject();
            return this.objectService.checkRead(rwo);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Map getCustomProperties(String ref) {
        return null;
    }

    public String getCustomRDF(String ref) {
        return null;
    }

    private Reference getReference(String reference) {
        try {
            Reference r = this.entityManager.newReference(reference);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Wiki.getReference:" + reference + ":" + r));
            }
            return r;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private EntityProducer getProducer(Reference ref) {
        try {
            return ref.getEntityProducer();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getId(String reference) {
        try {
            String r = this.getReference(reference).getId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Wiki.getId:" + reference + ":" + r));
            }
            return r;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public String getSubType(String reference) {
        try {
            String r = this.getReference(reference).getSubType();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Wiki.getSubType:" + reference + ":" + r));
            }
            return r;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public String getType(String reference) {
        try {
            String r = this.getReference(reference).getType();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Wiki.getType:" + reference + ":" + r));
            }
            return r;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public String getContainer(String reference) {
        try {
            String r = this.getReference(reference).getContainer();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Wiki.getContainer:" + reference + ":" + r));
            }
            return r;
        }
        catch (Exception ex) {
            return "";
        }
    }
}

