/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.service.impl;

import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.email.api.DigestService;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.NotificationAction;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.thread_local.api.ThreadLocalManager;
import org.sakaiproject.time.api.TimeService;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.util.ResourceLoader;
import org.sakaiproject.util.SiteEmailNotification;
import org.sakaiproject.util.api.FormattedText;
import uk.ac.cam.caret.sakai.rwiki.component.service.impl.ComponentPageLinkRenderImpl;
import uk.ac.cam.caret.sakai.rwiki.service.api.PageLinkRenderer;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiObjectService;
import uk.ac.cam.caret.sakai.rwiki.service.api.RenderService;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiEntity;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.PreferenceService;
import uk.ac.cam.caret.sakai.rwiki.utils.DigestHtml;
import uk.ac.cam.caret.sakai.rwiki.utils.NameHelper;

public class SiteEmailNotificationRWiki
extends SiteEmailNotification {
    private static Log log = LogFactory.getLog(SiteEmailNotificationRWiki.class);
    private RenderService renderService = null;
    private RWikiObjectService rwikiObjectService = null;
    private PreferenceService preferenceService = null;
    private SiteService siteService;
    private SecurityService securityService;
    private EntityManager entityManager;
    private ThreadLocalManager threadLocalManager;
    private TimeService timeService;
    private DigestService digestService;
    private UserDirectoryService userDirectoryService;
    private FormattedText formattedText = (FormattedText)ComponentManager.get(FormattedText.class);
    private ToolManager toolManager = (ToolManager)ComponentManager.get(ToolManager.class);
    private static ResourceLoader rl = new ResourceLoader("uk.ac.cam.caret.sakai.rwiki.component.bundle.Messages");

    public SiteEmailNotificationRWiki(RWikiObjectService rwikiObjectService, RenderService renderService, PreferenceService preferenceService, SiteService siteService, SecurityService securityService, EntityManager entityManager, ThreadLocalManager threadLocalManager, TimeService timeService, DigestService digestService, UserDirectoryService userDirectoryService) {
        this.renderService = renderService;
        this.rwikiObjectService = rwikiObjectService;
        this.preferenceService = preferenceService;
        this.siteService = siteService;
        this.securityService = securityService;
        this.entityManager = entityManager;
        this.threadLocalManager = threadLocalManager;
        this.timeService = timeService;
        this.digestService = digestService;
        this.userDirectoryService = userDirectoryService;
    }

    public SiteEmailNotificationRWiki(RWikiObjectService rwikiObjectService, RenderService renderService, PreferenceService preferenceService, SiteService siteService, SecurityService securityService, EntityManager entityManager, ThreadLocalManager threadLocalManager, TimeService timeService, DigestService digestService, UserDirectoryService userDirectoryService, String siteId) {
        super(siteId);
        this.renderService = renderService;
        this.rwikiObjectService = rwikiObjectService;
        this.preferenceService = preferenceService;
        this.siteService = siteService;
        this.securityService = securityService;
        this.entityManager = entityManager;
        this.threadLocalManager = threadLocalManager;
        this.timeService = timeService;
        this.digestService = digestService;
        this.userDirectoryService = userDirectoryService;
    }

    public NotificationAction getClone() {
        SiteEmailNotificationRWiki clone = new SiteEmailNotificationRWiki(this.rwikiObjectService, this.renderService, this.preferenceService, this.siteService, this.securityService, this.entityManager, this.threadLocalManager, this.timeService, this.digestService, this.userDirectoryService);
        clone.set((NotificationAction)this);
        return clone;
    }

    protected String getSiteId(String context) {
        int il;
        if (context.startsWith("/site/")) {
            context = context.substring("/site/".length());
        }
        if ((il = context.indexOf("/")) != -1) {
            context = context.substring(0, il);
        }
        return context;
    }

    protected String getPlainMessage(Event event) {
        MessageContent mc = this.getMessageContent(event);
        StringBuilder message = new StringBuilder();
        message.append(rl.getString("SiteEmailNotificationRWiki.5")).append(mc.title).append(rl.getString("SiteEmailNotificationRWiki.6")).append(ServerConfigurationService.getString((String)"ui.service", (String)"Sakai")).append(" (").append(ServerConfigurationService.getPortalUrl()).append(")  \n\n").append(rl.getString("SiteEmailNotificationRWiki.13")).append(mc.title).append("\" > ").append(this.getWikiToolPageName(event)).append("  > ").append(mc.localName).append("\n").append(rl.getString("SiteEmailNotificationRWiki.16")).append(mc.moddate).append("\n").append(rl.getString("SiteEmailNotificationRWiki.18")).append(mc.user).append("\n \n").append(rl.getString("SiteEmailNotificationRWiki.19")).append(mc.localName).append(" ").append(mc.url).append(" \n \n").append(rl.getString("SiteEmailNotificationRWiki.4")).append(mc.content).append("\n");
        log.debug((Object)("Message is " + message));
        return message.toString();
    }

    protected String getHtmlMessage(Event event) {
        MessageContent mc = this.getMessageContent(event);
        StringBuilder sb = new StringBuilder();
        sb.append(rl.getString("SiteEmailNotificationRWiki.5")).append(mc.title).append(rl.getString("SiteEmailNotificationRWiki.6")).append(ServerConfigurationService.getString((String)"ui.service", (String)"Sakai")).append(" (").append(ServerConfigurationService.getPortalUrl()).append(")  \n\n").append(rl.getString("SiteEmailNotificationRWiki.13")).append(mc.title).append("\" > ").append(this.getWikiToolPageName(event)).append("  > ").append(mc.localName).append("\n").append(rl.getString("SiteEmailNotificationRWiki.16")).append(mc.moddate).append("\n").append(rl.getString("SiteEmailNotificationRWiki.18")).append(mc.user).append("\n \n").append(rl.getString("SiteEmailNotificationRWiki.19")).append(mc.localName).append(" ").append(mc.url).append(" \n \n").append(rl.getString("SiteEmailNotificationRWiki.4")).append(mc.content).append("\n");
        String message = this.formattedText.escapeHtml(sb.toString(), true);
        log.debug((Object)("Message is " + message));
        return message;
    }

    private MessageContent getMessageContent(Event event) {
        MessageContent messageContent = new MessageContent();
        Reference ref = this.entityManager.newReference(event.getResource());
        ResourceProperties props = ref.getProperties();
        String siteId = this.getSite() != null ? this.getSite() : this.getSiteId(ref.getContext());
        try {
            Site site = this.siteService.getSite(siteId);
            messageContent.title = site.getTitle();
        }
        catch (IdUnusedException e) {
            messageContent.title = siteId;
        }
        messageContent.url = ref.getUrl() + "html";
        String pageName = props.getProperty("name");
        String realm = props.getProperty("realm");
        messageContent.localName = NameHelper.localizeName((String)pageName, (String)realm);
        String userId = props.getProperty("user");
        try {
            User u = this.userDirectoryService.getUser(userId);
            messageContent.user = u.getDisplayId();
        }
        catch (UserNotDefinedException e) {
            messageContent.user = userId;
        }
        Date date = new Date(Long.parseLong(props.getProperty("version")));
        messageContent.moddate = DateFormat.getDateInstance(0, rl.getLocale()).format(date);
        try {
            RWikiEntity rwe = (RWikiEntity)this.rwikiObjectService.getEntity(ref);
            RWikiObject rwikiObject = rwe.getRWikiObject();
            String pageSpace = NameHelper.localizeSpace((String)pageName, (String)realm);
            ComponentPageLinkRenderImpl cplr = new ComponentPageLinkRenderImpl(pageSpace, true);
            messageContent.contentHTML = this.renderService.renderPage(rwikiObject, pageSpace, (PageLinkRenderer)cplr);
            messageContent.content = DigestHtml.digest((String)messageContent.contentHTML);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return messageContent;
    }

    protected String plainTextContent(Event event) {
        return this.getPlainMessage(event);
    }

    protected String htmlContent(Event event) {
        return this.getHtmlMessage(event);
    }

    protected List<String> getHeaders(Event e) {
        List rv = super.getHeaders(e);
        Reference ref = this.entityManager.newReference(e.getResource());
        ResourceProperties props = ref.getProperties();
        String pageName = props.getProperty("name");
        String realm = props.getProperty("realm");
        String localName = NameHelper.localizeName((String)pageName, (String)realm);
        StringBuilder subjectHeader = new StringBuilder();
        subjectHeader.append("Subject: ").append(rl.getString("SiteEmailNotificationRWiki.27")).append(localName).append(rl.getString("SiteEmailNotificationRWiki.28"));
        rv.add(subjectHeader.toString());
        rv.add(this.getFrom(e));
        rv.add(this.getTo(e));
        return rv;
    }

    protected String getTag(String title, boolean shouldUseHtml) {
        StringBuilder rv = new StringBuilder();
        if (shouldUseHtml) {
            rv.append("<hr/><br/>").append(rl.getString("SiteEmailNotificationRWiki.30")).append(ServerConfigurationService.getString((String)"ui.service", (String)"Sakai")).append(" (<a href=\"").append(ServerConfigurationService.getPortalUrl()).append("\">").append(ServerConfigurationService.getPortalUrl()).append("</a>").append(rl.getString("SiteEmailNotificationRWiki.3")).append(rl.getString("SiteEmailNotificationRWiki.35")).append(rl.getString("SiteEmailNotificationRWiki.36")).append("<br/>");
        } else {
            rv.append("----------------------\n").append(rl.getString("SiteEmailNotificationRWiki.30")).append(ServerConfigurationService.getString((String)"ui.service", (String)"Sakai")).append(" (").append(ServerConfigurationService.getPortalUrl()).append(rl.getString("SiteEmailNotificationRWiki.3")).append(rl.getString("SiteEmailNotificationRWiki.35")).append(rl.getString("SiteEmailNotificationRWiki.36"));
        }
        return rv.toString();
    }

    protected int getOption(User user, String notificationId, String resourceFilter, int eventPriority, Event event) {
        String resourceReference = event.getResource();
        if (resourceReference == null || !resourceReference.startsWith("/wiki") || resourceReference.length() == "/wiki".length()) {
            return 1;
        }
        resourceReference = resourceReference.substring("/wiki".length(), resourceReference.lastIndexOf(46));
        String preference = this.preferenceService.findPreferenceAt(user.getId(), resourceReference, "mail.notify");
        if (preference == null || "".equals(preference)) {
            return 1;
        }
        if ("none".equals(preference)) {
            return 1;
        }
        if ("digest".equals(preference)) {
            return 2;
        }
        if ("separate".equals(preference)) {
            return 3;
        }
        return 1;
    }

    protected List getRecipients(Event event) {
        Reference ref = this.entityManager.newReference(event.getResource());
        String siteId = this.getSite();
        if (siteId == null) {
            siteId = this.getSiteId(ref.getContext());
        }
        try {
            Site site = this.siteService.getSite(siteId);
            String ability = "site.visit";
            if (!site.isPublished()) {
                ability = "site.visit.unp";
            }
            List users = this.securityService.unlockUsers(ability, ref.getReference());
            if (this.getResourceAbility() != null) {
                List users2 = this.securityService.unlockUsers(this.getResourceAbility(), ref.getReference());
                users.retainAll(users2);
            }
            this.addSpecialRecipients(users, ref);
            return users;
        }
        catch (Exception any) {
            log.error((Object)"Exception in getRecipients()", (Throwable)any);
            return new Vector();
        }
    }

    private String getWikiToolPageName(Event event) {
        String toolName = "Wiki";
        Tool tool = this.toolManager.getCurrentTool();
        if (tool != null) {
            toolName = tool.getTitle();
            String toolId = tool.getId();
            String siteId = this.getSite();
            if (StringUtils.isEmpty((String)siteId)) {
                Reference ref = this.entityManager.newReference(event.getResource());
                siteId = this.getSiteId(ref.getContext());
            }
            if (StringUtils.isNotEmpty((String)siteId)) {
                try {
                    Site site = this.siteService.getSite(siteId);
                    List pages = site.getPages();
                    for (SitePage p : pages) {
                        Collection toolConfigurations = p.getTools(new String[]{toolId});
                        if (!CollectionUtils.isNotEmpty((Collection)toolConfigurations)) continue;
                        toolName = p.getTitle();
                        break;
                    }
                }
                catch (IdUnusedException e) {
                    log.error((Object)"Site not found while getting wiki name", (Throwable)e);
                }
            }
        }
        return toolName;
    }

    public class MessageContent {
        public String title;
        public String user;
        public String content;
        public String moddate;
        public String localName;
        public String url;
        public String contentHTML;
    }
}

