/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.radeox.service.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.radeox.api.engine.ImageRenderEngine;
import org.radeox.api.engine.IncludeRenderEngine;
import org.radeox.api.engine.RenderEngine;
import org.radeox.api.engine.WikiRenderEngine;
import org.radeox.api.engine.context.RenderContext;
import org.radeox.api.macro.Macro;
import org.radeox.macro.MacroRepository;
import uk.ac.cam.caret.sakai.rwiki.service.api.PageLinkRenderer;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiObjectService;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiCurrentObject;

public class SpecializedRenderEngine
implements ImageRenderEngine,
WikiRenderEngine,
RenderEngine,
IncludeRenderEngine {
    private RenderEngine renderEngine;
    private RWikiObjectService objectService;
    private PageLinkRenderer plr;
    private String space;
    private String externalImageLink;

    public SpecializedRenderEngine(RenderEngine renderEngine, RWikiObjectService objectService, PageLinkRenderer plr, String space, String externalImageLink) {
        this.externalImageLink = externalImageLink;
        this.plr = plr;
        this.space = space;
        this.objectService = objectService;
        this.renderEngine = renderEngine;
    }

    public void appendLink(StringBuffer buffer, String name, String view, String anchor, boolean autoGenerated) {
        this.plr.appendLink(buffer, name, view, anchor, autoGenerated);
    }

    public void appendLink(StringBuffer buffer, String name, String view) {
        this.plr.appendLink(buffer, name, view);
    }

    public void appendLink(StringBuffer buffer, String name, String view, String anchor) {
        this.plr.appendLink(buffer, name, view, anchor);
    }

    public void appendCreateLink(StringBuffer buffer, String name, String view) {
        this.plr.appendCreateLink(buffer, name, view);
    }

    public String getSpace() {
        return this.space;
    }

    public boolean exists(String name) {
        return this.objectService.exists(name, this.space);
    }

    public boolean showCreate() {
        return true;
    }

    public String getName() {
        return this.renderEngine.getName();
    }

    public String render(Reader in, RenderContext context) throws IOException {
        return this.renderEngine.render(in, context);
    }

    public String render(String content, RenderContext context) {
        return this.renderEngine.render(content, context);
    }

    public void render(Writer out, String content, RenderContext context) throws IOException {
        this.renderEngine.render(out, content, context);
    }

    public String getExternalImageLink() {
        return this.externalImageLink;
    }

    public RenderEngine getRenderEngine() {
        return this.renderEngine;
    }

    public void setRenderEngine(RenderEngine deligate) {
        this.renderEngine = deligate;
    }

    public RWikiObjectService getObjectService() {
        return this.objectService;
    }

    public void setObjectService(RWikiObjectService objectService) {
        this.objectService = objectService;
    }

    public PageLinkRenderer getPageLinkRenderer() {
        return this.plr;
    }

    public void addMacro(Macro macro) {
        MacroRepository mr = MacroRepository.getInstance();
        mr.put(macro.getName(), (Object)macro);
    }

    public String include(String name, RenderContext context) {
        RWikiCurrentObject rwo = this.objectService.getRWikiObject(name, this.space);
        return this.render(rwo.getContent(), context);
    }
}

