/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.service.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import uk.ac.cam.caret.sakai.rwiki.utils.NameHelper;

public class PageVisits {
    private static final int MAX_SIZE = 10;
    protected boolean m_siteAlias = true;
    private Stack<String> s = new Stack();

    public void addPage(String globalPageName) {
        this.s.remove(globalPageName);
        this.s.push(globalPageName);
        while (this.s.size() > 10) {
            this.s.remove(0);
        }
    }

    public List<String[]> getPageNames(String type) {
        ArrayList<String[]> l = new ArrayList<String[]>();
        if (this.s.size() > 0) {
            for (String pagename : this.s) {
                String[] pagespec = new String[2];
                String localSpace = NameHelper.localizeSpace((String)pagename);
                pagespec[1] = NameHelper.localizeName((String)pagename, (String)localSpace);
                if (this.m_siteAlias) {
                    String localAliasSpace = NameHelper.aliasSpace((String)localSpace);
                    pagespec[0] = "/wiki" + localAliasSpace + "/" + this.encode(pagespec[1]) + "." + type;
                } else {
                    pagespec[0] = "/wiki" + this.encode(pagename) + "." + type;
                }
                l.add(pagespec);
            }
        }
        return l;
    }

    private String encode(String toEncode) {
        try {
            String encoded = URLEncoder.encode(toEncode, "UTF-8");
            encoded = encoded.replaceAll("\\+", "%20").replaceAll("%2F", "/");
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 Encoding is not supported when encoding: " + toEncode + ": " + e.getMessage());
        }
    }
}

