/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.service.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.radeox.api.engine.RenderEngine;
import org.radeox.api.engine.context.RenderContext;
import org.sakaiproject.component.api.ComponentManager;
import uk.ac.cam.caret.sakai.rwiki.service.api.PageLinkRenderer;
import uk.ac.cam.caret.sakai.rwiki.service.api.RenderService;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.service.api.radeox.RenderContextFactory;
import uk.ac.cam.caret.sakai.rwiki.service.api.radeox.RenderEngineFactory;
import uk.ac.cam.caret.sakai.rwiki.utils.TimeLogger;

public class RenderServiceImpl
implements RenderService {
    private static Log log = LogFactory.getLog(RenderServiceImpl.class);
    private RenderEngineFactory renderEngineFactory;
    private RenderContextFactory renderContextFactory;

    public void init() {
        ComponentManager cm = org.sakaiproject.component.cover.ComponentManager.getInstance();
        this.renderEngineFactory = (RenderEngineFactory)this.load(cm, RenderEngineFactory.class.getName());
        this.renderContextFactory = (RenderContextFactory)this.load(cm, RenderContextFactory.class.getName());
    }

    private Object load(ComponentManager cm, String name) {
        Object o = cm.get(name);
        if (o == null) {
            log.error((Object)("Cant find Spring component named " + name));
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderPage(RWikiObject rwo, String pageSpace, PageLinkRenderer plr) {
        long start = System.currentTimeMillis();
        String renderedPage = null;
        try {
            RenderEngine renderEngine = this.renderEngineFactory.getRenderEngine(pageSpace, plr);
            RenderContext renderContext = this.renderContextFactory.getRenderContext(rwo, renderEngine);
            renderedPage = renderEngine.render(rwo.getContent(), renderContext);
            if (renderedPage.indexOf("<p ") < 0 && renderedPage.indexOf("</p>") < 0) {
                renderedPage = "<p class=\"paragraph\">" + renderedPage + "</p>";
            }
            String string = renderedPage;
            return string;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("Render: " + rwo.getName()), (long)start, (long)finish);
        }
    }
}

