/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.macros;

import java.io.IOException;
import java.io.Writer;
import org.radeox.api.macro.MacroParameter;
import org.radeox.macro.BaseMacro;
import uk.ac.cam.caret.sakai.rwiki.component.Messages;

public class ColorMacro
extends BaseMacro {
    private static final String COLOR_PARAM = "color";
    private static final String BACKGROUND_COLOR_PARAM = "bgcolor";

    public String getName() {
        return COLOR_PARAM;
    }

    public String[] getParamDescription() {
        return new String[]{Messages.getString("ColorMacro.2"), Messages.getString("ColorMacro.3")};
    }

    public String getDescription() {
        return Messages.getString("ColorMacro.4");
    }

    public void execute(Writer writer, MacroParameter params) throws IllegalArgumentException, IOException {
        writer.write("<span style='");
        String color = params.get(COLOR_PARAM);
        String backgroundColor = params.get(BACKGROUND_COLOR_PARAM);
        if (color == null) {
            color = params.get(0);
            backgroundColor = params.get(1);
        }
        writer.write(this.parse(color, "color: "));
        writer.write(this.parse(backgroundColor, "background: "));
        writer.write("'>");
        if (params.getContent() != null) {
            writer.write(params.getContent());
        }
        writer.write("</span>");
    }

    private String parse(String color, String cssClass) {
        if (color == null) {
            return "";
        }
        char[] disallowedChars = new char[]{':', ';', '/', '*', '{', '}', '\"', '\'', '\\'};
        for (int i = 0; i < disallowedChars.length; ++i) {
            if (color.indexOf(disallowedChars[i]) <= 0) continue;
            throw new IllegalArgumentException(Messages.getString("ColorMacro.1") + color + Messages.getString("ColorMacro.13"));
        }
        return cssClass + color + ';';
    }
}

