/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.radeox.service.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import org.radeox.api.engine.RenderEngine;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.api.engine.context.RenderContext;
import org.radeox.api.macro.Macro;
import org.radeox.engine.context.BaseInitialRenderContext;
import org.radeox.filter.Filter;
import org.radeox.filter.FilterPipe;
import org.radeox.filter.context.BaseFilterContext;
import org.radeox.filter.context.FilterContext;
import org.radeox.macro.MacroRepository;
import org.radeox.util.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RWikiBaseRenderEngine
implements RenderEngine {
    private static Logger log = LoggerFactory.getLogger(RWikiBaseRenderEngine.class);
    protected InitialRenderContext initialContext;
    protected FilterPipe fp;

    public RWikiBaseRenderEngine() {
        this((InitialRenderContext)new BaseInitialRenderContext());
    }

    public RWikiBaseRenderEngine(InitialRenderContext context) {
        this.initialContext = context;
    }

    public void init() {
        if (null == this.fp) {
            this.fp = new FilterPipe(this.initialContext);
            Iterator iterator = Service.providers(Filter.class);
            while (iterator.hasNext()) {
                try {
                    Filter filter = (Filter)iterator.next();
                    this.fp.addFilter(filter);
                    log.debug("Loaded filter: " + filter.getClass().getName());
                }
                catch (Exception e) {
                    log.warn("BaseRenderEngine: unable to load filter", (Throwable)e);
                }
            }
            this.fp.init();
        }
    }

    public String getName() {
        return "radeox";
    }

    public String render(String content, RenderContext context) {
        BaseFilterContext filterContext = new BaseFilterContext();
        filterContext.setRenderContext(context);
        return this.fp.filter(content, (FilterContext)filterContext);
    }

    public String render(Reader in, RenderContext context) throws IOException {
        String line;
        StringBuffer buffer = new StringBuffer();
        BufferedReader inputReader = new BufferedReader(in);
        while ((line = inputReader.readLine()) != null) {
            buffer.append(line);
        }
        return this.render(buffer.toString(), context);
    }

    public void render(Writer out, String content, RenderContext context) throws IOException {
        out.write(this.render(content, context));
    }

    public void addMacro(Macro macro) {
        MacroRepository mr = MacroRepository.getInstance();
        mr.put(macro.getName(), (Object)macro);
    }
}

