/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.service.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import uk.ac.cam.caret.sakai.rwiki.component.Messages;
import uk.ac.cam.caret.sakai.rwiki.component.service.impl.BaseEntityHandlerImpl;
import uk.ac.cam.caret.sakai.rwiki.component.service.impl.ComponentPageLinkRenderImpl;
import uk.ac.cam.caret.sakai.rwiki.component.service.impl.PageVisits;
import uk.ac.cam.caret.sakai.rwiki.component.service.impl.XSLTTransform;
import uk.ac.cam.caret.sakai.rwiki.service.api.PageLinkRenderer;
import uk.ac.cam.caret.sakai.rwiki.service.api.RenderService;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiEntity;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.utils.DigestHtml;
import uk.ac.cam.caret.sakai.rwiki.utils.NameHelper;
import uk.ac.cam.caret.sakai.rwiki.utils.SimpleCoverage;

public class XSLTEntityHandler
extends BaseEntityHandlerImpl {
    private static Logger log = LoggerFactory.getLogger(XSLTEntityHandler.class);
    private static ThreadLocal currentRequest = new ThreadLocal();
    private String anchorLinkFormat = null;
    private String standardLinkFormat = null;
    private String hrefTagFormat = null;
    private String xalan270ContentHandler = null;
    private RenderService renderService = null;
    private String authZPrefix = "";
    private String xslt = null;
    private boolean escaped = true;
    private String defaultStackTrace;
    private String errorFormat;
    private ThreadLocal transformerHolder = new ThreadLocal();
    private Map responseHeaders;
    private Map outputProperties;
    private Map<String, String> transformParameters;
    private EntityManager entityManager;
    private SAXParserFactory saxParserFactory;
    private SerializerFactory serializerFactory;
    private String breadCrumbParameter = "breadcrumb";
    private String breadCrumbParameterFormat = "?breadcrumb=0";
    protected boolean m_siteAlias = true;

    private Object load(ComponentManager cm, String name) {
        Object o = cm.get(name);
        if (o == null) {
            log.error("Cant find Spring component named " + name);
        }
        return o;
    }

    public String getDescription(Entity entity) {
        if (!this.isAvailable()) {
            return null;
        }
        if (!(entity instanceof RWikiEntity)) {
            return null;
        }
        return entity.getId();
    }

    public String getUrl(Entity entity) {
        if (!this.isAvailable()) {
            return null;
        }
        if (!(entity instanceof RWikiEntity)) {
            return null;
        }
        return entity.getUrl() + this.getMinorType();
    }

    public static HttpServletRequest getCurrentRequest() {
        return (HttpServletRequest)currentRequest.get();
    }

    public static void setCurrentRequest(HttpServletRequest request) {
        currentRequest.set(request);
    }

    public void outputContent(Entity entity, Entity sideBar, HttpServletRequest request, HttpServletResponse res) {
        if (!this.isAvailable()) {
            return;
        }
        if (!(entity instanceof RWikiEntity)) {
            return;
        }
        try {
            RWikiObject rwo;
            RWikiEntity rwe;
            boolean withBreadcrumbs;
            String skin = ServerConfigurationService.getString((String)"skin.default");
            String skinRepo = ServerConfigurationService.getString((String)"skin.repo");
            request.setAttribute("sakai.skin.repo", (Object)skinRepo);
            request.setAttribute("sakai.skin", (Object)skin);
            HttpSession s = request.getSession();
            PageVisits pageVisits = (PageVisits)s.getAttribute(XSLTEntityHandler.class.getName() + this.getMinorType() + "_visits");
            boolean bl = withBreadcrumbs = !"0".equals(request.getParameter(this.breadCrumbParameter));
            if (pageVisits == null) {
                pageVisits = new PageVisits();
                s.setAttribute(XSLTEntityHandler.class.getName() + this.getMinorType() + "_visits", (Object)pageVisits);
            }
            if (!(rwe = (RWikiEntity)entity).isContainer()) {
                RWikiObject rwo2 = rwe.getRWikiObject();
                pageVisits.addPage(rwo2.getName());
            }
            XSLTEntityHandler.setCurrentRequest(request);
            if (this.responseHeaders != null) {
                for (String name : this.responseHeaders.keySet()) {
                    String value = (String)this.responseHeaders.get(name);
                    res.setHeader(name, value);
                }
            }
            ServletOutputStream out = res.getOutputStream();
            ContentHandler opch = this.getOutputHandler((OutputStream)out);
            ContentHandler ch = null;
            ch = opch;
            AttributesImpl dummyAttributes = new AttributesImpl();
            ch.startDocument();
            ch.startElement("", "entity-service", "entity-service", dummyAttributes);
            AttributesImpl propA = new AttributesImpl();
            propA.addAttribute("", "request-path-info", "request-path-info", "string", request.getPathInfo());
            propA.addAttribute("", "request-user", "request-user", "string", request.getRemoteUser());
            propA.addAttribute("", "request-protocol", "request-protocol", "string", request.getProtocol());
            propA.addAttribute("", "request-servername", "request-servername", "string", request.getServerName());
            propA.addAttribute("", "request-serverport", "request-serverport", "string", String.valueOf(request.getServerPort()));
            propA.addAttribute("", "request-url", "request-url", "string", String.valueOf(request.getRequestURL()));
            ch.startElement("", "request-properties", "request-properties", propA);
            this.addRequestAttributes(ch, request);
            this.addRequestParameters(ch, request);
            ch.endElement("", "request-properties", "request-properties");
            if (withBreadcrumbs) {
                ch.startElement("", "page-visits", "page-visits", dummyAttributes);
                List<String[]> pv = pageVisits.getPageNames(this.getMinorType());
                for (String[] visit : pv) {
                    propA = new AttributesImpl();
                    propA.addAttribute("", "url", "url", "string", visit[0]);
                    this.addElement(ch, "", "page-visit", "page-visit", propA, visit[1]);
                }
                ch.endElement("", "page-visits", "page-visits");
            }
            ch.startElement("", "entity", "entity", dummyAttributes);
            ch.startElement("", "properties", "properties", dummyAttributes);
            ResourceProperties rp = entity.getProperties();
            Iterator i = rp.getPropertyNames();
            while (i.hasNext()) {
                Object key = i.next();
                String name = String.valueOf(key);
                String value = String.valueOf(rp.getProperty(name));
                propA = new AttributesImpl();
                propA.addAttribute("", "name", "name", "string", name);
                this.addElement(ch, "", "property", "property", propA, value);
            }
            propA = new AttributesImpl();
            propA.addAttribute("", "name", "name", "string", "_handler");
            this.addElement(ch, "", "property", "property", propA, " XSLTEntity Handler");
            if (!rwe.isContainer()) {
                rwo = rwe.getRWikiObject();
                propA = new AttributesImpl();
                propA.addAttribute("", "name", "name", "string", "_title");
                this.addElement(ch, "", "property", "property", propA, NameHelper.localizeName((String)rwo.getName(), (String)rwo.getRealm()));
            } else {
                propA = new AttributesImpl();
                propA.addAttribute("", "name", "name", "string", "_title");
                this.addElement(ch, "", "property", "property", propA, entity.getReference());
            }
            ch.endElement("", "properties", "properties");
            if (!rwe.isContainer()) {
                rwo = rwe.getRWikiObject();
                ch.startElement("", "rendered-content", "rendered-content", dummyAttributes);
                this.renderToXML(rwo, ch, withBreadcrumbs, this.escaped);
                ch.endElement("", "rendered-content", "rendered-content");
            }
            ch.endElement("", "entity", "entity");
            if (sideBar != null && sideBar instanceof RWikiEntity) {
                RWikiEntity sbrwe = (RWikiEntity)sideBar;
                RWikiObject sbrwo = sbrwe.getRWikiObject();
                ch.startElement("", "sidebar", "sidebar", dummyAttributes);
                ch.startElement("", "properties", "properties", dummyAttributes);
                propA = new AttributesImpl();
                propA.addAttribute("", "name", "name", "string", "_title");
                this.addElement(ch, "", "property", "property", propA, NameHelper.localizeName((String)sbrwo.getName(), (String)sbrwo.getRealm()));
                ch.endElement("", "properties", "properties");
                ch.startElement("", "rendered-content", "rendered-content", dummyAttributes);
                this.renderToXML(sbrwo, ch, withBreadcrumbs, this.escaped);
                ch.endElement("", "rendered-content", "rendered-content");
                ch.endElement("", "sidebar", "sidebar");
            }
            ch.endElement("", "entity-service", "entity-service");
            ch.endDocument();
        }
        catch (Throwable ex) {
            log.info("Failed to serialize " + ex.getMessage());
            ex.printStackTrace();
            throw new RuntimeException(Messages.getString("XSLTEntityHandler.68") + ex.getLocalizedMessage(), ex);
        }
        finally {
            XSLTEntityHandler.setCurrentRequest(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(ContentHandler ch, String ns, String lname, String qname, Attributes attr, Object content) throws SAXException {
        ch.startElement(ns, lname, qname, attr);
        try {
            if (content != null) {
                char[] c = String.valueOf(content).toCharArray();
                ch.characters(c, 0, c.length);
            }
        }
        finally {
            ch.endElement(ns, lname, qname);
        }
    }

    public ResourceProperties getProperties(Entity entity) {
        return entity.getProperties();
    }

    public void renderToXML(RWikiObject rwo, ContentHandler ch, boolean withBreadCrumb, boolean escapeXML) throws SAXException, IOException {
        String renderedPage;
        try {
            renderedPage = this.render(rwo, withBreadCrumb);
        }
        catch (Exception e) {
            renderedPage = Messages.getString("XSLTEntityHandler.32") + rwo.getName() + Messages.getString("XSLTEntityHandler.33") + e.getClass() + Messages.getString("XSLTEntityHandler.34") + e.getMessage();
            log.info(renderedPage, (Throwable)e);
        }
        String contentDigest = DigestHtml.digest((String)renderedPage);
        if (contentDigest.length() > 500) {
            contentDigest = contentDigest.substring(0, 500);
        }
        if (renderedPage == null || renderedPage.trim().length() == 0) {
            renderedPage = Messages.getString("XSLTEntityHandler.35");
        }
        if (contentDigest == null || contentDigest.trim().length() == 0) {
            contentDigest = Messages.getString("XSLTEntityHandler.36");
        }
        String cdataEscapedRendered = renderedPage.replaceAll("]]>", "]]>]]&gt;<![CDATA[");
        String cdataContentDigest = contentDigest.replaceAll("]]>", "]]>]]&gt;<![CDATA[");
        renderedPage = "<content><rendered>" + (escapeXML ? StringEscapeUtils.escapeXml((String)renderedPage) : renderedPage) + "</rendered><rendered-cdata><![CDATA[" + cdataEscapedRendered + "]]></rendered-cdata><contentdigest><![CDATA[" + cdataContentDigest + "]]></contentdigest></content>";
        try {
            this.parseToSAX(renderedPage, ch);
        }
        catch (SAXException ex) {
            SimpleCoverage.cover((String)("Failed to parse renderedPage from " + rwo.getName()));
            AttributesImpl dummyAttributes = new AttributesImpl();
            ch.startElement("", "error", "error", dummyAttributes);
            ch.startElement("", "error-description", "error-description", dummyAttributes);
            String s = Messages.getString("XSLTEntityHandler.46") + ex.getMessage();
            ch.characters(s.toCharArray(), 0, s.length());
            ch.endElement("", "error-description", "error-description");
            ch.startElement("", "wiki-content", "wiki-content", dummyAttributes);
            ch.characters(renderedPage.toCharArray(), 0, renderedPage.length());
            ch.endElement("", "wiki-content", "wiki-content");
            ch.endElement("", "error", "error");
        }
    }

    public void parseToSAX(String toRender, final ContentHandler ch) throws IOException, SAXException {
        XMLReader xmlReader;
        ContentHandler proxy = new ContentHandler(){

            @Override
            public void setDocumentLocator(Locator arg0) {
                ch.setDocumentLocator(arg0);
            }

            @Override
            public void startDocument() throws SAXException {
            }

            @Override
            public void endDocument() throws SAXException {
            }

            @Override
            public void startPrefixMapping(String arg0, String arg1) throws SAXException {
                ch.startPrefixMapping(arg0, arg1);
            }

            @Override
            public void endPrefixMapping(String arg0) throws SAXException {
                ch.endPrefixMapping(arg0);
            }

            @Override
            public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
                ch.startElement(arg0, arg1, arg2, arg3);
            }

            @Override
            public void endElement(String arg0, String arg1, String arg2) throws SAXException {
                ch.endElement(arg0, arg1, arg2);
            }

            @Override
            public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
                ch.characters(arg0, arg1, arg2);
            }

            @Override
            public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
                ch.ignorableWhitespace(arg0, arg1, arg2);
            }

            @Override
            public void processingInstruction(String arg0, String arg1) throws SAXException {
                ch.processingInstruction(arg0, arg1);
            }

            @Override
            public void skippedEntity(String arg0) throws SAXException {
                ch.skippedEntity(arg0);
            }
        };
        InputSource ins = new InputSource(new StringReader(toRender));
        try {
            SAXParser saxParser = this.saxParserFactory.newSAXParser();
            xmlReader = saxParser.getXMLReader();
        }
        catch (Exception e) {
            log.error("SAXException when creating XMLReader", (Throwable)e);
            throw new SAXException(e);
        }
        xmlReader.setContentHandler(proxy);
        xmlReader.parse(ins);
    }

    public String render(RWikiObject rwo, boolean withBreadCrumb) {
        String localSpace = NameHelper.localizeSpace((String)rwo.getName(), (String)rwo.getRealm());
        String localAliasSpace = this.m_siteAlias ? NameHelper.aliasSpace((String)localSpace) : localSpace;
        ComponentPageLinkRenderImpl plr = new ComponentPageLinkRenderImpl(localAliasSpace, withBreadCrumb);
        plr.setAnchorURLFormat(this.anchorLinkFormat);
        plr.setStandardURLFormat(this.standardLinkFormat);
        plr.setBreadcrumbSwitch(this.breadCrumbParameterFormat);
        plr.setUrlFormat(this.hrefTagFormat);
        if (this.renderService == null) {
            return rwo.getContent();
        }
        return this.renderService.renderPage(rwo, localSpace, (PageLinkRenderer)plr);
    }

    public Collection getAuthzGroups(Reference ref, String userId) {
        Vector<String> rv = new Vector<String>();
        if (!this.isAvailable()) {
            return rv;
        }
        try {
            String[] parts;
            String[] paths = ref.getId().split("/");
            boolean container = ref.getId().endsWith("/");
            if (paths.length > 1) {
                StringBuffer root = new StringBuffer("/" + paths[1] + "/");
                ArrayList<String> al = new ArrayList<String>();
                for (int next = 2; next < paths.length; ++next) {
                    root.append(paths[next]);
                    if (next < paths.length - 1 || container) {
                        root.append("/");
                    }
                    al.add(root.toString());
                }
                for (int i = al.size() - 1; i >= 0; --i) {
                    rv.add(this.authZPrefix + (String)al.get(i));
                }
            }
            if ((parts = ref.getId().split("/")).length > 3 && "group-user".equals(parts[1])) {
                rv.add(SiteService.siteReference((String)SiteService.getUserSiteId((String)parts[3])));
            }
            if (paths.length > 4 && ("group".equals(paths[3]) || "section".equals(paths[3]))) {
                String[] testuuid = paths[2].split("-");
                String[] uuidparts = paths[4].split("-");
                boolean isuuid = false;
                String groupID = "/" + paths[1] + "/" + paths[2] + "/" + paths[3] + "/" + paths[4];
                if (testuuid.length > 0 && testuuid.length == uuidparts.length) {
                    isuuid = true;
                    for (int i = 0; i < testuuid.length; ++i) {
                        if (testuuid[i].length() == uuidparts[i].length()) continue;
                        isuuid = false;
                    }
                }
                if (!isuuid) {
                    Reference siteRef = this.entityManager.newReference(ref.getContext());
                    Site s = (Site)siteRef.getEntity();
                    Collection l = s.getGroups();
                    for (Group g : l) {
                        if (!paths[4].equalsIgnoreCase(g.getTitle())) continue;
                        groupID = g.getId();
                        log.debug("Found Match " + groupID);
                        break;
                    }
                    log.debug("Converted ID " + groupID);
                } else {
                    log.debug("Raw ID " + groupID);
                }
                rv.add(groupID);
            }
            rv.add(SiteService.siteReference((String)parts[2]));
            rv.add("!site.helper");
        }
        catch (Throwable e) {
            log.error(this + " Problem ", e);
        }
        return rv;
    }

    public void init() {
        if (!this.isAvailable()) {
            return;
        }
        ComponentManager cm = org.sakaiproject.component.cover.ComponentManager.getInstance();
        this.entityManager = (EntityManager)this.load(cm, EntityManager.class.getName());
        this.renderService = (RenderService)this.load(cm, RenderService.class.getName());
        this.saxParserFactory = SAXParserFactory.newInstance();
        this.saxParserFactory.setNamespaceAware(true);
        try {
            XSLTTransform xsltTransform = new XSLTTransform();
            xsltTransform.setXslt(new InputSource(this.getClass().getResourceAsStream(this.xslt)));
            xsltTransform.getContentHandler();
        }
        catch (Exception ex) {
            log.error("Please check that the xslt is in the classpath " + this.xslt, (Throwable)ex);
            throw new RuntimeException("Failed to initialise XSLTTransformer context with xslt " + this.xslt, ex);
        }
    }

    public void destroy() {
    }

    public ContentHandler getOutputHandler(Writer out) throws IOException {
        throw new RuntimeException("Method Not In Use ");
    }

    public ContentHandler getOutputHandler(OutputStream out) throws IOException {
        if (!this.isAvailable()) {
            return null;
        }
        try {
            XSLTTransform xsltTransform = (XSLTTransform)this.transformerHolder.get();
            if (xsltTransform == null) {
                xsltTransform = new XSLTTransform();
                xsltTransform.setXslt(new InputSource(this.getClass().getResourceAsStream(this.xslt)));
                this.transformerHolder.set(xsltTransform);
            }
            SAXResult sr = new SAXResult();
            TransformerHandler th = xsltTransform.getContentHandler();
            Transformer transformer = th.getTransformer();
            if (this.transformParameters != null) {
                for (Map.Entry<String, String> entry : this.transformParameters.entrySet()) {
                    transformer.setParameter(entry.getKey(), entry.getValue());
                }
            }
            Properties p = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
            if ("websphere".equals(ServerConfigurationService.getString((String)"servlet.container")) && this.getXalan270ContentHandler() != null) {
                this.outputProperties.put("{http://xml.apache.org/xalan}content-handler", this.getXalan270ContentHandler());
            }
            p.putAll((Map<?, ?>)this.outputProperties);
            Serializer s = SerializerFactory.getSerializer((Properties)p);
            s.setOutputStream(out);
            sr.setHandler(s.asContentHandler());
            th.setResult(sr);
            return th;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create Content Handler", ex);
        }
    }

    public String getXslt() {
        return this.xslt;
    }

    public void setXslt(String xslt) {
        this.xslt = xslt;
    }

    public String getDefaultStackTrace() {
        return this.defaultStackTrace;
    }

    public void setDefaultStackTrace(String defaultStackTrace) {
        this.defaultStackTrace = defaultStackTrace;
    }

    public String getErrorFormat() {
        return this.errorFormat;
    }

    public void setErrorFormat(String errorFormat) {
        this.errorFormat = errorFormat;
    }

    public String getAuthZPrefix() {
        return this.authZPrefix;
    }

    public void setAuthZPrefix(String authZPrefix) {
        this.authZPrefix = authZPrefix;
    }

    public String getAnchorLinkFormat() {
        return this.anchorLinkFormat;
    }

    public void setAnchorLinkFormat(String anchorLinkFormat) {
        this.anchorLinkFormat = anchorLinkFormat;
    }

    public String getHrefTagFormat() {
        return this.hrefTagFormat;
    }

    public void setHrefTagFormat(String hrefTagFormat) {
        this.hrefTagFormat = hrefTagFormat;
    }

    public String getStandardLinkFormat() {
        return this.standardLinkFormat;
    }

    public void setStandardLinkFormat(String standardLinkFormat) {
        this.standardLinkFormat = standardLinkFormat;
    }

    public Map getOutputProperties() {
        return this.outputProperties;
    }

    public void setOutputProperties(Map outputProperties) {
        this.outputProperties = outputProperties;
    }

    public void setTransformParameters(Map<String, String> transformParameters) {
        this.transformParameters = transformParameters;
    }

    public Map getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Map responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public void addRequestAttributes(ContentHandler ch, HttpServletRequest request) throws Exception {
        if (!this.isAvailable()) {
            return;
        }
        AttributesImpl dummyAttributes = new AttributesImpl();
        ch.startElement("", "request-attributes", "request-attributes", dummyAttributes);
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object attr = request.getAttribute(name);
            AttributesImpl propA = new AttributesImpl();
            propA.addAttribute("", "name", "name", "string", name);
            if (attr instanceof Object[]) {
                Object[] oattr = (Object[])attr;
                ch.startElement("", "request-attribute", "request-attribute", propA);
                for (int i = 0; i < oattr.length; ++i) {
                    this.addElement(ch, "", "value", "value", dummyAttributes, oattr[i]);
                }
                ch.endElement("", "request-attribute", "request-attribute");
                continue;
            }
            ch.startElement("", "request-attribute", "request-attribute", propA);
            this.addElement(ch, "", "value", "value", dummyAttributes, attr);
            ch.endElement("", "request-attribute", "request-attribute");
        }
        ch.endElement("", "request-attributes", "request-attributes");
    }

    public void addRequestParameters(ContentHandler ch, HttpServletRequest request) throws Exception {
        if (!this.isAvailable()) {
            return;
        }
        AttributesImpl dummyAttributes = new AttributesImpl();
        ch.startElement("", "request-params", "request-params", dummyAttributes);
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String[] attr = request.getParameterValues(name);
            AttributesImpl propA = new AttributesImpl();
            propA.addAttribute("", "name", "name", "string", name);
            ch.startElement("", "request-param", "request-param", propA);
            for (int i = 0; i < attr.length; ++i) {
                this.addElement(ch, "", "value", "value", dummyAttributes, attr[i]);
            }
            ch.endElement("", "request-param", "request-param");
        }
        ch.endElement("", "request-params", "request-params");
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public String getBreadCrumbParameterFormat() {
        return this.breadCrumbParameterFormat;
    }

    public void setBreadCrumbParameterFormat(String breadCrumbParameterFormat) {
        this.breadCrumbParameterFormat = breadCrumbParameterFormat;
    }

    public String getBreadCrumbParameter() {
        return this.breadCrumbParameter;
    }

    public void setBreadCrumbParameter(String breadCrumbParameter) {
        this.breadCrumbParameter = breadCrumbParameter;
    }

    public String getXalan270ContentHandler() {
        return this.xalan270ContentHandler;
    }

    public void setXalan270ContentHandler(String xalan270ContentHandler) {
        this.xalan270ContentHandler = xalan270ContentHandler;
    }

    public boolean isEscaped() {
        return this.escaped;
    }

    public void setEscaped(boolean escaped) {
        this.escaped = escaped;
    }
}

