/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.dao.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import uk.ac.cam.caret.sakai.rwiki.component.Messages;
import uk.ac.cam.caret.sakai.rwiki.component.dao.impl.ListProxy;
import uk.ac.cam.caret.sakai.rwiki.model.RWikiCurrentObjectImpl;
import uk.ac.cam.caret.sakai.rwiki.service.api.dao.ObjectProxy;
import uk.ac.cam.caret.sakai.rwiki.service.api.dao.RWikiCurrentObjectDao;
import uk.ac.cam.caret.sakai.rwiki.service.api.dao.RWikiHistoryObjectDao;
import uk.ac.cam.caret.sakai.rwiki.service.api.dao.RWikiObjectContentDao;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiCurrentObject;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiHistoryObject;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.utils.TimeLogger;

public class RWikiCurrentObjectDaoImpl
extends HibernateDaoSupport
implements RWikiCurrentObjectDao,
ObjectProxy {
    private static Logger log = LoggerFactory.getLogger(RWikiCurrentObjectDaoImpl.class);
    protected RWikiObjectContentDao contentDAO = null;
    protected RWikiHistoryObjectDao historyDAO = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(final String name) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    return session.createQuery("select count(*) from RWikiCurrentObjectImpl r where r.name = ? ").setParameter(0, (Object)name, (Type)Hibernate.STRING).list();
                }
            };
            Integer count = (Integer)this.getHibernateTemplate().executeFind(callback).get(0);
            boolean bl = count > 0;
            return bl;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("RWikiObjectDaoImpl.exists: " + name), (long)start, (long)finish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RWikiCurrentObject findByGlobalName(final String name) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(RWikiCurrentObject.class).add((Criterion)Expression.eq((String)"name", (Object)name)).list();
                }
            };
            List found = (List)this.getHibernateTemplate().execute(callback);
            if (found.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Found " + found.size() + " objects with name " + name);
                }
                RWikiCurrentObject rWikiCurrentObject = null;
                return rWikiCurrentObject;
            }
            if (log.isDebugEnabled()) {
                log.debug("Found " + found.size() + " objects with name " + name + " returning most recent one.");
            }
            RWikiCurrentObject rWikiCurrentObject = (RWikiCurrentObject)this.proxyObject(found.get(0));
            return rWikiCurrentObject;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("RWikiObjectDaoImpl.findByGlobalName: " + name), (long)start, (long)finish);
        }
    }

    public List findByGlobalNameAndContents(String criteria, String user, String realm) {
        String[] criterias = criteria.split("\\s\\s*");
        final StringBuffer expression = new StringBuffer();
        final ArrayList<String> criteriaList = new ArrayList<String>();
        criteriaList.add(realm);
        criteriaList.add("%" + criteria.toLowerCase() + "%");
        criteriaList.add("%" + criteria.toLowerCase() + "%");
        for (int i = 0; i < criterias.length; ++i) {
            if ("".equals(criterias[i])) continue;
            expression.append(" or lower(c.content) like ? ");
            criteriaList.add("%" + criterias[i].toLowerCase() + "%");
        }
        if ("".equals(criteria)) {
            expression.append(" or lower(c.content) like ? ");
            criteriaList.add("%%");
        }
        final Type[] types = new Type[criteriaList.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = Hibernate.STRING;
        }
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery("select distinct r \t\tfrom RWikiCurrentObjectImpl as r, \t\t\tRWikiCurrentObjectContentImpl as c    where r.realm = ? and ( lower(r.name) like ? or           lower(c.content) like ? " + expression.toString() + " ) and \t\t\tr.id = c.rwikiid   order by r.name ").setParameters(criteriaList.toArray(), types).list();
            }
        };
        return new ListProxy((List)this.getHibernateTemplate().execute(callback), this);
    }

    public void update(RWikiCurrentObject rwo, RWikiHistoryObject rwho) {
        RWikiCurrentObjectImpl impl = (RWikiCurrentObjectImpl)rwo;
        this.getHibernateTemplate().saveOrUpdate((Object)impl);
        if (rwho != null) {
            rwho.setRwikiobjectid(impl.getId());
            this.historyDAO.update(rwho);
        }
        impl.setRwikiObjectContentDao(this.contentDAO);
        impl.getRWikiObjectContent().setRwikiid(rwo.getId());
        this.contentDAO.update(impl.getRWikiObjectContent());
    }

    public RWikiCurrentObject createRWikiObject(String name, String realm) {
        RWikiCurrentObjectImpl returnable = new RWikiCurrentObjectImpl();
        this.proxyObject(returnable);
        returnable.setName(name);
        returnable.setRealm(realm);
        returnable.setVersion(new Date());
        returnable.setRevision(Integer.valueOf(0));
        returnable.setContent(Messages.getString("RWikiCurrentObjectDaoImpl.30") + Messages.getString("RWikiCurrentObjectDaoImpl.31"));
        return returnable;
    }

    public List findChangedSince(final Date since, final String realm) {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(RWikiCurrentObject.class).add((Criterion)Expression.ge((String)"version", (Object)since)).add((Criterion)Expression.eq((String)"realm", (Object)realm)).addOrder(Order.desc((String)"version")).list();
            }
        };
        return new ListProxy((List)this.getHibernateTemplate().execute(callback), this);
    }

    public List findReferencingPages(final String name) {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery("select r.name from RWikiCurrentObjectImpl r where referenced like ?").setParameter(0, (Object)("%::" + name + "::%"), (Type)Hibernate.STRING).list();
            }
        };
        return new ListProxy((List)this.getHibernateTemplate().execute(callback), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RWikiCurrentObject getRWikiCurrentObject(final RWikiObject reference) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(RWikiCurrentObject.class).add((Criterion)Expression.eq((String)"id", (Object)reference.getRwikiobjectid())).list();
                }
            };
            List found = (List)this.getHibernateTemplate().execute(callback);
            if (found.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Found " + found.size() + " objects with id " + reference.getRwikiobjectid());
                }
                RWikiCurrentObject rWikiCurrentObject = null;
                return rWikiCurrentObject;
            }
            if (log.isDebugEnabled()) {
                log.debug("Found " + found.size() + " objects with id " + reference.getRwikiobjectid() + " returning most recent one.");
            }
            RWikiCurrentObject rWikiCurrentObject = (RWikiCurrentObject)this.proxyObject(found.get(0));
            return rWikiCurrentObject;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("RWikiCurrentObjectDaoImpl.getRWikiCurrentObject: " + reference.getName()), (long)start, (long)finish);
        }
    }

    public RWikiObjectContentDao getContentDAO() {
        return this.contentDAO;
    }

    public void setContentDAO(RWikiObjectContentDao contentDAO) {
        this.contentDAO = contentDAO;
    }

    public Object proxyObject(Object o) {
        if (o != null && o instanceof RWikiCurrentObjectImpl) {
            RWikiCurrentObjectImpl rwCo = (RWikiCurrentObjectImpl)o;
            rwCo.setRwikiObjectContentDao(this.contentDAO);
        }
        return o;
    }

    public RWikiHistoryObjectDao getHistoryDAO() {
        return this.historyDAO;
    }

    public void setHistoryDAO(RWikiHistoryObjectDao historyDAO) {
        this.historyDAO = historyDAO;
    }

    public List getAll() {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(RWikiCurrentObject.class).addOrder(Order.desc((String)"version")).list();
            }
        };
        return new ListProxy((List)this.getHibernateTemplate().execute(callback), this);
    }

    public void updateObject(RWikiObject rwo) {
        this.getHibernateTemplate().saveOrUpdate((Object)rwo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageCount(final String group) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    return session.createQuery("select count(*) from RWikiCurrentObjectImpl r where r.realm = ?").setParameter(0, (Object)group, (Type)Hibernate.STRING).list();
                }
            };
            Integer count = (Integer)this.getHibernateTemplate().executeFind(callback).get(0);
            int n = count;
            return n;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("RWikiObjectDaoImpl.getPageCount: " + group), (long)start, (long)finish);
        }
    }

    public List findRWikiSubPages(final String globalParentPageName) {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                String search = globalParentPageName.replaceAll("([A%_])", "A$1");
                return session.createQuery("from RWikiCurrentObjectImpl as r where r.name like concat(?,'%') escape 'A' order by name asc").setParameter(0, (Object)search, (Type)Hibernate.STRING).list();
            }
        };
        return new ListProxy((List)this.getHibernateTemplate().execute(callback), this);
    }

    public RWikiObject findLastRWikiSubPage(final String globalParentPageName) {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                String search = globalParentPageName.replaceAll("([A%_])", "A$1");
                return session.createQuery("from RWikiCurrentObjectImpl as r where r.name like concat(?,'%') escape 'A' order by name desc").setParameter(0, (Object)search, (Type)Hibernate.STRING).list();
            }
        };
        List l = (List)this.getHibernateTemplate().execute(callback);
        if (l == null || l.size() == 0) {
            return null;
        }
        return (RWikiObject)l.get(0);
    }

    public List findAllChangedSince(final Date time, final String basepath) {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                String search = basepath.replaceAll("([A%_])", "A$1");
                return session.createQuery("from RWikiCurrentObjectImpl as r where r.name like concat(?,'%') escape 'A' and r.version >= ? order by r.version desc, r.name asc").setParameters(new Object[]{search, time}, new Type[]{Hibernate.STRING, Hibernate.DATE}).list();
            }
        };
        return new ListProxy((List)this.getHibernateTemplate().execute(callback), this);
    }

    public List findAllPageNames() {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery("select r.name from RWikiCurrentObjectImpl  r ").list();
            }
        };
        return (List)this.getHibernateTemplate().execute(callback);
    }
}

