/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.message.dao.impl;

import java.util.Date;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import uk.ac.cam.caret.sakai.rwiki.message.model.RwikiMessageImpl;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.dao.MessageDao;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.model.Message;
import uk.ac.cam.caret.sakai.rwiki.utils.TimeLogger;

public class MessageDaoImpl
extends HibernateDaoSupport
implements MessageDao {
    private static Logger log = LoggerFactory.getLogger(MessageDaoImpl.class);

    public Message createMessage(String pageSpace, String pageName, String sessionid, String user, String message) {
        RwikiMessageImpl m = new RwikiMessageImpl();
        m.setLastseen(new Date());
        m.setPagename(pageName);
        m.setPagespace(pageSpace);
        m.setSessionid(sessionid);
        m.setUser(user);
        m.setMessage(message);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findBySpace(final String pageSpace) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(Message.class).add((Criterion)Expression.eq((String)"pagespace", (Object)pageSpace)).list();
                }
            };
            List list = (List)this.getHibernateTemplate().execute(callback);
            return list;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("PagePresenceDaoImpl.findBySpace: " + pageSpace), (long)start, (long)finish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findByPage(final String pageSpace, final String pageName) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(Message.class).add((Criterion)Expression.eq((String)"pagespace", (Object)pageSpace)).add((Criterion)Expression.eq((String)"pagename", (Object)pageName)).list();
                }
            };
            List list = (List)this.getHibernateTemplate().execute(callback);
            return list;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("PagePresenceDaoImpl.findByPage: " + pageSpace + ":" + pageName), (long)start, (long)finish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findByUser(final String user) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(Message.class).add((Criterion)Expression.eq((String)"user", (Object)user)).list();
                }
            };
            List list = (List)this.getHibernateTemplate().execute(callback);
            return list;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("PagePresenceDaoImpl.findByUser: " + user), (long)start, (long)finish);
        }
    }

    public void update(Object o) {
        this.getHibernateTemplate().saveOrUpdate(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findBySession(String session) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(Message.class).add((Criterion)Expression.eq((String)"sessionid", (Object)session)).list();
                }
            };
            List list = (List)this.getHibernateTemplate().execute(callback);
            return list;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("PagePresenceDaoImpl.findBySession: " + session), (long)start, (long)finish);
        }
    }
}

