/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.message.dao.impl;

import java.util.Date;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import uk.ac.cam.caret.sakai.rwiki.message.model.RwikiTriggerImpl;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.dao.TriggerDao;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.model.Trigger;
import uk.ac.cam.caret.sakai.rwiki.utils.TimeLogger;

public class TriggerDaoImpl
extends HibernateDaoSupport
implements TriggerDao {
    private static Logger log = LoggerFactory.getLogger(TriggerDaoImpl.class);

    public Trigger createTrigger(String pageName, String pageSpace, String triggerSpec, String user) {
        RwikiTriggerImpl t = new RwikiTriggerImpl();
        t.setLastseen(new Date());
        t.setPagename(pageName);
        t.setPagespace(pageSpace);
        t.setTriggerspec(triggerSpec);
        t.setUser(user);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findByUser(final String user) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(Trigger.class).add((Criterion)Expression.eq((String)"user", (Object)user)).list();
                }
            };
            List list = (List)this.getHibernateTemplate().execute(callback);
            return list;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("PagePresenceDaoImpl.findByUser: " + user), (long)start, (long)finish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findBySpace(final String space) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(Trigger.class).add((Criterion)Expression.eq((String)"pagespage", (Object)space)).list();
                }
            };
            List list = (List)this.getHibernateTemplate().execute(callback);
            return list;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("PagePresenceDaoImpl.findBySpace: " + space), (long)start, (long)finish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findByPage(final String space, final String page) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(Trigger.class).add((Criterion)Expression.eq((String)"pagespage", (Object)space)).add((Criterion)Expression.eq((String)"pagename", (Object)page)).list();
                }
            };
            List list = (List)this.getHibernateTemplate().execute(callback);
            return list;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("PagePresenceDaoImpl.findByPage: " + space + ":" + page), (long)start, (long)finish);
        }
    }

    public void update(Object o) {
        this.getHibernateTemplate().saveOrUpdate(o);
    }
}

