/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.dao.impl;

import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import uk.ac.cam.caret.sakai.rwiki.component.dao.impl.ListProxy;
import uk.ac.cam.caret.sakai.rwiki.model.RWikiHistoryObjectImpl;
import uk.ac.cam.caret.sakai.rwiki.service.api.dao.ObjectProxy;
import uk.ac.cam.caret.sakai.rwiki.service.api.dao.RWikiHistoryObjectDao;
import uk.ac.cam.caret.sakai.rwiki.service.api.dao.RWikiObjectContentDao;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiCurrentObject;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiHistoryObject;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.utils.TimeLogger;

public class RWikiHistoryObjectDaoImpl
extends HibernateDaoSupport
implements RWikiHistoryObjectDao,
ObjectProxy {
    private RWikiObjectContentDao contentDAO;
    private static Logger log = LoggerFactory.getLogger(RWikiHistoryObjectDaoImpl.class);

    public void update(RWikiHistoryObject rwo) {
        RWikiHistoryObjectImpl impl = (RWikiHistoryObjectImpl)rwo;
        this.getHibernateTemplate().saveOrUpdate((Object)impl);
        impl.getRWikiObjectContent().setRwikiid(rwo.getId());
        this.contentDAO.update(impl.getRWikiObjectContent());
    }

    public RWikiHistoryObject createRWikiHistoryObject(RWikiCurrentObject rwo) {
        RWikiHistoryObjectImpl returnable = new RWikiHistoryObjectImpl();
        returnable.setRwikiObjectContentDao(this.contentDAO);
        rwo.copyAllTo((RWikiObject)returnable);
        returnable.setRwikiobjectid(rwo.getId());
        return returnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RWikiHistoryObject getRWikiHistoryObject(final RWikiObject rwo, final int revision) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(RWikiHistoryObject.class).add((Criterion)Expression.eq((String)"rwikiobjectid", (Object)rwo.getRwikiobjectid())).add((Criterion)Expression.eq((String)"revision", (Object)revision)).list();
                }
            };
            List found = (List)this.getHibernateTemplate().execute(callback);
            if (found.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Found " + found.size() + " objects with id " + rwo.getRwikiobjectid());
                }
                RWikiHistoryObject rWikiHistoryObject = null;
                return rWikiHistoryObject;
            }
            if (log.isDebugEnabled()) {
                log.debug("Found " + found.size() + " objects with id " + rwo.getRwikiobjectid() + " returning most recent one.");
            }
            RWikiHistoryObject rWikiHistoryObject = (RWikiHistoryObject)this.proxyObject(found.get(0));
            return rWikiHistoryObject;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("RWikiHistoryObjectDaoImpl.getRWikiHistoryObject: " + rwo.getName()), (long)start, (long)finish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findRWikiHistoryObjects(final RWikiObject reference) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(RWikiHistoryObject.class).add((Criterion)Expression.eq((String)"rwikiobjectid", (Object)reference.getRwikiobjectid())).addOrder(Order.asc((String)"revision")).list();
                }
            };
            List found = (List)this.getHibernateTemplate().execute(callback);
            if (found.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Found " + found.size() + " objects with id " + reference.getRwikiobjectid());
                }
                List list = null;
                return list;
            }
            if (log.isDebugEnabled()) {
                log.debug("Found " + found.size() + " objects with id " + reference.getRwikiobjectid() + " returning most recent one.");
            }
            ListProxy listProxy = new ListProxy(found, this);
            return listProxy;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("RWikiHistoryObjectDaoImpl.getRWikiHistoryObjects: " + reference.getName()), (long)start, (long)finish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findRWikiHistoryObjectsInReverse(final RWikiObject reference) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(RWikiHistoryObject.class).add((Criterion)Expression.eq((String)"rwikiobjectid", (Object)reference.getRwikiobjectid())).addOrder(Order.desc((String)"revision")).list();
                }
            };
            List found = (List)this.getHibernateTemplate().execute(callback);
            if (found.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Found " + found.size() + " objects with id " + reference.getRwikiobjectid());
                }
                List list = null;
                return list;
            }
            if (log.isDebugEnabled()) {
                log.debug("Found " + found.size() + " objects with id " + reference.getRwikiobjectid() + " returning most recent one.");
            }
            ListProxy listProxy = new ListProxy(found, this);
            return listProxy;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("RWikiHistoryObjectDaoImpl.getRWikiHistoryObjects: " + reference.getName()), (long)start, (long)finish);
        }
    }

    public Object proxyObject(Object o) {
        if (o != null && o instanceof RWikiHistoryObjectImpl) {
            RWikiHistoryObjectImpl rwCo = (RWikiHistoryObjectImpl)o;
            rwCo.setRwikiObjectContentDao(this.contentDAO);
        }
        return o;
    }

    public RWikiObjectContentDao getContentDAO() {
        return this.contentDAO;
    }

    public void setContentDAO(RWikiObjectContentDao contentDAO) {
        this.contentDAO = contentDAO;
    }

    public List getAll() {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(RWikiHistoryObject.class).addOrder(Order.desc((String)"version")).list();
            }
        };
        return new ListProxy((List)this.getHibernateTemplate().execute(callback), this);
    }

    public void updateObject(RWikiObject rwo) {
        this.getHibernateTemplate().saveOrUpdate((Object)rwo);
    }
}

