/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.macros;

import java.io.IOException;
import java.io.Writer;
import org.radeox.api.engine.ImageRenderEngine;
import org.radeox.api.engine.RenderEngine;
import org.radeox.api.macro.MacroParameter;
import org.radeox.macro.BaseLocaleMacro;
import org.radeox.util.Encoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.cam.caret.sakai.rwiki.component.Messages;
import uk.ac.cam.caret.sakai.rwiki.component.radeox.service.impl.SpecializedRenderContext;

public class SakaiLinkMacro
extends BaseLocaleMacro {
    private static Logger log = LoggerFactory.getLogger(SakaiLinkMacro.class);

    public String[] getParamDescription() {
        return new String[]{Messages.getString("SakaiLinkMacro.0"), Messages.getString("SakaiLinkMacro.1"), Messages.getString("SakaiLinkMacro.2"), Messages.getString("SakaiLinkMacro.3"), Messages.getString("SakaiLinkMacro.4")};
    }

    public String getDescription() {
        return Messages.getString("SakaiLinkMacro.5");
    }

    public String getLocaleKey() {
        return "macro.link";
    }

    public void execute(Writer writer, MacroParameter params) throws IllegalArgumentException, IOException {
        SpecializedRenderContext context = (SpecializedRenderContext)params.getContext();
        RenderEngine engine = context.getRenderEngine();
        String text = params.get("text", 0);
        String url = params.get("url", 1);
        String img = params.get("img", 2);
        String target = params.get("target", 3);
        if (params.getLength() == 1) {
            url = text;
            text = Encoder.escape((String)text);
        }
        if (url != null && text != null) {
            if (target == null) {
                target = url.startsWith("sakai:") || url.startsWith("worksite:/") || url.startsWith("saka-dropbox:/") || url.startsWith("dropbox:/") || url.indexOf(":/") < 0 || url.indexOf(":/") > 10 ? "none" : "rwikiexternal";
            }
            writer.write("<span class=\"nobr\">");
            if (!"none".equals(img) && engine instanceof ImageRenderEngine) {
                writer.write(((ImageRenderEngine)engine).getExternalImageLink());
            }
            url = context.convertLink(url);
            if (!((url = url.trim()).startsWith("http://") || url.startsWith("https://") || url.startsWith("ftp://") || url.startsWith("mailto:"))) {
                log.warn("RWiki URL (" + url + ") looks invalid so we're removing it from the display.");
                url = "";
            }
            writer.write("<a href=\"" + url + "\"");
            if (!"none".equals(target)) {
                writer.write(" target=\"" + target + "\"");
            }
        } else {
            throw new IllegalArgumentException(Messages.getString("SakaiLinkMacro.28"));
        }
        writer.write(">");
        writer.write(text);
        writer.write("</a></span>");
    }
}

