/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.message;

import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.cam.caret.sakai.rwiki.component.message.MessageServiceImpl;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.PreferenceService;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.dao.PreferenceDao;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.model.Preference;

public class PreferenceServiceImpl
implements PreferenceService {
    private static Logger log = LoggerFactory.getLogger(MessageServiceImpl.class);
    private PreferenceDao preferenceDao = null;

    public void updatePreference(String user, String context, String type, String preference) {
        Preference pref = this.preferenceDao.findExactByUser(user, context, type);
        if (pref != null) {
            pref.setPreference(preference);
            pref.setLastseen(new Date());
            this.preferenceDao.update((Object)pref);
        } else {
            pref = this.preferenceDao.createPreference(user, context, type, preference);
            this.preferenceDao.update((Object)pref);
        }
    }

    public String findPreferenceAt(String user, String context, String type) {
        String baseSearch = "/";
        List l = this.preferenceDao.findByUser(user, baseSearch, type);
        Preference selected = null;
        for (Preference p : l) {
            if (!context.startsWith(p.getPrefcontext()) || selected != null && p.getPrefcontext().length() <= selected.getPrefcontext().length()) continue;
            selected = p;
        }
        if (selected == null) {
            return null;
        }
        return selected.getPreference();
    }

    public PreferenceDao getPreferenceDao() {
        return this.preferenceDao;
    }

    public void setPreferenceDao(PreferenceDao preferenceDao) {
        this.preferenceDao = preferenceDao;
    }

    public void deleteAllPreferences(String user, String context, String type) {
        this.preferenceDao.delete(user, context, type);
    }

    public void deletePreference(String user, String context, String type) {
        this.preferenceDao.deleteExact(user, context, type);
    }
}

