/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.model.impl;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import uk.ac.cam.caret.sakai.rwiki.service.api.dao.RWikiPropertyDao;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.DataMigrationAgent;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.DataMigrationController;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiProperty;

public class DataMigrationSpecification
implements DataMigrationController {
    private static Logger log = LoggerFactory.getLogger(DataMigrationSpecification.class);
    private static final Marker fatal = MarkerFactory.getMarker((String)"FATAL");
    private RWikiProperty targetVersion;
    private List migrationAgents;
    private RWikiPropertyDao propertyDao;
    private boolean performDataMigrations;

    public boolean isPerformDataMigrations() {
        return this.performDataMigrations;
    }

    public void setPerformDataMigrations(boolean performDataMigrations) {
        this.performDataMigrations = performDataMigrations;
    }

    public void update() throws Exception {
        String targetVersionString = this.targetVersion.getValue();
        RWikiProperty currentVersion = this.propertyDao.getProperty(this.targetVersion.getName());
        String currentVersionString = null;
        if (currentVersion != null) {
            currentVersionString = currentVersion.getValue();
        }
        if (currentVersionString != null && currentVersionString.equals(targetVersionString)) {
            log.info("No data migration performed, target version present {}", (Object)targetVersionString);
            return;
        }
        if (this.performDataMigrations) {
            boolean newdb = currentVersionString == null;
            for (DataMigrationAgent a : this.migrationAgents) {
                currentVersionString = a.migrate(currentVersionString, targetVersionString, newdb);
            }
            if (currentVersion == null) {
                currentVersion = this.propertyDao.createProperty();
                currentVersion.setName(this.targetVersion.getName());
            }
            currentVersion.setValue(currentVersionString);
            this.propertyDao.update(currentVersion);
            if (currentVersionString != null && currentVersionString.equals(targetVersionString)) {
                log.info("RWiki Data migrated to version {} successfully", (Object)currentVersionString);
                return;
            }
        }
        log.error(fatal, "RWiki Data has NOT been migrated to the current version, you MUST investigate before using the RWiki Tool\n currentVersion: {} targetVersion: {}", (Object)currentVersionString, (Object)targetVersionString);
        throw new RuntimeException("RWiki Data has NOT been migrated to the current version, you MUST investigate before using the RWiki Tool\n currentVersion: " + currentVersionString + " targetVersion: " + targetVersionString);
    }

    public RWikiPropertyDao getPropertyDao() {
        return this.propertyDao;
    }

    public void setPropertyDao(RWikiPropertyDao propertyDao) {
        this.propertyDao = propertyDao;
    }

    public void setTargetVersion(RWikiProperty targetVersion) {
        this.targetVersion = targetVersion;
    }

    public List getMigrationAgents() {
        return this.migrationAgents;
    }

    public void setMigrationAgents(List migrationAgents) {
        this.migrationAgents = migrationAgents;
    }

    public RWikiProperty getTargetVersion() {
        return this.targetVersion;
    }
}

