/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.radeox.service.impl;

import org.radeox.engine.context.BaseRenderContext;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import uk.ac.cam.caret.sakai.rwiki.component.Messages;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiObjectService;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiSecurityService;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.service.api.radeox.CachableRenderContext;

public class SpecializedRenderContext
extends BaseRenderContext
implements CachableRenderContext {
    private boolean cachable = true;
    private RWikiObjectService objectService;
    private RWikiObject rwikiObject;
    private RWikiSecurityService securityService;
    private SiteService siteService;
    private EntityManager entityManager;

    public SpecializedRenderContext(RWikiObject rwikiObject, RWikiObjectService objectService, RWikiSecurityService securityService, SiteService siteService, EntityManager entityManager) {
        this.rwikiObject = rwikiObject;
        this.objectService = objectService;
        this.securityService = securityService;
        this.siteService = siteService;
        this.entityManager = entityManager;
        this.set(RWikiObject.class.getName(), rwikiObject);
        this.set(RWikiObject.class.getName().concat(".name"), rwikiObject.getName());
        this.set(RWikiObjectService.class.getName(), objectService);
        this.set(RWikiSecurityService.class.getName(), securityService);
        this.set(SiteService.class.getName(), siteService);
    }

    public RWikiObject getRWikiObject() {
        return this.rwikiObject;
    }

    public void setRWikiObject(RWikiObject rwikiObject) {
        this.rwikiObject = rwikiObject;
    }

    public RWikiObjectService getObjectService() {
        return this.objectService;
    }

    public void setObjectService(RWikiObjectService objectService) {
        this.objectService = objectService;
    }

    public RWikiSecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(RWikiSecurityService securityService) {
        this.securityService = securityService;
    }

    public boolean isCachable() {
        return this.cachable;
    }

    public Site getSite() {
        String siteId = this.getSiteId();
        if (siteId == null) {
            return null;
        }
        try {
            return this.siteService.getSite(siteId);
        }
        catch (IdUnusedException ex) {
            return null;
        }
    }

    public String getSiteId() {
        RWikiObject rwobj;
        RWikiObjectService rwobjService = this.getObjectService();
        Reference ref = rwobjService.getReference(rwobj = this.getRWikiObject());
        String siteContext = ref.getContext();
        if (siteContext.startsWith("/site/")) {
            String siteId = siteContext.substring(6);
            int slash = siteId.indexOf("/");
            if (slash != -1) {
                siteId = siteId.substring(0, slash - 1);
            }
            return siteId;
        }
        return null;
    }

    public String convertLink(String link) {
        String siteType;
        String siteId;
        String[] parts;
        String refSiteUrl;
        if (link.startsWith("sakai:/")) {
            refSiteUrl = link.substring("sakai:/".length());
            if (refSiteUrl.startsWith("/")) {
                refSiteUrl = refSiteUrl.substring(1);
            }
            if ((parts = refSiteUrl.split("/")) == null || parts.length < 1) {
                return Messages.getString("SpecializedRenderContext.7");
            }
            String refSiteId = parts[0];
            String refSiteType = this.getSiteType(refSiteId, "group");
            if (refSiteId != null && refSiteId.startsWith("~") || refSiteType == null) {
                String remLink = link.substring("sakai:/".length());
                if (remLink.startsWith("/")) {
                    remLink = remLink.substring(1);
                }
                if (remLink.startsWith("~")) {
                    remLink = remLink.substring(1);
                }
                link = "/content/user/" + remLink;
            } else {
                link = "/content/group/" + link.substring("sakai:/".length());
            }
        } else if (link.startsWith("sakai-dropbox:/")) {
            refSiteUrl = link.substring("sakai-dropbox:/".length());
            if (refSiteUrl.startsWith("/")) {
                refSiteUrl = refSiteUrl.substring(1);
            }
            if ((parts = refSiteUrl.split("/")) == null || parts.length < 1) {
                return Messages.getString("SpecializedRenderContext.20");
            }
            String refSiteId = parts[0];
            String refSiteType = this.getSiteType(refSiteId, "group");
            if (refSiteId != null && refSiteId.startsWith("~") || refSiteType == null) {
                String remLink = link.substring("sakai-dropbox:/".length());
                if (remLink.startsWith("/")) {
                    remLink = remLink.substring(1);
                }
                if (remLink.startsWith("~")) {
                    remLink = remLink.substring(1);
                }
                link = "/content/group-user/" + remLink;
            } else {
                link = "/content/group-user/" + link.substring("sakai-dropbox:/".length());
            }
        } else if (link.startsWith("worksite:/")) {
            siteId = this.getSiteId();
            siteType = this.getSiteType(siteId, null);
            if (siteId != null && siteId.startsWith("~") || siteType == null) {
                if (siteId.startsWith("~")) {
                    siteId = siteId.substring(1);
                }
                link = "/content/user/" + siteId + "/" + link.substring("worksite:/".length());
            } else {
                link = "/content/group/" + siteId + "/" + link.substring("worksite:/".length());
            }
        } else if (link.startsWith("dropbox:/")) {
            siteId = this.getSiteId();
            siteType = this.getSiteType(siteId, null);
            if (siteId != null && siteId.startsWith("~") || siteType == null) {
                if (siteId.startsWith("~")) {
                    siteId = siteId.substring(1);
                }
                link = "/content/group-user/" + siteId + "/" + link.substring("dropbox:/".length());
            } else {
                link = "/content/group-user/" + siteId + "/" + link.substring("dropbox:/".length());
            }
        }
        try {
            String s;
            Reference r = this.entityManager.newReference(link);
            if (r != null && (s = r.getUrl()) != null) {
                link = s;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return link;
    }

    public String getSiteType(String siteId, String defaultType) {
        try {
            Site s = this.siteService.getSite(siteId);
            return s.getType();
        }
        catch (IdUnusedException e) {
            return defaultType;
        }
    }
}

