/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.macros;

import java.io.IOException;
import java.io.Writer;
import org.radeox.api.macro.MacroParameter;
import org.radeox.macro.BaseMacro;
import org.radeox.util.Encoder;
import uk.ac.cam.caret.sakai.rwiki.component.Messages;
import uk.ac.cam.caret.sakai.rwiki.component.radeox.service.impl.SpecializedRenderContext;

public class ImageMacro
extends BaseMacro {
    public String[] getParamDescription() {
        return new String[]{Messages.getString("ImageMacro.0"), Messages.getString("ImageMacro.1"), Messages.getString("ImageMacro.2"), Messages.getString("ImageMacro.3"), Messages.getString("ImageMacro.4"), Messages.getString("ImageMacro.5"), Messages.getString("ImageMacro.6")};
    }

    public String getDescription() {
        return Messages.getString("ImageMacro.7");
    }

    public String getName() {
        return "image";
    }

    public void execute(Writer writer, MacroParameter params) throws IllegalArgumentException, IOException {
        SpecializedRenderContext context = (SpecializedRenderContext)params.getContext();
        if (params.getLength() > 0) {
            String imageName;
            String link;
            boolean qualifiedParams;
            String img = params.get("img");
            String alt = null;
            String cssclass = null;
            String target = null;
            String title = null;
            boolean bl = qualifiedParams = img != null;
            if (qualifiedParams) {
                alt = params.get("alt");
                title = params.get("title");
                cssclass = params.get("class");
                target = params.get("target");
            } else {
                img = params.get(0);
                alt = params.get(1);
                cssclass = params.get(3);
                target = params.get(4);
                title = params.get(5);
            }
            if (title == null && alt != null) {
                title = alt;
            }
            if ((link = params.get("link")) != null) {
                link = context.convertLink(link);
                writer.write("<a href=\"" + Encoder.escape((String)link) + "\"");
                if (target != null) {
                    writer.write("target=\"" + Encoder.escape((String)target) + "\"");
                }
                writer.write(">");
            }
            if ((imageName = img).startsWith("http://") || imageName.startsWith("https://") || imageName.startsWith("ftp://")) {
                throw new IllegalArgumentException(Messages.getString("ImageMacro.23"));
            }
            imageName = context.convertLink(imageName);
            writer.write("<img src=\"");
            writer.write(Encoder.escape((String)imageName));
            writer.write("\" ");
            if (cssclass != null) {
                writer.write("class=\"");
                writer.write(Encoder.escape((String)cssclass));
                writer.write("\" ");
            }
            if (alt != null) {
                writer.write("alt=\"" + Encoder.escape((String)alt) + "\" ");
            }
            if (title != null) {
                writer.write("title=\"" + Encoder.escape((String)title) + "\" ");
            }
            writer.write("border=\"0\"/>");
            if (link != null) {
                writer.write("</a>");
            }
        } else {
            throw new IllegalArgumentException(Messages.getString("ImageMacro.34"));
        }
    }
}

