/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.macros;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.radeox.api.macro.MacroParameter;
import org.radeox.macro.BaseMacro;
import uk.ac.cam.caret.sakai.rwiki.component.Messages;
import uk.ac.cam.caret.sakai.rwiki.component.radeox.service.impl.SpecializedRenderContext;
import uk.ac.cam.caret.sakai.rwiki.component.radeox.service.impl.SpecializedRenderEngine;
import uk.ac.cam.caret.sakai.rwiki.service.api.PageLinkRenderer;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiObjectService;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;

public class IndexMacro
extends BaseMacro {
    private static final String description = "";

    public String getDescription() {
        return description;
    }

    public String[] getParamDescription() {
        return new String[]{Messages.getString("IndexMacro.1"), Messages.getString("IndexMacro.2")};
    }

    public String getName() {
        return "index";
    }

    public void execute(Writer writer, MacroParameter params) throws IllegalArgumentException, IOException {
        SpecializedRenderContext context = (SpecializedRenderContext)params.getContext();
        SpecializedRenderEngine spRe = (SpecializedRenderEngine)context.getRenderEngine();
        PageLinkRenderer plr = spRe.getPageLinkRenderer();
        plr.setCachable(false);
        String space = params.get("space", 0);
        if (space == null || description.equals(space.trim())) {
            space = spRe.getSpace();
        }
        boolean nohead = "nohead".equals(params.get("nohead", 1));
        RWikiObjectService objectService = context.getObjectService();
        List subpages = objectService.findRWikiSubPages(space + '/');
        Iterator it = subpages.iterator();
        writer.write("<div class=\"index-list\">\n");
        if (!nohead) {
            writer.write(Messages.getString("IndexMacro.0"));
            writer.write(space);
            writer.write("</p>\n");
        }
        String currentSpace = space;
        char[] currentNameChars = currentSpace.toCharArray();
        int currentSpaceIndex = currentNameChars.length;
        writer.write("  <ul class=\"tree\">\n");
        while (it.hasNext()) {
            int index;
            RWikiObject next = (RWikiObject)it.next();
            String nextName = next.getName();
            char[] nextNameChars = nextName.toCharArray();
            int nextSpaceIndex = nextName.lastIndexOf(47);
            boolean isNextLonger = nextSpaceIndex > currentSpaceIndex;
            char[] longerSpace = isNextLonger ? nextNameChars : currentNameChars;
            int longerSpaceLength = isNextLonger ? nextSpaceIndex : currentSpaceIndex;
            int shortSpaceLength = !isNextLonger ? nextSpaceIndex : currentSpaceIndex;
            int lastSep = -1;
            for (index = 0; index < shortSpaceLength && nextNameChars[index] == currentNameChars[index]; ++index) {
                if (longerSpace[index] != '/') continue;
                lastSep = index;
            }
            if (index != shortSpaceLength || index != longerSpaceLength) {
                if (index == shortSpaceLength && longerSpace[index] == '/') {
                    this.emitSpaceChange(writer, longerSpace, index, longerSpaceLength, isNextLonger);
                } else {
                    this.emitSpaceChange(writer, currentNameChars, lastSep, currentSpaceIndex, false);
                    this.emitSpaceChange(writer, nextNameChars, lastSep, nextSpaceIndex, true);
                }
            }
            this.emitListItem(writer, plr, nextNameChars, nextSpaceIndex + 1);
            currentNameChars = nextNameChars;
            currentSpaceIndex = nextSpaceIndex;
        }
        if (currentSpaceIndex > space.length()) {
            this.emitSpaceChange(writer, currentNameChars, space.length(), currentSpaceIndex, false);
        }
        writer.write("  </ul>\n");
        writer.write("</div>\n");
    }

    private void emitSpaceChange(Writer writer, char[] chars, int index, int end, boolean up) throws IOException {
        int[] sepIndexes = new int[(end - index) / 2 + 1];
        int spaces = 0;
        sepIndexes[spaces++] = index;
        while (++index < end) {
            if (chars[index] != '/') continue;
            sepIndexes[spaces++] = index;
        }
        sepIndexes[spaces] = end;
        if (up) {
            for (int i = 0; i < spaces; ++i) {
                this.emitGoUp(writer, chars, sepIndexes[i] + 1, sepIndexes[i + 1]);
            }
        } else {
            for (int i = spaces; i > 0; --i) {
                this.emitGoDown(writer, chars, sepIndexes[i - 1] + 1, sepIndexes[i]);
            }
        }
    }

    private void emitGoUp(Writer writer, char[] chars, int start, int end) throws IOException {
        writer.write("<li><a href=\"#\" class=\"subspace-link\">");
        writer.write(chars, start, end - start + 1);
        writer.write("</a>\n<ul>");
    }

    private void emitGoDown(Writer writer, char[] chars, int start, int end) throws IOException {
        writer.write("</ul>\n</li>");
    }

    private void emitListItem(Writer writer, PageLinkRenderer plr, char[] chars, int start) throws IOException {
        writer.write("<li>");
        StringBuffer sb = new StringBuffer(chars.length * 3);
        plr.appendLink(sb, new String(chars), new String(chars, start, chars.length - start), null, true);
        writer.write(sb.toString());
        writer.write("</li>\n");
    }
}

