/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.macros;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import org.radeox.api.macro.MacroParameter;
import org.radeox.macro.BaseMacro;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import uk.ac.cam.caret.sakai.rwiki.component.Messages;
import uk.ac.cam.caret.sakai.rwiki.component.radeox.service.impl.SpecializedRenderContext;

public class SectionsMacro
extends BaseMacro {
    public String[] getParamDescription() {
        return new String[]{Messages.getString("SectionsMacro.0"), Messages.getString("SectionsMacro.1")};
    }

    public String getDescription() {
        return Messages.getString("SectionsMacro.2");
    }

    public String getName() {
        return "sakai-sections";
    }

    public void execute(Writer writer, MacroParameter params) throws IllegalArgumentException, IOException {
        Site site;
        SpecializedRenderContext context = (SpecializedRenderContext)params.getContext();
        String useids = params.get("useids", 0);
        String siteId = context.getSiteId();
        Collection groups = null;
        try {
            site = SiteService.getSite((String)siteId);
        }
        catch (IdUnusedException e) {
            throw new IllegalArgumentException(Messages.getString("SectionsMacro.5") + siteId + " : " + e.getMessage());
        }
        groups = site.getGroups();
        for (Group group : groups) {
            String pageName = "";
            if ("true".equals(useids)) {
                pageName = group.getId() + "/Home";
            } else {
                pageName = group.getReference() + "/";
                pageName = pageName + "section/" + group.getTitle() + "/Home";
            }
            writer.write("\n");
            writer.write("* [ Section: ");
            writer.write(group.getTitle());
            writer.write("|");
            writer.write(pageName);
            writer.write("]");
        }
        writer.write("\n");
    }
}

