/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.message.dao.impl;

import java.util.Date;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import uk.ac.cam.caret.sakai.rwiki.message.model.PagePresenceImpl;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.dao.PagePresenceDao;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.model.PagePresence;
import uk.ac.cam.caret.sakai.rwiki.utils.TimeLogger;

public class PagePresenceDaoImpl
extends HibernateDaoSupport
implements PagePresenceDao {
    private static Logger log = LoggerFactory.getLogger(PagePresenceDaoImpl.class);

    public PagePresence createPagePresence(String pageName, String pageSpace, String sessionid, String user) {
        PagePresenceImpl pp = new PagePresenceImpl();
        pp.setLastseen(new Date());
        pp.setPagename(pageName);
        pp.setPagespace(pageSpace);
        pp.setSessionid(sessionid);
        pp.setUser(user);
        return pp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findBySpace(final String pageSpace) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(PagePresence.class).add((Criterion)Expression.eq((String)"pagespace", (Object)pageSpace)).addOrder(Order.desc((String)"lastseen")).list();
                }
            };
            List l = (List)this.getHibernateTemplate().execute(callback);
            log.info("Found  " + l.size() + " in " + pageSpace);
            List list = l;
            return list;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("PagePresenceDaoImpl.findBySpace: " + pageSpace), (long)start, (long)finish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findByPage(final String pageSpace, final String pageName) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(PagePresence.class).add((Criterion)Expression.eq((String)"pagename", (Object)pageName)).add((Criterion)Expression.eq((String)"pagespace", (Object)pageSpace)).addOrder(Order.desc((String)"lastseen")).list();
                }
            };
            List list = (List)this.getHibernateTemplate().execute(callback);
            return list;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("PagePresenceDaoImpl.findByPage: " + pageSpace + " :" + pageName), (long)start, (long)finish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findByUser(final String user) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(PagePresence.class).add((Criterion)Expression.eq((String)"user", (Object)user)).list();
                }
            };
            List list = (List)this.getHibernateTemplate().execute(callback);
            return list;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("PagePresenceDaoImpl.findByUser: " + user), (long)start, (long)finish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PagePresence findBySession(final String sessionid) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(PagePresence.class).add((Criterion)Expression.eq((String)"sessionid", (Object)sessionid)).list();
                }
            };
            List found = (List)this.getHibernateTemplate().execute(callback);
            if (found.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Found " + found.size() + " objects with name " + sessionid);
                }
                PagePresence pagePresence = null;
                return pagePresence;
            }
            if (log.isDebugEnabled()) {
                log.debug("Found " + found.size() + " objects with name " + sessionid + " returning most recent one.");
            }
            PagePresence pagePresence = (PagePresence)found.get(0);
            return pagePresence;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("PagePresenceDaoImpl.findBySessionId: " + sessionid), (long)start, (long)finish);
        }
    }

    public void update(Object o) {
        this.getHibernateTemplate().saveOrUpdate(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findBySpaceOnly(final String pageSpace, final String pageName) {
        long start = System.currentTimeMillis();
        try {
            HibernateCallback callback = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createCriteria(PagePresence.class).add((Criterion)Expression.eq((String)"pagespace", (Object)pageSpace)).add(Expression.not((Criterion)Expression.eq((String)"pagename", (Object)pageName))).addOrder(Order.desc((String)"lastseen")).list();
                }
            };
            List l = (List)this.getHibernateTemplate().execute(callback);
            log.info("Found " + l.size() + " in " + pageSpace + " : " + pageName);
            List list = l;
            return list;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("PagePresenceDaoImpl.findBySpaceOnly: " + pageSpace + " :" + pageName), (long)start, (long)finish);
        }
    }
}

