/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.radeox.service.impl;

import org.radeox.api.engine.RenderEngine;
import org.radeox.api.engine.context.RenderContext;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.site.api.SiteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.cam.caret.sakai.rwiki.component.radeox.service.impl.SpecializedRenderContext;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiObjectService;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiSecurityService;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.service.api.radeox.RenderContextFactory;

public class RenderContextFactoryImpl
implements RenderContextFactory {
    private static Logger log = LoggerFactory.getLogger(RenderContextFactoryImpl.class);
    private RWikiObjectService objectService;
    private RWikiSecurityService securityService;
    private SiteService siteService;
    private EntityManager entityManager;

    public void init() {
        ComponentManager cm = org.sakaiproject.component.cover.ComponentManager.getInstance();
        this.objectService = (RWikiObjectService)this.load(cm, RWikiObjectService.class.getName());
        this.securityService = (RWikiSecurityService)this.load(cm, RWikiSecurityService.class.getName());
        this.siteService = (SiteService)this.load(cm, SiteService.class.getName());
        this.entityManager = (EntityManager)this.load(cm, EntityManager.class.getName());
    }

    private Object load(ComponentManager cm, String name) {
        Object o = cm.get(name);
        if (o == null) {
            log.error("Cant find Spring component named " + name);
        }
        return o;
    }

    public RenderContext getRenderContext(RWikiObject rwo, RenderEngine renderEngine) {
        SpecializedRenderContext context = new SpecializedRenderContext(rwo, this.objectService, this.securityService, this.siteService, this.entityManager);
        context.setRenderEngine(renderEngine);
        return context;
    }
}

