/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.service.impl;

import java.text.MessageFormat;
import org.sakaiproject.alias.api.AliasService;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.SiteService;
import uk.ac.cam.caret.sakai.rwiki.component.service.impl.Decoded;
import uk.ac.cam.caret.sakai.rwiki.service.api.EntityHandler;
import uk.ac.cam.caret.sakai.rwiki.utils.NameHelper;

public abstract class BaseEntityHandlerImpl
implements EntityHandler {
    private String accessURLStart = null;
    private String minorType = null;
    private String feedFormat;
    protected boolean m_siteAlias = true;
    private boolean experimental = false;
    private boolean setup = false;
    private boolean available = true;
    protected AliasService m_aliasService = null;
    protected SiteService m_siteService = null;

    public void setAliasService(AliasService service) {
        this.m_aliasService = service;
    }

    public void setSiteService(SiteService service) {
        this.m_siteService = service;
    }

    public void setReference(String majorType, Reference ref, String reference) {
        if (!this.isAvailable()) {
            return;
        }
        Decoded decoded = this.decode(reference);
        if (decoded == null) {
            throw new RuntimeException(this + " Failed to setReference in EntityHelper " + majorType + ":" + this.minorType + " reference not for this EntityHandler ");
        }
        ref.set(majorType, this.minorType, decoded.getId(), decoded.getContainer(), decoded.getContext());
    }

    public boolean matches(String reference) {
        if (!this.isAvailable()) {
            return false;
        }
        return this.decode(reference) != null;
    }

    public int getRevision(Reference reference) {
        if (!this.isAvailable()) {
            return 0;
        }
        Decoded decode = this.decode(reference.getReference());
        return Integer.parseInt(decode.getVersion());
    }

    public String getMinorType() {
        return this.minorType;
    }

    public void setMinorType(String minorType) {
        this.minorType = minorType;
    }

    public Decoded decode(String s) {
        String ending = "." + this.minorType;
        if (this.isAvailable() && s.startsWith(this.accessURLStart) && s.endsWith(ending) && s.indexOf("//") == -1) {
            String siteContext;
            int slashIndex;
            String context;
            Decoded decoded = new Decoded();
            s = s.substring(this.accessURLStart.length() - 1);
            int lastslash = s.lastIndexOf("/");
            int firstslash = s.indexOf("/", 1);
            int nextslash = s.indexOf("/", firstslash + 1);
            if (nextslash == -1) {
                nextslash = firstslash;
            }
            if ((context = (slashIndex = (siteContext = s.substring(0, nextslash)).indexOf("/", 1)) == -1 ? "" : s.substring(slashIndex + 1, siteContext.length())) != null && context.length() > 0) {
                if (this.m_siteAlias && this.m_aliasService != null && this.m_siteService != null && !this.m_siteService.siteExists(context)) {
                    try {
                        String target = this.m_aliasService.getTarget(context);
                        Reference targetRef = EntityManager.newReference((String)target);
                        if ("sakai:site".equals(targetRef.getType())) {
                            context = targetRef.getId();
                        } else if ("sakai:mailarchive".equals(targetRef.getType())) {
                            context = targetRef.getContext();
                        }
                    }
                    catch (IdUnusedException target) {
                        // empty catch block
                    }
                }
                siteContext = "/site/" + context;
            }
            decoded.setContext(siteContext);
            if (nextslash == lastslash) {
                decoded.setContainer("/");
            } else {
                decoded.setContainer(s.substring(nextslash, lastslash));
            }
            String filename = s.substring(lastslash + 1);
            filename = filename.substring(0, filename.length() - ending.length());
            int versionSeparator = filename.lastIndexOf("@");
            if (versionSeparator != -1 && versionSeparator < filename.length() - 1) {
                try {
                    Integer.parseInt(filename.substring(versionSeparator + 1));
                    decoded.setPage(filename.substring(0, versionSeparator));
                    decoded.setVersion(filename.substring(versionSeparator + 1));
                }
                catch (NumberFormatException e) {
                    decoded.setPage(filename);
                    decoded.setVersion("-1");
                }
            } else {
                decoded.setPage(filename);
                decoded.setVersion("-1");
            }
            return decoded;
        }
        return null;
    }

    public String getAccessURLStart() {
        return this.accessURLStart;
    }

    public void setAccessURLStart(String accessURLStart) {
        this.accessURLStart = accessURLStart;
    }

    public boolean isAvailable() {
        if (!this.setup) {
            this.available = !this.experimental ? true : ServerConfigurationService.getBoolean((String)"wiki.experimental", (boolean)false);
            this.setup = true;
        }
        return this.available;
    }

    public String getHTML(Entity e) {
        if (this.isAvailable()) {
            int slashIndex;
            if (this.feedFormat == null) {
                return null;
            }
            String url = e.getUrl();
            if (url.startsWith("/access")) {
                url = url.substring("/access".length());
            }
            if (this.m_siteAlias && url.startsWith("/wiki/site/") && (slashIndex = url.indexOf("/", "/wiki/site/".length())) != -1) {
                String siteId = url.substring("/wiki/site/".length(), slashIndex);
                String pageURL = url.substring(slashIndex);
                String localSpace = "/site/" + siteId;
                url = "/wiki" + NameHelper.aliasSpace((String)localSpace) + pageURL;
            }
            return MessageFormat.format(this.feedFormat, url);
        }
        return null;
    }

    public String getFeedFormat() {
        return this.feedFormat;
    }

    public void setFeedFormat(String feedFormat) {
        this.feedFormat = feedFormat;
    }

    public boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(boolean experimental) {
        this.experimental = experimental;
    }
}

