/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.service.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import uk.ac.cam.caret.sakai.rwiki.service.api.PageLinkRenderer;
import uk.ac.cam.caret.sakai.rwiki.utils.NameHelper;
import uk.ac.cam.caret.sakai.rwiki.utils.XmlEscaper;

public class ComponentPageLinkRenderImpl
implements PageLinkRenderer {
    private boolean cachable = true;
    private boolean useCache = true;
    public String localSpace;
    private String standardURLFormat = "/wiki{0}.html{1}";
    private String anchorURLFormat = "/wiki{0}.html{2}#{1}";
    private String urlFormat = "<a href=\"{0}\" >{1}</a>";
    private boolean withBreadcrumbs = true;
    private String breadcrumbSwitch = "?breadcrumb=0";

    public ComponentPageLinkRenderImpl(String localSpace, boolean withBreadcrumbs) {
        this.localSpace = localSpace;
        this.withBreadcrumbs = withBreadcrumbs;
    }

    public void appendLink(StringBuffer buffer, String name, String view) {
        this.appendLink(buffer, name, view, null);
    }

    public void appendLink(StringBuffer buffer, String name, String view, String anchor) {
        name = NameHelper.globaliseName((String)name, (String)this.localSpace);
        String url = anchor != null && !"".equals(anchor) ? MessageFormat.format(this.anchorURLFormat, ComponentPageLinkRenderImpl.encode(name), ComponentPageLinkRenderImpl.encode(anchor), this.withBreadcrumbs ? "" : this.breadcrumbSwitch) : MessageFormat.format(this.standardURLFormat, ComponentPageLinkRenderImpl.encode(name), this.withBreadcrumbs ? "" : this.breadcrumbSwitch);
        buffer.append(MessageFormat.format(this.urlFormat, XmlEscaper.xmlEscape((String)url), XmlEscaper.xmlEscape((String)view)));
    }

    public void appendCreateLink(StringBuffer buffer, String name, String view) {
        this.cachable = false;
        buffer.append(XmlEscaper.xmlEscape((String)view));
    }

    public boolean isCachable() {
        return this.cachable;
    }

    public boolean canUseCache() {
        return this.useCache && this.withBreadcrumbs;
    }

    public void setCachable(boolean cachable) {
        this.cachable = cachable;
    }

    public void setUseCache(boolean b) {
        this.useCache = b;
    }

    public String getAnchorURLFormat() {
        return this.anchorURLFormat;
    }

    public void setAnchorURLFormat(String anchorURLFormat) {
        this.anchorURLFormat = anchorURLFormat;
    }

    public String getStandardURLFormat() {
        return this.standardURLFormat;
    }

    public void setStandardURLFormat(String standardURLFormat) {
        this.standardURLFormat = standardURLFormat;
    }

    public String getUrlFormat() {
        return this.urlFormat;
    }

    public void setUrlFormat(String urlFormat) {
        this.urlFormat = urlFormat;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public static String encode(String toEncode) {
        try {
            String encoded = URLEncoder.encode(toEncode, "UTF-8");
            encoded = encoded.replaceAll("\\+", "%20").replaceAll("%2F", "/");
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 Encoding is not supported when encoding: " + toEncode + ": " + e.getMessage());
        }
    }

    public void appendLink(StringBuffer buffer, String name, String view, String anchor, boolean autoGenerated) {
        this.appendLink(buffer, name, view, anchor);
    }

    public String getBreadcrumbSwitch() {
        return this.breadcrumbSwitch;
    }

    public void setBreadcrumbSwitch(String breadcrumbSwitch) {
        this.breadcrumbSwitch = breadcrumbSwitch;
    }
}

