/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.service.impl;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.hibernate.HibernateException;
import org.sakaiproject.alias.api.AliasService;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.db.cover.SqlService;
import org.sakaiproject.email.api.DigestService;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.EntityAccessOverloadException;
import org.sakaiproject.entity.api.EntityCopyrightException;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.EntityNotDefinedException;
import org.sakaiproject.entity.api.EntityPermissionException;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.entity.api.HttpAccess;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.event.api.NotificationAction;
import org.sakaiproject.event.api.NotificationEdit;
import org.sakaiproject.event.api.NotificationService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.thread_local.api.ThreadLocalManager;
import org.sakaiproject.time.api.TimeService;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.user.api.UserDirectoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.HibernateOptimisticLockingFailureException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.cam.caret.sakai.rwiki.component.Messages;
import uk.ac.cam.caret.sakai.rwiki.component.dao.impl.ListProxy;
import uk.ac.cam.caret.sakai.rwiki.component.model.impl.RWikiEntityImpl;
import uk.ac.cam.caret.sakai.rwiki.component.service.impl.ComponentPageLinkRenderImpl;
import uk.ac.cam.caret.sakai.rwiki.component.service.impl.SiteEmailNotificationRWiki;
import uk.ac.cam.caret.sakai.rwiki.model.RWikiPermissionsImpl;
import uk.ac.cam.caret.sakai.rwiki.service.api.EntityHandler;
import uk.ac.cam.caret.sakai.rwiki.service.api.PageLinkRenderer;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiObjectService;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiSecurityService;
import uk.ac.cam.caret.sakai.rwiki.service.api.RenderService;
import uk.ac.cam.caret.sakai.rwiki.service.api.dao.ObjectProxy;
import uk.ac.cam.caret.sakai.rwiki.service.api.dao.RWikiCurrentObjectDao;
import uk.ac.cam.caret.sakai.rwiki.service.api.dao.RWikiHistoryObjectDao;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiCurrentObject;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiEntity;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiHistoryObject;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiPermissions;
import uk.ac.cam.caret.sakai.rwiki.service.exception.CreatePermissionException;
import uk.ac.cam.caret.sakai.rwiki.service.exception.ReadPermissionException;
import uk.ac.cam.caret.sakai.rwiki.service.exception.UpdatePermissionException;
import uk.ac.cam.caret.sakai.rwiki.service.exception.VersionException;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.PreferenceService;
import uk.ac.cam.caret.sakai.rwiki.utils.NameHelper;
import uk.ac.cam.caret.sakai.rwiki.utils.TimeLogger;

public class RWikiObjectServiceImpl
implements RWikiObjectService {
    private static Logger log = LoggerFactory.getLogger(RWikiObjectServiceImpl.class);
    private RWikiCurrentObjectDao cdao;
    private RWikiHistoryObjectDao hdao;
    private Map m_handlers = null;
    public String createTemplatePageName = "default_template";
    private RWikiSecurityService wikiSecurityService;
    private RenderService renderService;
    private PreferenceService preferenceService;
    private EntityManager entityManager;
    private NotificationService notificationService;
    private SessionManager sessionManager;
    private EventTrackingService eventTrackingService;
    private SiteService siteService;
    private ThreadLocalManager threadLocalManager;
    private TimeService timeService;
    private DigestService digestService;
    private SecurityService securityService;
    protected boolean autoDdl = false;
    private AliasService aliasService;
    private UserDirectoryService userDirectoryService;
    private int maxReferencesStringSize = 4000;
    private boolean trackReads = ServerConfigurationService.getBoolean((String)"wiki.trackreads", (boolean)false);

    public void setAutoDdl(String value) {
        this.autoDdl = Boolean.valueOf(value);
    }

    public void init() {
        log.debug("init start");
        ComponentManager cm = org.sakaiproject.component.cover.ComponentManager.getInstance();
        this.entityManager = (EntityManager)this.load(cm, EntityManager.class.getName());
        this.notificationService = (NotificationService)this.load(cm, NotificationService.class.getName());
        this.sessionManager = (SessionManager)this.load(cm, SessionManager.class.getName());
        this.eventTrackingService = (EventTrackingService)this.load(cm, EventTrackingService.class.getName());
        this.siteService = (SiteService)this.load(cm, SiteService.class.getName());
        this.threadLocalManager = (ThreadLocalManager)this.load(cm, ThreadLocalManager.class.getName());
        this.timeService = (TimeService)this.load(cm, TimeService.class.getName());
        this.digestService = (DigestService)this.load(cm, DigestService.class.getName());
        this.securityService = (SecurityService)this.load(cm, SecurityService.class.getName());
        this.wikiSecurityService = (RWikiSecurityService)this.load(cm, RWikiSecurityService.class.getName());
        this.renderService = (RenderService)this.load(cm, RenderService.class.getName());
        this.preferenceService = (PreferenceService)this.load(cm, PreferenceService.class.getName());
        this.userDirectoryService = (UserDirectoryService)this.load(cm, UserDirectoryService.class.getName());
        this.entityManager.registerEntityProducer((EntityProducer)this, "/wiki");
        if (ServerConfigurationService.getBoolean((String)"wiki.notification", (boolean)true)) {
            NotificationEdit edit = this.notificationService.addTransientNotification();
            edit.setFunction("wiki.new");
            edit.addFunction("wiki.revise");
            edit.addFunction("wiki.read");
            edit.setResourceFilter("/wiki");
            edit.setAction((NotificationAction)new SiteEmailNotificationRWiki(this, this.renderService, this.preferenceService, this.siteService, this.securityService, this.entityManager, this.threadLocalManager, this.timeService, this.digestService, this.userDirectoryService));
        }
        try {
            if (this.autoDdl) {
                SqlService.getInstance().ddl(this.getClass().getClassLoader(), "sakai_rwiki");
            }
        }
        catch (Exception ex) {
            log.error("Perform additional SQL setup", (Throwable)ex);
        }
        this.maxReferencesStringSize = ServerConfigurationService.getInt((String)"wiki.maxReferences", (int)4000);
        log.debug("init end");
    }

    private Object load(ComponentManager cm, String name) {
        Object o = cm.get(name);
        if (o == null) {
            log.error("Cant find Spring component named " + name);
        }
        return o;
    }

    public RWikiCurrentObject getRWikiObject(String name, String realm) throws uk.ac.cam.caret.sakai.rwiki.service.exception.PermissionException {
        return this.getRWikiObject(name, realm, null, this.createTemplatePageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RWikiCurrentObject getRWikiObject(String name, String realm, RWikiObject ignore, String templatePage) throws uk.ac.cam.caret.sakai.rwiki.service.exception.PermissionException {
        long start = System.currentTimeMillis();
        String user = this.sessionManager.getCurrentSessionUserId();
        try {
            RWikiCurrentObject returnable;
            if (log.isDebugEnabled()) {
                log.debug("Looking for object with name " + name + " in realm " + realm + " for user " + user);
            }
            name = NameHelper.globaliseName((String)name, (String)realm);
            long start2 = System.currentTimeMillis();
            try {
                returnable = this.cdao.findByGlobalName(name);
            }
            finally {
                long finish = System.currentTimeMillis();
                TimeLogger.printTimer((String)("dao.findByGlobalName: " + name), (long)start2, (long)finish);
            }
            if (returnable == null) {
                String permissionsReference = this.wikiSecurityService.createPermissionsReference(realm);
                if (!this.wikiSecurityService.checkCreatePermission(permissionsReference)) {
                    throw new CreatePermissionException("User: " + user + " cannot create pages in realm: " + realm);
                }
                returnable = this.cdao.createRWikiObject(name, realm);
                String pageSpace = NameHelper.localizeSpace((String)name, (String)realm);
                String defTemplate = NameHelper.globaliseName((String)templatePage, (String)pageSpace);
                RWikiCurrentObject template = this.cdao.findByGlobalName(defTemplate);
                if (template != null) {
                    returnable.setContent(template.getContent());
                    returnable.setPermissions(template.getPermissions());
                    returnable.setGroupWrite(true);
                    returnable.setGroupRead(true);
                    returnable.setUser(user);
                    returnable.setOwner(user);
                    returnable.setRealm(realm);
                    returnable.setReferenced(template.getReferenced());
                    returnable.setSha1(template.getSha1());
                }
                RWikiCurrentObject rWikiCurrentObject = returnable;
                return rWikiCurrentObject;
            }
            if (this.wikiSecurityService.checkRead((RWikiEntity)this.getEntity((RWikiObject)returnable))) {
                RWikiCurrentObject rWikiCurrentObject = returnable;
                return rWikiCurrentObject;
            }
            throw new ReadPermissionException(user, (RWikiObject)returnable);
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("dao.GetRWikiObject: " + name + ", " + user + ", " + realm), (long)start, (long)finish);
        }
    }

    public List search(String criteria, String realm) throws uk.ac.cam.caret.sakai.rwiki.service.exception.PermissionException {
        String user = this.sessionManager.getCurrentSessionUserId();
        String permissionsReference = this.wikiSecurityService.createPermissionsReference(realm);
        if (!this.wikiSecurityService.checkSearchPermission(permissionsReference)) {
            throw new ReadPermissionException(user, realm);
        }
        return this.cdao.findByGlobalNameAndContents(criteria, user, realm);
    }

    public RWikiCurrentObjectDao getRWikiCurrentObjectDao() {
        return this.cdao;
    }

    public void setRWikiCurrentObjectDao(RWikiCurrentObjectDao cdao) {
        this.cdao = cdao;
    }

    public RWikiHistoryObjectDao getRWikiHistoryObjectDao() {
        return this.hdao;
    }

    public void setRWikiHistoryObjectDao(RWikiHistoryObjectDao hdao) {
        this.hdao = hdao;
    }

    public void update(String name, String realm, Date version, String content, RWikiPermissions permissions) throws uk.ac.cam.caret.sakai.rwiki.service.exception.PermissionException, VersionException {
        String user = this.sessionManager.getCurrentSessionUserId();
        this.update(name, user, realm, version, content, permissions);
    }

    private void update(String name, String user, String realm, Date version, String content, RWikiPermissions permissions) throws uk.ac.cam.caret.sakai.rwiki.service.exception.PermissionException, VersionException, RuntimeException {
        RWikiCurrentObject rwo = this.getRWikiObject(name, realm);
        RWikiHistoryObject rwho = null;
        if (!this.wikiSecurityService.checkUpdate((RWikiEntity)this.getEntity((RWikiObject)rwo))) {
            throw new UpdatePermissionException("User: " + user + " doesn't have permission to update: " + name);
        }
        rwho = this.updateContent(rwo, content, version);
        if (permissions != null) {
            if (this.wikiSecurityService.checkAdmin((RWikiEntity)this.getEntity((RWikiObject)rwo))) {
                rwo.setPermissions(permissions);
            } else {
                throw new UpdatePermissionException("User: " + user + " doesn't have permission to update and admin: " + name);
            }
        }
        rwo.setUser(user);
        if (rwo.getOwner() == null) {
            rwo.setOwner(user);
        }
        try {
            this.cdao.update(rwo, rwho);
            Entity e = this.getEntity((RWikiObject)rwo);
            int revision = 1;
            try {
                revision = rwo.getRevision();
            }
            catch (Exception exception) {
                // empty catch block
            }
            int notiPriority = 3;
            if ("wiki.smallchange.request".equals(this.threadLocalManager.get("wiki.smallchange.request"))) {
                notiPriority = 0;
            }
            if (revision == 1) {
                this.eventTrackingService.post(this.eventTrackingService.newEvent("wiki.new", e.getReference(), true, notiPriority));
            } else {
                this.eventTrackingService.post(this.eventTrackingService.newEvent("wiki.revise", e.getReference(), true, notiPriority));
            }
        }
        catch (HibernateOptimisticLockingFailureException e) {
            throw new VersionException("Version has changed since: " + version, (Throwable)e);
        }
        catch (HibernateException e) {
            log.info("Caught hibernate exception, update failed." + e.getMessage());
            throw new RuntimeException("An update could not be made to this wiki page. A possible cause is that you have too many links.");
        }
    }

    public void update(String name, String realm, Date version, String content) throws uk.ac.cam.caret.sakai.rwiki.service.exception.PermissionException, VersionException {
        this.update(name, realm, version, content, null);
    }

    public void update(String name, String realm, Date version, RWikiPermissions permissions) throws uk.ac.cam.caret.sakai.rwiki.service.exception.PermissionException, VersionException {
        if (permissions == null) {
            throw new IllegalArgumentException("permissions must not be null");
        }
        String user = this.sessionManager.getCurrentSessionUserId();
        RWikiCurrentObject rwo = this.getRWikiObject(name, realm);
        if (this.wikiSecurityService.checkAdmin((RWikiEntity)this.getEntity((RWikiObject)rwo))) {
            RWikiHistoryObject rwho = this.hdao.createRWikiHistoryObject(rwo);
            rwo.setRevision(Integer.valueOf(rwo.getRevision() + 1));
            rwo.setPermissions(permissions);
            rwo.setVersion(version);
            try {
                this.cdao.update(rwo, rwho);
                Entity e = this.getEntity((RWikiObject)rwo);
                int revision = 1;
                try {
                    revision = rwo.getRevision();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int notiPriority = 3;
                if (this.threadLocalManager.get("wiki.smallchange.request") != null) {
                    notiPriority = 0;
                }
                if (revision == 1) {
                    this.eventTrackingService.post(this.eventTrackingService.newEvent("wiki.new", e.getReference(), true, notiPriority));
                }
                this.eventTrackingService.post(this.eventTrackingService.newEvent("wiki.revise", e.getReference(), true, notiPriority));
            }
            catch (HibernateOptimisticLockingFailureException e) {
                throw new VersionException("Version has changed since: " + version, (Throwable)e);
            }
        } else {
            throw new UpdatePermissionException("User: " + user + " doesn't have permission to update and admin: " + name);
        }
    }

    private RWikiHistoryObject updateContent(RWikiCurrentObject rwo, String content, Date version) {
        if (version != null) {
            rwo.setVersion(version);
        }
        if (content != null && !content.equals(rwo.getContent())) {
            RWikiHistoryObject rwho = this.hdao.createRWikiHistoryObject(rwo);
            rwo.setContent(content.replaceAll("\r\n?", "\n"));
            rwo.setRevision(Integer.valueOf(rwo.getRevision() + 1));
            final HashSet referenced = new HashSet();
            final String currentSpace = NameHelper.localizeSpace((String)rwo.getName(), (String)rwo.getRealm());
            PageLinkRenderer plr = new PageLinkRenderer(){

                public void appendLink(StringBuffer buffer, String name, String view, String anchor, boolean autoGenerated) {
                    if (!autoGenerated) {
                        this.appendLink(buffer, name, view, anchor);
                    }
                }

                public void appendLink(StringBuffer buffer, String name, String view) {
                    this.appendLink(buffer, name, view, null);
                }

                public void appendLink(StringBuffer buffer, String name, String view, String anchor) {
                    referenced.add(NameHelper.globaliseName((String)name, (String)currentSpace));
                }

                public void appendCreateLink(StringBuffer buffer, String name, String view) {
                    referenced.add(NameHelper.globaliseName((String)name, (String)currentSpace));
                }

                public boolean isCachable() {
                    return false;
                }

                public boolean canUseCache() {
                    return false;
                }

                public void setCachable(boolean cachable) {
                }

                public void setUseCache(boolean b) {
                }
            };
            this.renderService.renderPage((RWikiObject)rwo, currentSpace, plr);
            StringBuffer sb = this.extractReferences(rwo, referenced);
            rwo.setReferenced(sb.toString());
            return rwho;
        }
        return null;
    }

    public StringBuffer extractReferences(RWikiCurrentObject rwo, HashSet referenced) {
        StringBuffer sb = new StringBuffer();
        Iterator i = referenced.iterator();
        String next = null;
        while (i.hasNext()) {
            next = (String)i.next();
            int referencedLength = sb.length() + 4 + next.length();
            if (referencedLength >= this.maxReferencesStringSize) break;
            sb.append("::").append(next);
        }
        sb.append("::");
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String name, String space) {
        long start = System.currentTimeMillis();
        try {
            String globalName = NameHelper.globaliseName((String)name, (String)space);
            boolean bl = this.cdao.exists(globalName);
            return bl;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("Exists: " + name), (long)start, (long)finish);
        }
    }

    public List findChangedSince(Date since, String realm) {
        return this.cdao.findChangedSince(since, realm);
    }

    public List findReferencingPages(String name) {
        return this.cdao.findReferencingPages(name);
    }

    public void revert(String name, String realm, Date version, int revision) {
        RWikiCurrentObject rwikiObject = this.getRWikiObject(name, realm);
        String content = this.hdao.getRWikiHistoryObject((RWikiObject)rwikiObject, revision).getContent();
        this.update(name, realm, version, content);
    }

    public RWikiCurrentObject getRWikiObject(RWikiObject reference) {
        return this.cdao.getRWikiCurrentObject(reference);
    }

    public RWikiHistoryObject getRWikiHistoryObject(RWikiObject reference, int revision) {
        return this.hdao.getRWikiHistoryObject(reference, revision);
    }

    public List findRWikiHistoryObjects(RWikiObject reference) {
        return this.hdao.findRWikiHistoryObjects(reference);
    }

    public List findRWikiHistoryObjectsInReverse(RWikiObject reference) {
        return this.hdao.findRWikiHistoryObjectsInReverse(reference);
    }

    public String getCreateTemplatePageName() {
        return this.createTemplatePageName;
    }

    public void setCreateTemplatePageName(String createTemplatePageName) {
        this.createTemplatePageName = createTemplatePageName;
    }

    public List findRWikiSubPages(String globalParentPageName) {
        return this.cdao.findRWikiSubPages(globalParentPageName);
    }

    public void updateNewComment(String name, String realm, Date version, String content) throws uk.ac.cam.caret.sakai.rwiki.service.exception.PermissionException, VersionException {
        for (int retries = 0; retries < 5; ++retries) {
            try {
                String lastCommentName;
                int lastp;
                RWikiObject lastComment = this.cdao.findLastRWikiSubPage(name);
                int cnum = 0;
                if (lastComment != null && (lastp = (lastCommentName = lastComment.getName()).lastIndexOf(".")) >= 0) {
                    try {
                        cnum = Integer.parseInt(lastCommentName.substring(lastp + 1)) + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String newCommentName = MessageFormat.format("{0}.{1,number,000}", name, cnum);
                this.update(newCommentName, realm, version, content);
                break;
            }
            catch (VersionException e) {
                if (retries < 5) continue;
                throw e;
            }
        }
    }

    public List createListProxy(List commentsList, ObjectProxy lop) {
        return new ListProxy(commentsList, lop);
    }

    public RWikiObject createNewRWikiCurrentObject() {
        return this.cdao.createRWikiObject("dummy", "dummy");
    }

    public RWikiPermissions createNewRWikiPermissionsImpl() {
        return new RWikiPermissionsImpl();
    }

    public String getLabel() {
        return "wiki";
    }

    public boolean willArchiveMerge() {
        return true;
    }

    public void contextCreated(String context, boolean toolPlacement) {
        if (toolPlacement) {
            this.enableWiki(context);
        }
    }

    public void contextUpdated(String context, boolean toolPlacement) {
        if (toolPlacement) {
            this.enableWiki(context);
        }
    }

    public void contextDeleted(String context, boolean toolPlacement) {
        this.disableWiki(context);
    }

    public String archive(String siteId, Document doc, Stack stack, String archivePath, List attachments) {
        StringBuffer results = new StringBuffer();
        results.append(Messages.getString("RWikiObjectServiceImpl.32")).append(siteId).append("\n");
        log.debug("archiving Wiki Pages for " + siteId);
        int npages = 0;
        int nversions = 0;
        try {
            String defaultRealm = this.siteService.getSite(siteId).getReference();
            this.wikiSecurityService.checkAdminPermission("/wiki" + defaultRealm);
            Element element = doc.createElement(APPLICATION_ID);
            ((Element)stack.peek()).appendChild(element);
            stack.push(element);
            try {
                List l = this.cdao.findRWikiSubPages("/site/" + siteId);
                for (RWikiObject rwo : l) {
                    RWikiEntity rwe = (RWikiEntity)this.getEntity(rwo);
                    log.debug("Archiving " + rwo.getName());
                    rwe.toXml(doc, stack);
                    ++npages;
                    List lh = this.findRWikiHistoryObjects(rwo);
                    if (lh == null) continue;
                    for (RWikiObject rwoh : lh) {
                        RWikiEntity rwoeh = (RWikiEntity)this.getEntity(rwoh);
                        log.debug("Archiving " + rwoh.getName() + " version " + rwoh.getVersion());
                        rwoeh.toXml(doc, stack);
                        ++nversions;
                    }
                }
            }
            catch (Exception any) {
                any.printStackTrace();
                results.append(Messages.getString("RWikiObjectServiceImpl.31") + siteId + " " + any.toString() + "\n");
            }
            results.append(Messages.getString("RWikiObjectServiceImpl.30")).append(npages).append(Messages.getString("RWikiObjectServiceImpl.43")).append(nversions).append(Messages.getString("RWikiObjectServiceImpl.44"));
            stack.pop();
        }
        catch (IdUnusedException idUnusedException) {
            // empty catch block
        }
        return results.toString();
    }

    public String merge(String siteId, Element root, String archivePath, String fromSiteId, Map attachmentNames, Map userIdTrans, Set userListAllowImport) {
        log.info(" wiki Merge");
        StringBuffer results = new StringBuffer();
        int nversions_reject = 0;
        int npages = 0;
        int nversions = 0;
        int npages_fail = 0;
        int npages_errors = 0;
        try {
            String defaultRealm = this.siteService.getSite(siteId).getReference();
            this.wikiSecurityService.checkAdminPermission("/wiki" + defaultRealm);
            NodeList children = root.getChildNodes();
            int length = children.getLength();
            log.info("Archive has " + length + " pages ");
            for (int i = 0; i < length; ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                Element element = (Element)child;
                try {
                    RWikiCurrentObject archiverwo = this.cdao.createRWikiObject("dummy", "dummy");
                    RWikiEntity rwe = (RWikiEntity)this.getEntity((RWikiObject)archiverwo);
                    rwe.fromXml(element, defaultRealm);
                    log.info(" Merging " + archiverwo.getRevision() + ":" + rwe.getReference());
                    archiverwo.setId(null);
                    String pageName = archiverwo.getName();
                    if (this.exists(pageName, defaultRealm)) {
                        RWikiCurrentObject rwo = this.getRWikiObject(pageName, defaultRealm);
                        if (archiverwo.getRevision() >= rwo.getRevision()) {
                            ++nversions_reject;
                            results.append(Messages.getString("RWikiObjectServiceImpl.29")).append(rwo.getName()).append(Messages.getString("RWikiObjectServiceImpl.28")).append(rwo.getRevision()).append(Messages.getString("RWikiObjectServiceImpl.54")).append(archiverwo.getRevision()).append(Messages.getString("RWikiObjectServiceImpl.55")).append(Messages.getString("RWikiObjectServiceImpl.56")).append(Messages.getString("RWikiObjectServiceImpl.57"));
                            continue;
                        }
                        RWikiHistoryObject rwho = this.getRWikiHistoryObject((RWikiObject)rwo, archiverwo.getRevision());
                        if (rwho == null) {
                            rwho = this.hdao.createRWikiHistoryObject(archiverwo);
                            rwho.setRwikiobjectid(rwo.getId());
                            this.hdao.update(rwho);
                            rwho = this.getRWikiHistoryObject((RWikiObject)rwo, archiverwo.getRevision());
                            ++nversions;
                            continue;
                        }
                        ++nversions_reject;
                        results.append(Messages.getString("RWikiObjectServiceImpl.58")).append(rwo.getName()).append(Messages.getString("RWikiObjectServiceImpl.59")).append(rwo.getRevision()).append(Messages.getString("RWikiObjectServiceImpl.60") + Messages.getString("RWikiObjectServiceImpl.61") + Messages.getString("RWikiObjectServiceImpl.62") + Messages.getString("RWikiObjectServiceImpl.63"));
                        continue;
                    }
                    String newUser = (String)userIdTrans.get(archiverwo.getOwner());
                    if (newUser == null) {
                        newUser = archiverwo.getOwner();
                    }
                    this.cdao.update(archiverwo, null);
                    RWikiCurrentObject savedrwo = this.getRWikiObject(archiverwo.getName(), archiverwo.getRealm());
                    if (archiverwo.getSha1().equals(savedrwo.getSha1())) {
                        ++npages;
                        continue;
                    }
                    ++npages_errors;
                    results.append(Messages.getString("RWikiObjectServiceImpl.64")).append(savedrwo.getName()).append(Messages.getString("RWikiObjectServiceImpl.65")).append(savedrwo.getRevision()).append(Messages.getString("RWikiObjectServiceImpl.66")).append(savedrwo.getVersion().getTime()).append(Messages.getString("RWikiObjectServiceImpl.67")).append(savedrwo.getVersion()).append("\n");
                    results.append(Messages.getString("RWikiObjectServiceImpl.69")).append(archiverwo.getSha1()).append(Messages.getString("RWikiObjectServiceImpl.70")).append(savedrwo.getSha1()).append(Messages.getString("RWikiObjectServiceImpl.71")).append(archiverwo.getContent()).append(Messages.getString("RWikiObjectServiceImpl.72")).append(savedrwo.getContent()).append("\n");
                    continue;
                }
                catch (Exception ex) {
                    ++npages_fail;
                    log.error("Failed to add page ", (Throwable)ex);
                    results.append(Messages.getString("RWikiObjectServiceImpl.75")).append(element.getAttribute(Messages.getString("RWikiObjectServiceImpl.76"))).append(Messages.getString("RWikiObjectServiceImpl.77")).append(element.getAttribute(Messages.getString("RWikiObjectServiceImpl.78"))).append(Messages.getString("RWikiObjectServiceImpl.79")).append(ex.getMessage()).append("\n");
                }
            }
        }
        catch (IdUnusedException ex) {
            results.append(Messages.getString("RWikiObjectServiceImpl.81")).append(siteId).append(" :").append(ex.getMessage()).append("\n");
        }
        results.append(Messages.getString("RWikiObjectServiceImpl.84")).append(Messages.getString("RWikiObjectServiceImpl.85")).append(npages).append(Messages.getString("RWikiObjectServiceImpl.86")).append(nversions).append(Messages.getString("RWikiObjectServiceImpl.87")).append(nversions_reject).append(Messages.getString("RWikiObjectServiceImpl.88")).append(npages_fail).append(Messages.getString("RWikiObjectServiceImpl.89")).append(npages_errors).append(Messages.getString("RWikiObjectServiceImpl.90"));
        return results.toString();
    }

    public String[] myToolIds() {
        String[] toolIds = new String[]{"sakai.rwiki"};
        return toolIds;
    }

    public void transferCopyEntities(String fromContext, String toContext, List ids) {
        log.debug("==================Doing WIki transfer");
        if (fromContext.equals(toContext)) {
            log.debug("===================Source and Target Context are identical, transfer ignored");
            return;
        }
        if (!fromContext.startsWith("/")) {
            fromContext = "/site/" + fromContext;
        }
        if (!toContext.startsWith("/")) {
            toContext = "/site/" + toContext;
        }
        if (fromContext.endsWith("/") && fromContext.length() > 1) {
            fromContext = fromContext.substring(0, fromContext.length() - 1);
        }
        if (toContext.endsWith("/") && toContext.length() > 1) {
            toContext = toContext.substring(0, toContext.length() - 1);
        }
        log.debug("=================Locating Pages in from Content of " + fromContext);
        List pages = this.findRWikiSubPages(fromContext.length() > 1 ? fromContext + "/" : fromContext);
        log.debug("=================Found " + pages.size() + " Pages");
        for (RWikiObject rwo : pages) {
            RWikiEntity rwe = (RWikiEntity)this.getEntity(rwo);
            this.wikiSecurityService.checkAdmin(rwe);
            boolean transfer = true;
            if (ids != null && ids.size() > 0) {
                transfer = false;
                Iterator j = ids.iterator();
                while (j.hasNext() && !transfer) {
                    String id = (String)j.next();
                    if (!id.equals(rwo.getRwikiobjectid())) continue;
                    transfer = true;
                }
            }
            if (transfer) {
                String pageName = rwo.getName();
                log.debug("================Transfering page " + pageName + " from " + rwo.getRealm() + " to " + toContext);
                pageName = NameHelper.localizeName((String)pageName, (String)NameHelper.localizeSpace((String)pageName, (String)rwo.getRealm()));
                pageName = NameHelper.globaliseName((String)pageName, (String)toContext);
                try {
                    RWikiCurrentObject transferPage = null;
                    if (this.exists(pageName, toContext)) {
                        transferPage = this.getRWikiObject(pageName, toContext);
                        this.update(pageName, toContext, transferPage.getVersion(), rwo.getContent(), rwo.getPermissions());
                        continue;
                    }
                    String user = this.sessionManager.getCurrentSessionUserId();
                    String permissionsReference = this.wikiSecurityService.createPermissionsReference(toContext);
                    if (!this.wikiSecurityService.checkCreatePermission(permissionsReference)) {
                        throw new CreatePermissionException("User: " + user + " cannot create pages in realm: " + pageName);
                    }
                    this.update(pageName, toContext, new Date(), rwo.getContent(), rwo.getPermissions());
                }
                catch (Throwable t) {
                    log.error("================Failed to import " + pageName + " from " + fromContext + " to " + toContext);
                }
                continue;
            }
            log.debug("=============Ignoring transfer of " + rwo.getName());
        }
    }

    public boolean parseEntityReference(String reference, Reference ref) {
        EntityHandler eh;
        if (!reference.startsWith("/wiki")) {
            return false;
        }
        String[] parts = StringUtils.split((String)reference, (String)"/");
        String context = null;
        if (parts.length > 2 && (context = parts[2]).endsWith(".")) {
            context = context.substring(0, context.length() - 1);
        }
        if (context != null && context.length() > 0 && !this.siteService.siteExists(context)) {
            try {
                String newContext = this.aliasService.getTarget(context);
                if (newContext.startsWith("/site")) {
                    reference = reference.replaceFirst("/site/" + context, newContext);
                    ref.updateReference(reference);
                }
            }
            catch (Exception e) {
                log.debug(".parseEntityReference(): " + e.toString());
            }
        }
        if ((eh = this.findEntityReferenceMatch(reference)) != null) {
            eh.setReference(APPLICATION_ID, ref, reference);
        }
        return true;
    }

    public String getEntityDescription(Reference ref) {
        this.checkReference(ref);
        EntityHandler eh = this.findEntityHandler(ref);
        Entity e = this.getEntity(ref, eh);
        return eh.getDescription(e);
    }

    public ResourceProperties getEntityResourceProperties(Reference ref) {
        this.checkReference(ref);
        EntityHandler eh = this.findEntityHandler(ref);
        Entity e = this.getEntity(ref, eh);
        return eh.getProperties(e);
    }

    public Entity getEntity(Reference ref) {
        this.checkReference(ref);
        EntityHandler eh = this.findEntityHandler(ref);
        return this.getEntity(ref, eh);
    }

    public String getEntityUrl(Reference ref) {
        this.checkReference(ref);
        EntityHandler eh = this.findEntityHandler(ref);
        Entity entity = this.getEntity(ref, eh);
        return eh.getUrl(entity);
    }

    public Collection getEntityAuthzGroups(Reference ref, String userId) {
        this.checkReference(ref);
        EntityHandler eh = this.findEntityHandler(ref);
        return eh.getAuthzGroups(ref, userId);
    }

    public HttpAccess getHttpAccess() {
        return new HttpAccess(){

            public void handleAccess(HttpServletRequest req, HttpServletResponse res, Reference ref, Collection copyrightAcceptedRefs) throws EntityPermissionException, EntityNotDefinedException, EntityAccessOverloadException, EntityCopyrightException {
                block21: {
                    Session session;
                    String sessionId = req.getParameter("session");
                    if (sessionId != null && (session = RWikiObjectServiceImpl.this.sessionManager.getSession(sessionId)) != null) {
                        RWikiObjectServiceImpl.this.sessionManager.setCurrentSession(session);
                    }
                    try {
                        RWikiObjectServiceImpl.this.checkReference(ref);
                    }
                    catch (Throwable t) {
                        throw new EntityNotDefinedException(ref.getId());
                    }
                    try {
                        EntityHandler eh = RWikiObjectServiceImpl.this.findEntityHandler(ref);
                        Entity entity = RWikiObjectServiceImpl.this.getEntity(ref, eh);
                        String user = req.getRemoteUser();
                        if (entity instanceof RWikiEntity) {
                            RWikiEntity rwe = (RWikiEntity)entity;
                            if (!rwe.isContainer()) {
                                RWikiObject rwo = rwe.getRWikiObject();
                                if (RWikiObjectServiceImpl.this.wikiSecurityService.checkRead(rwe)) {
                                    String space = NameHelper.localizeSpace((String)rwo.getName(), (String)rwo.getRealm());
                                    RWikiEntity sideBar = null;
                                    if (RWikiObjectServiceImpl.this.exists("view_right", space)) {
                                        try {
                                            RWikiCurrentObject rwoSB = RWikiObjectServiceImpl.this.getRWikiObject("view_right", space);
                                            sideBar = (RWikiEntity)RWikiObjectServiceImpl.this.getEntity((RWikiObject)rwoSB);
                                            if (!RWikiObjectServiceImpl.this.wikiSecurityService.checkRead(sideBar)) {
                                                sideBar = null;
                                            }
                                        }
                                        catch (Exception ex) {
                                            sideBar = null;
                                        }
                                    }
                                    if (RWikiObjectServiceImpl.this.trackReads) {
                                        RWikiObjectServiceImpl.this.eventTrackingService.post(RWikiObjectServiceImpl.this.eventTrackingService.newEvent("wiki.read", ref.getReference(), false, 0));
                                    }
                                    eh.outputContent(entity, sideBar, req, res);
                                    break block21;
                                }
                                throw new PermissionException(user, "rwiki.read", ref.getReference());
                            }
                            if (RWikiObjectServiceImpl.this.wikiSecurityService.checkGetPermission(ref.getReference())) {
                                String space = rwe.getReference();
                                RWikiEntity sideBar = null;
                                if (RWikiObjectServiceImpl.this.exists("view_right", space)) {
                                    try {
                                        RWikiCurrentObject rwoSB = RWikiObjectServiceImpl.this.getRWikiObject("view_right", space);
                                        sideBar = (RWikiEntity)RWikiObjectServiceImpl.this.getEntity((RWikiObject)rwoSB);
                                        if (!RWikiObjectServiceImpl.this.wikiSecurityService.checkRead(sideBar)) {
                                            sideBar = null;
                                        }
                                    }
                                    catch (Exception ex) {
                                        sideBar = null;
                                    }
                                }
                                if (RWikiObjectServiceImpl.this.trackReads) {
                                    RWikiObjectServiceImpl.this.eventTrackingService.post(RWikiObjectServiceImpl.this.eventTrackingService.newEvent("wiki.read", ref.getReference(), false, 0));
                                }
                                eh.outputContent(entity, sideBar, req, res);
                                break block21;
                            }
                            throw new PermissionException(user, "rwiki.read", ref.getReference());
                        }
                        throw new EntityNotDefinedException(ref.getReference());
                    }
                    catch (PermissionException p) {
                        throw new EntityPermissionException(p.getUser(), p.getLock(), p.getResource());
                    }
                    catch (EntityNotDefinedException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        log.warn("Error getting wiki page via access :" + ref.getReference());
                        log.debug("Stack trace was ", t);
                        throw new RuntimeException(ref.getReference(), t);
                    }
                }
            }
        };
    }

    private EntityHandler findEntityReferenceMatch(String reference) {
        if (!reference.startsWith("/wiki")) {
            return null;
        }
        for (String s : this.m_handlers.keySet()) {
            EntityHandler eh = (EntityHandler)this.m_handlers.get(s);
            if (!eh.matches(reference)) continue;
            return eh;
        }
        return null;
    }

    private void checkReference(Reference ref) {
        if (!APPLICATION_ID.equals(ref.getType())) {
            throw new RuntimeException("Wiki page does not exist, sorry ");
        }
    }

    private EntityHandler findEntityHandler(Reference ref) {
        if (!APPLICATION_ID.equals(ref.getType())) {
            return null;
        }
        String subtype = ref.getSubType();
        return (EntityHandler)this.m_handlers.get(subtype);
    }

    private Entity getEntity(Reference ref, EntityHandler eh) {
        RWikiHistoryObject hrwo;
        RWikiCurrentObject rwo = this.getRWikiCurrentObjectDao().findByGlobalName(ref.getId());
        int revision = eh.getRevision(ref);
        if (rwo != null && revision != -1 && revision != rwo.getRevision() && (hrwo = this.getRWikiHistoryObjectDao().getRWikiHistoryObject((RWikiObject)rwo, revision)) != null) {
            rwo = hrwo;
        }
        RWikiEntity rwe = null;
        rwe = rwo == null ? (RWikiEntity)this.getReferenceEntity(ref) : (RWikiEntity)this.getEntity((RWikiObject)rwo);
        return rwe;
    }

    public Entity getReferenceEntity(Reference ref) {
        return new RWikiEntityImpl(ref);
    }

    public Entity getEntity(RWikiObject rwo) {
        return new RWikiEntityImpl(rwo);
    }

    public Reference getReference(RWikiObject rwo) {
        return this.entityManager.newReference(this.getEntity(rwo).getReference());
    }

    public Map getHandlers() {
        return this.m_handlers;
    }

    public void setHandlers(Map m_handlers) {
        this.m_handlers = m_handlers;
    }

    private void disableWiki(String context) {
    }

    private void enableWiki(String context) {
    }

    public List findAllChangedSince(Date time, String basepath) {
        return this.cdao.findAllChangedSince(time, basepath);
    }

    public boolean checkRead(RWikiObject rwo) {
        return this.wikiSecurityService.checkRead((RWikiEntity)this.getEntity(rwo));
    }

    public boolean checkUpdate(RWikiObject rwo) {
        return this.wikiSecurityService.checkUpdate((RWikiEntity)this.getEntity(rwo));
    }

    public boolean checkCreate(RWikiObject rwo) {
        return this.wikiSecurityService.checkCreate((RWikiEntity)this.getEntity(rwo));
    }

    public boolean checkAdmin(RWikiObject rwo) {
        return this.wikiSecurityService.checkAdmin((RWikiEntity)this.getEntity(rwo));
    }

    public List findAllPageNames() {
        return this.cdao.findAllPageNames();
    }

    public String createReference(String pageName) {
        return "/wiki" + pageName + ".";
    }

    public PageLinkRenderer getComponentPageLinkRender(String pageSpace, boolean withBreadCrumb) {
        return new ComponentPageLinkRenderImpl(pageSpace, withBreadCrumb);
    }

    public AliasService getAliasService() {
        return this.aliasService;
    }

    public void setAliasService(AliasService aliasService) {
        this.aliasService = aliasService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transferCopyEntities(String fromContext, String toContext, List ids, boolean cleanup) {
        try {
            if (!cleanup) {
                // empty if block
            }
        }
        catch (Exception e) {
            log.info("Rwiki transferCopyEntities Error" + e);
        }
        this.transferCopyEntities(fromContext, toContext, ids);
    }
}

