/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.component.service.impl;

import java.util.List;
import org.sakaiproject.authz.api.FunctionManager;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.ToolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.cam.caret.sakai.rwiki.component.Messages;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiSecurityService;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiEntity;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.service.exception.PermissionException;
import uk.ac.cam.caret.sakai.rwiki.utils.TimeLogger;

public class RWikiSecurityServiceImpl
implements RWikiSecurityService {
    private static Logger log = LoggerFactory.getLogger(RWikiSecurityServiceImpl.class);
    private FunctionManager functionManager;
    private SecurityService securityService;
    private SiteService siteService;
    private ToolManager toolManager;
    private EntityManager entityManager;
    private SessionManager sessionManager;

    public void init() {
        ComponentManager cm = org.sakaiproject.component.cover.ComponentManager.getInstance();
        this.functionManager = (FunctionManager)this.load(cm, FunctionManager.class.getName());
        this.entityManager = (EntityManager)this.load(cm, EntityManager.class.getName());
        this.securityService = (SecurityService)this.load(cm, SecurityService.class.getName());
        this.sessionManager = (SessionManager)this.load(cm, SessionManager.class.getName());
        this.siteService = (SiteService)this.load(cm, SiteService.class.getName());
        this.toolManager = (ToolManager)this.load(cm, ToolManager.class.getName());
        List l = this.functionManager.getRegisteredFunctions("rwiki.");
        if (!l.contains("rwiki.read")) {
            this.functionManager.registerFunction("rwiki.read");
        }
        if (!l.contains("rwiki.update")) {
            this.functionManager.registerFunction("rwiki.update");
        }
        if (!l.contains("rwiki.create")) {
            this.functionManager.registerFunction("rwiki.create");
        }
        if (!l.contains("rwiki.superadmin")) {
            this.functionManager.registerFunction("rwiki.superadmin");
        }
        if (!l.contains("rwiki.admin")) {
            this.functionManager.registerFunction("rwiki.admin");
        }
    }

    private Object load(ComponentManager cm, String name) {
        Object o = cm.get(name);
        if (o == null) {
            log.error("Cant find Spring component named " + name);
        }
        return o;
    }

    public String getSiteReference() {
        try {
            Site currentSite = this.siteService.getSite(this.toolManager.getCurrentPlacement().getContext());
            return currentSite.getReference();
        }
        catch (IdUnusedException e) {
            throw new PermissionException(Messages.getString("RWikiSecurityServiceImpl.2"));
        }
    }

    public String getSiteId() {
        return this.toolManager.getCurrentPlacement().getContext();
    }

    public boolean checkGetPermission(String reference) {
        return this.securityService.unlock("rwiki.read", reference);
    }

    public boolean checkUpdatePermission(String reference) {
        return this.securityService.unlock("rwiki.update", reference);
    }

    public boolean checkAdminPermission(String reference) {
        return this.securityService.unlock("rwiki.admin", reference);
    }

    public boolean checkSuperAdminPermission(String reference) {
        return this.securityService.unlock("rwiki.superadmin", reference);
    }

    public boolean checkCreatePermission(String reference) {
        return this.securityService.unlock("rwiki.create", reference);
    }

    public boolean checkSearchPermission(String reference) {
        return this.securityService.unlock("rwiki.read", reference);
    }

    public String createPermissionsReference(String pageSpace) {
        Reference ref = this.entityManager.newReference("/wiki" + pageSpace + ".");
        return ref.getReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkRead(RWikiEntity rwe) {
        RWikiObject rwo = rwe.getRWikiObject();
        String progress = "";
        long start = System.currentTimeMillis();
        try {
            String user = this.sessionManager.getCurrentSessionUserId();
            if (log.isDebugEnabled()) {
                log.debug("checkRead for " + rwo.getName() + " by user: " + user);
            }
            if (user != null && user.equals(rwo.getOwner()) && (rwo.getOwnerRead() || rwo.getOwnerAdmin())) {
                if (log.isDebugEnabled()) {
                    log.debug("User is owner and allowed to read");
                }
                progress = progress + "1";
                boolean bl = true;
                return bl;
            }
            String permissionsReference = rwe.getReference();
            if (rwo.getGroupRead() && this.checkGetPermission(permissionsReference) || rwo.getGroupWrite() && this.checkUpdatePermission(permissionsReference) || rwo.getGroupAdmin() && this.checkAdminPermission(permissionsReference)) {
                if (log.isDebugEnabled()) {
                    log.debug("User is in group and allowed to read");
                }
                progress = progress + "2";
                boolean bl = true;
                return bl;
            }
            if (rwo.getPublicRead()) {
                if (log.isDebugEnabled()) {
                    log.debug("Object is public read");
                }
                progress = progress + "3";
                boolean bl = true;
                return bl;
            }
            if (this.checkSuperAdminPermission(permissionsReference)) {
                if (log.isDebugEnabled()) {
                    log.debug("User is SuperAdmin for Realm thus default allowed to update");
                }
                progress = progress + "4";
                boolean bl = true;
                return bl;
            }
            if (log.isDebugEnabled()) {
                log.debug("Permission denied to read " + rwo.getName() + " by user: " + user);
            }
            progress = progress + "5";
            boolean bl = false;
            return bl;
        }
        finally {
            long finish = System.currentTimeMillis();
            TimeLogger.printTimer((String)("canRead: " + progress), (long)start, (long)finish);
        }
    }

    public boolean checkUpdate(RWikiEntity rwe) {
        String user = this.sessionManager.getCurrentSessionUserId();
        RWikiObject rwo = rwe.getRWikiObject();
        if (log.isDebugEnabled()) {
            log.debug("checkUpdate for " + rwo.getName() + " by user: " + user);
        }
        if (user != null && user.equals(rwo.getOwner()) && (rwo.getOwnerWrite() || rwo.getOwnerAdmin())) {
            if (log.isDebugEnabled()) {
                log.debug("User is owner and allowed to update");
            }
            return true;
        }
        String permissionsReference = rwe.getReference();
        if (rwo.getGroupWrite() && this.checkUpdatePermission(permissionsReference) || rwo.getGroupAdmin() && this.checkAdminPermission(permissionsReference)) {
            if (log.isDebugEnabled()) {
                log.debug("User is in group and allowed to update");
            }
            return true;
        }
        if (rwo.getPublicWrite()) {
            if (log.isDebugEnabled()) {
                log.debug("Object is public write");
            }
            return true;
        }
        if (this.checkSuperAdminPermission(permissionsReference)) {
            if (log.isDebugEnabled()) {
                log.debug("User is SuperAdmin for Realm thus default allowed to update");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Permission denied to update " + rwo.getName() + " by user: " + user);
        }
        return false;
    }

    public boolean checkCreate(RWikiEntity rwe) {
        String user = this.sessionManager.getCurrentSessionUserId();
        RWikiObject rwo = rwe.getRWikiObject();
        if (log.isDebugEnabled()) {
            log.debug("checkCreate for " + rwo.getName() + " by user: " + user);
        }
        if (user != null && user.equals(rwo.getOwner()) && (rwo.getOwnerWrite() || rwo.getOwnerAdmin())) {
            if (log.isDebugEnabled()) {
                log.debug("User is owner and allowed to create");
            }
            return true;
        }
        String permissionsReference = rwe.getReference();
        if (rwo.getGroupWrite() && this.checkCreatePermission(permissionsReference) || rwo.getGroupAdmin() && this.checkAdminPermission(permissionsReference)) {
            if (log.isDebugEnabled()) {
                log.debug("User is in group and allowed to create");
            }
            return true;
        }
        if (rwo.getPublicWrite()) {
            if (log.isDebugEnabled()) {
                log.debug("Object is public write");
            }
            return true;
        }
        if (this.checkSuperAdminPermission(permissionsReference)) {
            if (log.isDebugEnabled()) {
                log.debug("User is SuperAdmin for Realm thus default allowed to create");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Permission denied to create " + rwo.getName() + " by user: " + user);
        }
        return false;
    }

    public boolean checkAdmin(RWikiEntity rwe) {
        String user = this.sessionManager.getCurrentSessionUserId();
        RWikiObject rwo = rwe.getRWikiObject();
        if (log.isDebugEnabled()) {
            log.debug("checkAdmin for " + rwo.getName() + " by user: " + user);
        }
        if (user != null && user.equals(rwo.getOwner()) && rwo.getOwnerAdmin()) {
            if (log.isDebugEnabled()) {
                log.debug("User is owner and allowed to admin");
            }
            return true;
        }
        String permissionsReference = rwe.getReference();
        if (rwo.getGroupAdmin() && this.checkAdminPermission(permissionsReference)) {
            if (log.isDebugEnabled()) {
                log.debug("User is in group and allowed to admin");
            }
            return true;
        }
        if (this.checkSuperAdminPermission(permissionsReference)) {
            if (log.isDebugEnabled()) {
                log.debug("User is Super Admin for Realm thus default allowed to admin");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Permission denied to admin " + rwo.getName() + " by user: " + user);
        }
        return false;
    }
}

