/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool;

import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.ToolManager;
import org.springframework.context.ApplicationContext;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiObjectService;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiSecurityService;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiCurrentObject;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiHistoryObject;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.MessageService;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.PreferenceService;
import uk.ac.cam.caret.sakai.rwiki.tool.api.PopulateService;
import uk.ac.cam.caret.sakai.rwiki.tool.api.ToolRenderService;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.AuthZGroupBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.AuthZGroupCollectionBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.AuthZGroupEditBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.DiffBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.EditBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ErrorBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.FullSearchBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.HistoryBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.HomeBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.MultiRealmEditBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.PermissionsBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.PrePopulateBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.PreferencesBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.PresenceBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.RecentlyVisitedBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ReferencesBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.RenderBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ResourceLoaderBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.SearchBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ToolConfigBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.UpdatePermissionsBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ViewBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.AuthZGroupBeanHelper;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.AuthZGroupCollectionBeanHelper;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.AuthZGroupEditBeanHelper;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.DiffHelperBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.MultiRealmEditBeanHelper;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.PreferencesBeanHelper;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.PresenceBeanHelper;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.RecentlyVisitedHelperBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.ReverseHistoryHelperBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.ReviewHelperBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.UpdatePermissionsBeanHelper;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.UserHelperBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.ViewParamsHelperBean;
import uk.ac.cam.caret.sakai.rwiki.tool.util.WikiPageAction;

public class RequestScopeSuperBean {
    private static Log log = LogFactory.getLog(RequestScopeSuperBean.class);
    public static final String REQUEST_ATTRIBUTE = "rsacMap";
    private HttpServletRequest request;
    private HashMap<String, Object> map = new HashMap();
    private ApplicationContext context;
    private RWikiSecurityService securityService;
    private RWikiObjectService objectService;
    private ToolRenderService toolRenderService;
    private PopulateService populateService;
    private AuthzGroupService realmService;
    private MessageService messageService;
    private PreferenceService preferenceService;
    private SearchService searchService;
    private ResourceLoaderBean resourceLoader;
    private boolean experimental = false;
    private boolean withnotification = false;
    private boolean withcomments = false;
    private ToolManager toolManager;
    private SessionManager sessionManager;
    private SiteService siteService;
    private String defaultUIHomePageName;
    private boolean searchExperimental = false;
    private static ThreadLocal<RequestScopeSuperBean> requestScopeSuperBeanHolder = new ThreadLocal();

    public static RequestScopeSuperBean getFromRequest(HttpServletRequest request) {
        return (RequestScopeSuperBean)request.getAttribute(REQUEST_ATTRIBUTE);
    }

    public static RequestScopeSuperBean getInstance() {
        return (RequestScopeSuperBean)requestScopeSuperBeanHolder.get();
    }

    public static void clearInstance() {
        requestScopeSuperBeanHolder.set(null);
    }

    public static RequestScopeSuperBean createAndAttach(HttpServletRequest request, ApplicationContext context) {
        RequestScopeSuperBean rssb = new RequestScopeSuperBean();
        rssb.setRequest(request);
        rssb.setContext(context);
        rssb.init();
        request.setAttribute(REQUEST_ATTRIBUTE, (Object)rssb);
        requestScopeSuperBeanHolder.set(rssb);
        return rssb;
    }

    public void init() {
        this.securityService = (RWikiSecurityService)this.context.getBean(RWikiSecurityService.class.getName());
        this.objectService = (RWikiObjectService)this.context.getBean(RWikiObjectService.class.getName());
        this.toolRenderService = (ToolRenderService)this.context.getBean(ToolRenderService.class.getName());
        this.populateService = (PopulateService)this.context.getBean(PopulateService.class.getName());
        this.realmService = (AuthzGroupService)this.context.getBean(AuthzGroupService.class.getName());
        this.preferenceService = (PreferenceService)this.context.getBean(PreferenceService.class.getName());
        this.toolManager = (ToolManager)this.context.getBean(ToolManager.class.getName());
        this.sessionManager = (SessionManager)this.context.getBean(SessionManager.class.getName());
        this.siteService = (SiteService)this.context.getBean(SiteService.class.getName());
        this.messageService = (MessageService)this.context.getBean(MessageService.class.getName());
        this.experimental = ServerConfigurationService.getBoolean((String)"wiki.experimental", (boolean)false);
        this.searchExperimental = ServerConfigurationService.getBoolean((String)"wiki.fullsearch", (boolean)true) && ServerConfigurationService.getBoolean((String)"search.enable", (boolean)false);
        this.withnotification = ServerConfigurationService.getBoolean((String)"wiki.notification", (boolean)true);
        this.withcomments = ServerConfigurationService.getBoolean((String)"wiki.comments", (boolean)true);
        this.defaultUIHomePageName = ServerConfigurationService.getString((String)"wiki.ui.homepage", (String)"Home");
        if (this.searchExperimental) {
            this.searchService = (SearchService)this.context.getBean(SearchService.class.getName());
        }
        if (this.messageService != null) {
            Session session = this.sessionManager.getCurrentSession();
            String userId = this.getCurrentUserId();
            if (userId != null && userId.length() > 0) {
                String currentPageName = this.getCurrentPageName();
                String pageSpace = this.getCurrentPageSpace();
                if (currentPageName != null && currentPageName.length() < 255 && pageSpace != null && pageSpace.length() < 255) {
                    this.messageService.updatePresence(session.getId(), userId, this.getCurrentPageName(), this.getCurrentPageSpace());
                } else {
                    log.warn((Object)("Page names in wiki cannot be over 225 characters in length, presence not updated. Page Name was " + currentPageName));
                }
            }
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public void setContext(ApplicationContext context) {
        this.context = context;
    }

    public ViewParamsHelperBean getNameHelperBean() {
        String key = "nameHelperBean";
        if (this.map.get(key) == null) {
            ViewParamsHelperBean vphb = new ViewParamsHelperBean();
            vphb.setServletRequest((ServletRequest)this.request);
            vphb.setSecurityService(this.securityService);
            vphb.setToolConfigBean(this.getConfigBean());
            vphb.init();
            this.map.put(key, vphb);
        }
        return (ViewParamsHelperBean)this.map.get(key);
    }

    public String getCurrentLocalSpace() {
        String key = "currentLocalSpace";
        if (this.map.get(key) == null) {
            ViewParamsHelperBean vphb = this.getNameHelperBean();
            this.map.put(key, vphb.getLocalSpace());
        }
        return (String)this.map.get(key);
    }

    public String getCurrentDefaultRealm() {
        String key = "currentDefaultRealm";
        if (this.map.get(key) == null) {
            ViewParamsHelperBean vphb = this.getNameHelperBean();
            this.map.put(key, vphb.getDefaultRealm());
        }
        return (String)this.map.get(key);
    }

    public String getCurrentPageName(boolean refresh) {
        String key = "currentPageName";
        if (this.map.get(key) == null || refresh) {
            this.map.put(key, this.getNameHelperBean().getGlobalName());
        }
        return (String)this.map.get(key);
    }

    public String getCurrentPageName() {
        return this.getCurrentPageName(false);
    }

    public String getCurrentPageSpace() {
        String key = "currentPageSpace";
        if (this.map.get(key) == null) {
            this.map.put(key, this.getNameHelperBean().getPageSpace());
        }
        return (String)this.map.get(key);
    }

    public String getCurrentSearch() {
        String key = "currentSearch";
        if (this.map.get(key) == null) {
            this.map.put(key, this.getNameHelperBean().getSearch());
        }
        return (String)this.map.get(key);
    }

    public String getCurrentSearchPage() {
        String key = "currentSearchPage";
        if (this.map.get(key) == null) {
            this.map.put(key, this.getNameHelperBean().getSearchPage());
        }
        return (String)this.map.get(key);
    }

    public String getCurrentUserId() {
        String key = "currentUserId";
        if (this.map.get(key) == null) {
            this.map.put(key, this.sessionManager.getCurrentSessionUserId());
        }
        return (String)this.map.get(key);
    }

    public String getCurrentUser() {
        String key = "currentUser";
        if (this.map.get(key) == null) {
            UserHelperBean uhb = new UserHelperBean();
            uhb.setServletRequest((ServletRequest)this.request);
            uhb.init();
            this.map.put(key, uhb.getUser());
        }
        return (String)this.map.get(key);
    }

    public String getWorksiteOwner() {
        try {
            Site s = this.siteService.getSite(this.toolManager.getCurrentPlacement().getContext());
            return s.getCreatedBy().getId();
        }
        catch (IdUnusedException idUnusedException) {
            return "admin";
        }
    }

    public ViewBean getViewBean() {
        String key = "viewBean";
        if (this.map.get(key) == null) {
            ViewBean vb = new ViewBean();
            vb.setLocalSpace(this.getCurrentLocalSpace());
            vb.setPageName(this.getCurrentPageName());
            this.map.put(key, vb);
        }
        return (ViewBean)this.map.get(key);
    }

    public ResourceLoaderBean getResourceLoaderBean() {
        String key = "resourceLoaderBean";
        if (this.map.get(key) == null) {
            ResourceLoaderBean rb = new ResourceLoaderBean();
            rb.init(this.request);
            this.map.put(key, rb);
        }
        return (ResourceLoaderBean)this.map.get(key);
    }

    public RWikiObject getCurrentRWikiObject(boolean refresh) {
        String key = "currentRWikiObject";
        if (this.map.get(key) == null || refresh) {
            RWikiCurrentObject rwo = this.objectService.getRWikiObject(this.getCurrentPageName(), this.getCurrentLocalSpace());
            this.map.put(key, rwo);
        }
        return (RWikiObject)this.map.get(key);
    }

    public RWikiObject getCurrentRWikiObject() {
        return this.getCurrentRWikiObject(false);
    }

    public String getCurrentRWikiObjectReference() {
        String key = "currentRWikiObjectReference";
        if (this.map.get(key) == null) {
            RWikiObject rwo = this.getCurrentRWikiObject();
            Entity e = this.objectService.getEntity(rwo);
            this.map.put(key, e.getReference());
        }
        return (String)this.map.get(key);
    }

    public RecentlyVisitedBean getRecentlyVisitedBean() {
        String key = "recentlyVisitedBean";
        if (this.map.get(key) == null) {
            RecentlyVisitedHelperBean rvhb = new RecentlyVisitedHelperBean();
            rvhb.setServletRequest((ServletRequest)this.request);
            rvhb.setDefaultSpace(this.getCurrentDefaultRealm());
            rvhb.init();
            this.map.put(key, rvhb.getRecentlyVisitedBean());
        }
        return (RecentlyVisitedBean)this.map.get(key);
    }

    public boolean getWithBreadcrumbs() {
        String key = "withBreadcrumbs";
        if (this.map.get(key) == null) {
            ViewParamsHelperBean vphb = this.getNameHelperBean();
            this.map.put(key, vphb.getWithBreadcrumbs());
        }
        return !"0".equals(this.map.get(key));
    }

    public RenderBean getRenderBean() {
        String key = "renderBean";
        if (this.map.get(key) == null) {
            RenderBean rb = new RenderBean(this.getCurrentRWikiObject(), this.toolRenderService, this.objectService, this.getWithBreadcrumbs());
            this.map.put(key, rb);
        }
        return (RenderBean)this.map.get(key);
    }

    public HistoryBean getHistoryBean() {
        String key = "historyBean";
        if (this.map.get(key) == null) {
            HistoryBean hb = new HistoryBean(this.getCurrentRWikiObject(), this.getCurrentLocalSpace());
            this.map.put(key, hb);
        }
        return (HistoryBean)this.map.get(key);
    }

    public ReverseHistoryHelperBean getReverseHistoryHelperBean() {
        String key = "reverseHistoryHelperBean";
        if (this.map.get(key) == null) {
            ReverseHistoryHelperBean rhhb = new ReverseHistoryHelperBean();
            rhhb.setRwikiObject(this.getCurrentRWikiObject());
            rhhb.setRwikiObjectService(this.objectService);
            this.map.put(key, rhhb);
        }
        return (ReverseHistoryHelperBean)this.map.get(key);
    }

    public DiffBean getDiffBean() {
        String key = "diffBean";
        if (this.map.get(key) == null) {
            DiffHelperBean dhb = new DiffHelperBean();
            dhb.setServletRequest((ServletRequest)this.request);
            dhb.setRwikiObject(this.getCurrentRWikiObject());
            dhb.setRwikiObjectService(this.objectService);
            dhb.init();
            this.map.put(key, dhb.getDiffBean());
        }
        return (DiffBean)this.map.get(key);
    }

    public PrePopulateBean getPrePopulateBean() {
        String key = "prePopulateBean";
        if (this.map.get(key) == null) {
            PrePopulateBean ppb = new PrePopulateBean();
            ppb.setPopulateService(this.populateService);
            ppb.setCurrentGroup(this.getCurrentDefaultRealm());
            ppb.setCurrentPageRealm(this.getCurrentPageSpace());
            ppb.setWoksiteOwner(this.getWorksiteOwner());
            this.map.put(key, ppb);
        }
        return (PrePopulateBean)this.map.get(key);
    }

    public FullSearchBean getFullSearchBean() {
        if (this.searchExperimental) {
            String key = "fullSearchBean";
            if (this.map.get(key) == null) {
                FullSearchBean sb = new FullSearchBean(this.getCurrentSearch(), this.getCurrentSearchPage(), this.getCurrentLocalSpace(), this.searchService, this.toolManager);
                this.map.put(key, sb);
            }
            return (FullSearchBean)this.map.get(key);
        }
        return null;
    }

    public SearchBean getSearchBean() {
        String key = "searchBean";
        if (this.map.get(key) == null) {
            SearchBean sb = new SearchBean(this.getCurrentSearch(), this.getCurrentLocalSpace(), this.objectService);
            this.map.put(key, sb);
        }
        return (SearchBean)this.map.get(key);
    }

    public PermissionsBean getPermissionsBean() {
        String key = "permissionsBean";
        if (this.map.get(key) == null) {
            PermissionsBean pb = new PermissionsBean(this.getCurrentRWikiObject(), this.objectService);
            this.map.put(key, pb);
        }
        return (PermissionsBean)this.map.get(key);
    }

    public ErrorBean getErrorBean() {
        String key = "errorBean";
        if (this.map.get(key) == null) {
            this.map.put(key, new ErrorBean());
        }
        return (ErrorBean)this.map.get(key);
    }

    public EditBean getEditBean() {
        String key = "editBean";
        if (this.map.get(key) == null) {
            ViewParamsHelperBean vphb = this.getNameHelperBean();
            EditBean editBean = new EditBean();
            editBean.setPreviousContent(vphb.getContent());
            editBean.setPreviousVersion(vphb.getSubmittedVersion());
            editBean.setSaveType(vphb.getSaveType());
            this.map.put(key, editBean);
        }
        return (EditBean)this.map.get(key);
    }

    public ReviewHelperBean getReviewHelperBean() {
        String key = "reviewHelperBean";
        if (this.map.get(key) == null) {
            ReviewHelperBean rhb = new ReviewHelperBean();
            rhb.setServletRequest((ServletRequest)this.request);
            rhb.setRwikiObject(this.getCurrentRWikiObject());
            rhb.setRwikiObjectService(this.objectService);
            rhb.init();
            this.map.put(key, rhb);
        }
        return (ReviewHelperBean)this.map.get(key);
    }

    public RenderBean getReviewRenderBean() {
        String key = "reviewRenderBean";
        if (this.map.get(key) == null) {
            RenderBean rb = new RenderBean(this.getReviewHelperBean().getMock(), this.toolRenderService, this.objectService, this.getWithBreadcrumbs());
            this.map.put(key, rb);
        }
        return (RenderBean)this.map.get(key);
    }

    public RenderBean getViewRightRenderBean() {
        String key = "viewRightRenderBean";
        if (this.map.get(key) == null) {
            String pageName = "view_right";
            RenderBean rb = new RenderBean(pageName, this.getCurrentDefaultRealm(), this.toolRenderService, this.objectService, this.getWithBreadcrumbs());
            this.map.put(key, rb);
        }
        return (RenderBean)this.map.get(key);
    }

    public RenderBean getEditRightRenderBean() {
        String key = "editRightRenderBean";
        if (this.map.get(key) == null) {
            String pageName = "edit_right";
            RenderBean rb = new RenderBean(pageName, this.getCurrentDefaultRealm(), this.toolRenderService, this.objectService, this.getWithBreadcrumbs());
            this.map.put(key, rb);
        }
        return (RenderBean)this.map.get(key);
    }

    public RenderBean getInfoRightRenderBean() {
        String key = "infoRightRenderBean";
        if (this.map.get(key) == null) {
            String pageName = "info_right";
            RenderBean rb = new RenderBean(pageName, this.getCurrentDefaultRealm(), this.toolRenderService, this.objectService, this.getWithBreadcrumbs());
            this.map.put(key, rb);
        }
        return (RenderBean)this.map.get(key);
    }

    public RenderBean getReviewRightRenderBean() {
        String key = "reviewRightRenderBean";
        if (this.map.get(key) == null) {
            String pageName = "review_right";
            RenderBean rb = new RenderBean(pageName, this.getCurrentDefaultRealm(), this.toolRenderService, this.objectService, this.getWithBreadcrumbs());
            this.map.put(key, rb);
        }
        return (RenderBean)this.map.get(key);
    }

    public RenderBean getDiffRightRenderBean() {
        String key = "diffRightRenderBean";
        if (this.map.get(key) == null) {
            String pageName = "diff_right";
            RenderBean rb = new RenderBean(pageName, this.getCurrentDefaultRealm(), this.toolRenderService, this.objectService, this.getWithBreadcrumbs());
            this.map.put(key, rb);
        }
        return (RenderBean)this.map.get(key);
    }

    public RenderBean getSearchRightRenderBean() {
        String key = "searchRightRenderBean";
        if (this.map.get(key) == null) {
            String pageName = "search_right";
            RenderBean rb = new RenderBean(pageName, this.getCurrentDefaultRealm(), this.toolRenderService, this.objectService, this.getWithBreadcrumbs());
            this.map.put(key, rb);
        }
        return (RenderBean)this.map.get(key);
    }

    public RenderBean getPreviewRightRenderBean() {
        String key = "previewRightRenderBean";
        if (this.map.get(key) == null) {
            String pageName = "preview_right";
            RenderBean rb = new RenderBean(pageName, this.getCurrentDefaultRealm(), this.toolRenderService, this.objectService, this.getWithBreadcrumbs());
            this.map.put(key, rb);
        }
        return (RenderBean)this.map.get(key);
    }

    public ReferencesBean getReferencesBean() {
        String key = "referencesBean";
        if (this.map.get(key) == null) {
            ReferencesBean rb = new ReferencesBean(this.getCurrentRWikiObject(), this.objectService, this.getCurrentLocalSpace());
            this.map.put(key, rb);
        }
        return (ReferencesBean)this.map.get(key);
    }

    public HomeBean getHomeBean() {
        String key = "homeBean";
        if (this.map.get(key) == null) {
            HomeBean hb = new HomeBean();
            ViewParamsHelperBean vphb = this.getNameHelperBean();
            ViewBean vb = new ViewBean(this.getConfigBean().getHomePage(), vphb.getDefaultRealm());
            hb.setHomeLinkUrl(vb.getViewUrl());
            hb.setHomeLinkValue(this.getConfigBean().getHomePageName());
            this.map.put(key, hb);
        }
        return (HomeBean)this.map.get(key);
    }

    public UpdatePermissionsBean getUpdatePermissionsBean() {
        String key = "updatePermissionsBean";
        if (this.map.get(key) == null) {
            UpdatePermissionsBean ub = UpdatePermissionsBeanHelper.createUpdatePermissionsBean((HttpServletRequest)this.request, (RWikiObjectService)this.objectService);
            this.map.put(key, ub);
        }
        return (UpdatePermissionsBean)this.map.get(key);
    }

    public AuthZGroupBean getRealmBean() {
        String key = "realmBean";
        if (this.map.get(key) == null) {
            String siteId = this.toolManager.getCurrentPlacement().getContext();
            AuthZGroupBean rb = AuthZGroupBeanHelper.createRealmBean((AuthzGroupService)this.realmService, (SiteService)this.siteService, (RWikiObject)this.getCurrentRWikiObject(), (ErrorBean)this.getErrorBean(), (ViewBean)this.getViewBean(), (String)siteId);
            this.map.put(key, rb);
        }
        return (AuthZGroupBean)this.map.get(key);
    }

    public AuthZGroupEditBean getRealmEditBean() {
        String key = "realmEditBean";
        if (this.map.get(key) == null) {
            AuthZGroupEditBean reb = AuthZGroupEditBeanHelper.createRealmEditBean((HttpServletRequest)this.request, (ViewBean)this.getViewBean());
            this.map.put(key, reb);
        }
        return (AuthZGroupEditBean)this.map.get(key);
    }

    public AuthZGroupCollectionBean getAuthZGroupCollectionBean() {
        String key = "authZGroupCollectionBean";
        if (this.map.get(key) == null) {
            AuthZGroupCollectionBean cb = AuthZGroupCollectionBeanHelper.createAuthZCollectionBean((AuthzGroupService)this.realmService, (RWikiObject)this.getCurrentRWikiObject(), (ViewBean)this.getViewBean(), (RWikiObjectService)this.objectService);
            this.map.put(key, cb);
        }
        return (AuthZGroupCollectionBean)this.map.get(key);
    }

    public MultiRealmEditBean getMultiRealmEditBean() {
        String key = "multiRealmEditBean";
        if (this.map.get(key) == null) {
            MultiRealmEditBean cb = MultiRealmEditBeanHelper.createMultiRealmEditBean((RWikiObject)this.getCurrentRWikiObject(), (HttpServletRequest)this.request, (RequestScopeSuperBean)this);
            this.map.put(key, cb);
        }
        return (MultiRealmEditBean)this.map.get(key);
    }

    public PresenceBean getPresenceBean() {
        String key = "presenceBean";
        PresenceBean pb = (PresenceBean)this.map.get(key);
        if (pb == null) {
            pb = PresenceBeanHelper.createRealmBean((MessageService)this.messageService, (String)this.getCurrentPageName(), (String)this.getCurrentPageSpace());
            this.map.put(key, pb);
        }
        return pb;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public PreferencesBean getPreferencesBean() {
        String key = "preferencesBean";
        PreferencesBean pb = (PreferencesBean)this.map.get(key);
        if (pb == null) {
            pb = PreferencesBeanHelper.createPreferencesBean((String)this.getCurrentUserId(), (String)this.getCurrentPageSpace(), (PreferenceService)this.preferenceService);
            this.map.put(key, pb);
        }
        return pb;
    }

    public boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(boolean experimental) {
        this.experimental = experimental;
    }

    public String getSearchTarget() {
        if (this.searchExperimental) {
            return WikiPageAction.FULL_SEARCH_ACTION.getName();
        }
        return WikiPageAction.SEARCH_ACTION.getName();
    }

    public boolean isWithnotification() {
        return this.withnotification;
    }

    public void setWithnotification(boolean withnotification) {
        this.withnotification = withnotification;
    }

    public boolean isWithcomments() {
        return this.withcomments;
    }

    public void setWithcomments(boolean withcomments) {
        this.withcomments = withcomments;
    }

    public ToolConfigBean getConfigBean() {
        String key = "toolConfigBean";
        ToolConfigBean configBean = (ToolConfigBean)this.map.get(key);
        if (configBean == null) {
            configBean = new ToolConfigBean(this.toolManager.getCurrentPlacement(), this.defaultUIHomePageName);
            this.map.put(key, configBean);
        }
        return configBean;
    }

    public boolean getLoadAutoSave() {
        boolean b = this.getNameHelperBean().isLoadAutoSave();
        return b;
    }

    public boolean getRemoveAutoSave() {
        boolean b = this.getNameHelperBean().isRemoveAutoSave();
        return b;
    }

    public String getPageRevisionContent(RWikiObject currentRWikiObject, int previousRevision) {
        RWikiHistoryObject rwo = this.objectService.getRWikiHistoryObject(currentRWikiObject, previousRevision);
        if (rwo == null) {
            return "";
        }
        return rwo.getContent();
    }

    public RenderBean getPreviewRenderBean() {
        String key = "renderBean";
        if (this.map.get(key) == null) {
            ViewParamsHelperBean vphb = this.getNameHelperBean();
            RenderBean rb = new RenderBean(this.getCurrentRWikiObject(), this.toolRenderService, this.objectService, this.getWithBreadcrumbs());
            String content = vphb.getContent();
            rb.setPreviewContent(content);
            this.map.put(key, rb);
        }
        return (RenderBean)this.map.get(key);
    }
}

