/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.Role;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.RoleBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ViewBean;
import uk.ac.cam.caret.sakai.rwiki.tool.util.WikiPageAction;

public class AuthZGroupBean
extends ViewBean {
    private AuthzGroup currentRealm = null;
    private String realmId = null;
    private boolean siteUpdateAllowed;

    public AuthZGroupBean(String pageName, String localSpace) {
        super(pageName, localSpace);
    }

    public AuthZGroupBean() {
    }

    public List getRoles() {
        if (this.currentRealm == null) {
            return new ArrayList();
        }
        Set roleset = this.currentRealm.getRoles();
        if (roleset == null) {
            return new ArrayList();
        }
        Object[] roles = roleset.toArray(new Role[roleset.size()]);
        Arrays.sort(roles);
        ArrayList<RoleBean> roleBeans = new ArrayList<RoleBean>(roles.length);
        for (int i = 0; i < roles.length; ++i) {
            roleBeans.add(new RoleBean((Role)roles[i]));
        }
        return roleBeans;
    }

    public boolean isActiveAuthZGroup() {
        return this.currentRealm != null;
    }

    public String getEditRealmUrl() {
        return this.getPageUrl(this.getPageName(), WikiPageAction.EDIT_REALM_ACTION.getName());
    }

    public String getEditRealmManyUrl() {
        return this.getPageUrl(this.getPageName(), WikiPageAction.EDIT_REALM_MANY_ACTION.getName());
    }

    public AuthzGroup getRealmEdit() {
        return this.currentRealm;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public String getRealmReference() {
        return this.currentRealm.getReference();
    }

    public void setCurrentRealm(AuthzGroup currentRealm) {
        this.currentRealm = currentRealm;
        this.setLocalSpace(currentRealm.getId());
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public boolean isSiteUpdateAllowed() {
        return this.siteUpdateAllowed;
    }

    public void setSiteUpdateAllowed(boolean siteUpdateAllowed) {
        this.siteUpdateAllowed = siteUpdateAllowed;
    }

    public String getEscapedId() {
        return this.realmId.replaceAll("_", "__");
    }
}

