/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.bean;

import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiObjectService;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.GenericDiffBean;

public class DiffBean {
    private RWikiObject left;
    private RWikiObject right;
    private RWikiObject rwo;
    private RWikiObjectService rwikiObjectService;
    private int rightVersionNumber;
    private int leftVersionNumber;
    private GenericDiffBean db;

    public DiffBean(RWikiObject rwikiObject, RWikiObjectService rwikiObjectService, String left, String right) {
        this.rwo = rwikiObject;
        this.rwikiObjectService = rwikiObjectService;
        this.leftVersionNumber = rwikiObject.getRevision() - 1;
        this.rightVersionNumber = rwikiObject.getRevision();
        if (this.leftVersionNumber < 0) {
            this.leftVersionNumber = 0;
        }
        this.setRightVersionNumber(right);
        this.setLeftVersionNumber(left);
    }

    private void setLeftVersionNumber(String versionString) {
        if (versionString != null && !"".equals(versionString)) {
            this.leftVersionNumber = Integer.parseInt(versionString);
        }
        try {
            this.left = this.rwo.getRevision() == this.leftVersionNumber ? this.rwo : this.rwikiObjectService.getRWikiHistoryObject(this.rwo, this.leftVersionNumber);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid version number for left revision");
        }
    }

    private void setRightVersionNumber(String versionString) {
        if (versionString != null && !"".equals(versionString)) {
            this.rightVersionNumber = Integer.parseInt(versionString);
            try {
                if (this.rwo.getRevision() == this.rightVersionNumber) {
                    this.right = this.rwo;
                }
                this.right = this.rwikiObjectService.getRWikiHistoryObject(this.rwo, this.rightVersionNumber);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid version number for right revision");
            }
        } else {
            this.right = this.rwikiObjectService.getRWikiObject(this.rwo);
        }
        this.leftVersionNumber = this.rightVersionNumber > 0 ? this.rightVersionNumber - 1 : 0;
    }

    public int getLeftVersionNumber() {
        return this.leftVersionNumber;
    }

    public int getRightVersionNumber() {
        return this.rightVersionNumber;
    }

    public RWikiObject getRwikiObject() {
        return this.rwo;
    }

    public RWikiObject getLeft() {
        return this.left;
    }

    public RWikiObject getRight() {
        return this.right;
    }

    public GenericDiffBean getGenericDiffBean() {
        if (this.db == null) {
            this.db = new GenericDiffBean(this.left.getContent(), this.right.getContent());
        }
        return this.db;
    }
}

