/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.bean;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.search.api.InvalidSearchQueryException;
import org.sakaiproject.search.api.SearchList;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.tool.api.ToolManager;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.FullSearchBean;

public class FullSearchBean {
    private static Log log = LogFactory.getLog(FullSearchBean.class);
    private static final String SEARCH_SUFFIX = " +tool:wiki";
    private String search;
    private String realm;
    private SearchService searchService;
    private double timeTaken = 0.0;
    private int pagesize = 20;
    private int nlistPages = 5;
    private int requestPage = 0;
    private int nresults = 0;
    private SearchList searchResults;
    private ToolManager toolManager;

    public FullSearchBean(String search, String requestPage, String realm, SearchService searchService, ToolManager toolManager) {
        this.search = search;
        this.realm = realm;
        this.searchService = searchService;
        this.toolManager = toolManager;
        try {
            this.requestPage = Integer.parseInt(requestPage);
        }
        catch (NumberFormatException e) {
            this.requestPage = 0;
        }
    }

    public void setRWikiObjectService(SearchService searchService) {
        this.searchService = searchService;
    }

    public String getSearch() {
        return this.search;
    }

    public String getRealm() {
        return this.realm;
    }

    public String pageNameFromSearchTitle(String searchTitle) {
        if (searchTitle.startsWith(" /site/")) {
            String h = searchTitle.substring(searchTitle.lastIndexOf(47) + 1);
            return h;
        }
        return searchTitle;
    }

    public List getSearchResults() {
        return this.search();
    }

    public String getTimeTaken() {
        int tt = (int)this.timeTaken;
        return String.valueOf(tt);
    }

    public List search() {
        log.debug((Object)"search()");
        if (this.searchResults == null) {
            ArrayList<String> l = new ArrayList<String>();
            l.add(this.toolManager.getCurrentPlacement().getContext());
            long start = System.currentTimeMillis();
            int searchStart = this.requestPage * this.pagesize;
            int searchEnd = searchStart + this.pagesize;
            try {
                this.searchResults = this.searchService.search(this.search.concat(SEARCH_SUFFIX), l, searchStart, searchEnd);
                long end = System.currentTimeMillis();
                this.timeTaken = end - start;
                this.nresults = this.searchResults.getFullSize();
            }
            catch (InvalidSearchQueryException e) {
                if (log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        log.debug((Object)("got a searchresult of: " + this.searchResults.size()));
        return this.searchResults;
    }

    public List getSearchPages() {
        SearchList sr = (SearchList)this.search();
        if (sr == null) {
            return null;
        }
        int npages = sr.getFullSize() / this.pagesize;
        ArrayList<PageLink> pages = new ArrayList<PageLink>();
        for (int i = 0; i < npages; ++i) {
            pages.add(new PageLink(this, i));
        }
        return pages;
    }

    public int getNlistPages() {
        return this.nlistPages;
    }

    public void setNlistPages(int nlistPages) {
        this.nlistPages = nlistPages;
    }

    public int getPagesize() {
        return this.pagesize;
    }

    public void setPagesize(int pagesize) {
        this.pagesize = pagesize;
    }

    public int getRequestPage() {
        return this.requestPage;
    }

    public void setRequestPage(int requestPage) {
        this.requestPage = requestPage;
    }

    public void setTimeTaken(double timeTaken) {
        this.timeTaken = timeTaken;
    }

    public int getNresults() {
        return this.nresults;
    }

    static /* synthetic */ String access$000(FullSearchBean x0) {
        return x0.search;
    }

    static /* synthetic */ String access$100(FullSearchBean x0) {
        return x0.realm;
    }
}

