/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.bean;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.sakaiproject.entity.api.Entity;
import uk.ac.cam.caret.sakai.rwiki.service.api.EntityHandler;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiObjectService;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ViewBean;
import uk.ac.cam.caret.sakai.rwiki.utils.XmlEscaper;

public class ReferencesBean {
    private RWikiObject rwikiObject;
    private RWikiObjectService objectService;
    private String defaultSpace;

    public ReferencesBean(RWikiObject rwikiObject, RWikiObjectService objectService, String localSpace) {
        this.rwikiObject = rwikiObject;
        this.objectService = objectService;
        this.defaultSpace = localSpace;
    }

    public List getReferencedPageLinks() {
        String referenced = this.rwikiObject.getReferenced();
        String[] references = referenced.split("::");
        ArrayList<String> referenceLinks = new ArrayList<String>(references.length);
        TreeMap<String, String> tmLinks = new TreeMap<String, String>();
        ViewBean vb = new ViewBean(this.rwikiObject.getName(), this.defaultSpace);
        vb.setLocalSpace(vb.getPageSpace());
        for (int i = 0; i < references.length; ++i) {
            String pageName = references[i];
            if (pageName == null || "".equals(pageName)) continue;
            vb.setPageName(pageName);
            tmLinks.put(vb.getLocalName(), vb.getViewUrl());
        }
        for (Map.Entry entry : tmLinks.entrySet()) {
            String objLocalName = (String)entry.getKey();
            String objViewUrl = (String)entry.getValue();
            String link = "<a href=\"" + XmlEscaper.xmlEscape((String)objViewUrl) + "\">" + XmlEscaper.xmlEscape((String)objLocalName) + "</a>";
            referenceLinks.add(link);
        }
        return referenceLinks;
    }

    public List getFeedsLinks() {
        ArrayList<String> feedsLinks = new ArrayList<String>();
        Map m = this.objectService.getHandlers();
        for (Map.Entry entry : m.entrySet()) {
            Entity e;
            EntityHandler eh = (EntityHandler)entry.getValue();
            String displayLink = eh.getHTML(e = this.objectService.getEntity(this.rwikiObject));
            if (displayLink == null) continue;
            feedsLinks.add(displayLink);
        }
        return feedsLinks;
    }

    public List getReferencingPageLinks() {
        List pages = this.objectService.findReferencingPages(this.rwikiObject.getName());
        ArrayList<String> referencingLinks = new ArrayList<String>(pages.size());
        ViewBean vb = new ViewBean(this.rwikiObject.getName(), this.defaultSpace);
        vb.setLocalSpace(vb.getPageSpace());
        Iterator it = pages.iterator();
        while (it.hasNext()) {
            vb.setPageName((String)it.next());
            String link = "<a href=\"" + XmlEscaper.xmlEscape((String)vb.getViewUrl()) + "\">" + XmlEscaper.xmlEscape((String)vb.getLocalName()) + "</a>";
            referencingLinks.add(link);
        }
        return referencingLinks;
    }
}

