/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.bean;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.event.api.EventTrackingService;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiObjectService;
import uk.ac.cam.caret.sakai.rwiki.service.api.dao.ObjectProxy;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiCurrentObject;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.service.exception.PermissionException;
import uk.ac.cam.caret.sakai.rwiki.tool.api.ToolRenderService;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.RenderBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ResourceLoaderBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ViewBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.ResourceLoaderHelperBean;
import uk.ac.cam.caret.sakai.rwiki.utils.NameHelper;
import uk.ac.cam.caret.sakai.rwiki.utils.XmlEscaper;

public class RenderBean {
    private ToolRenderService toolRenderService;
    private RWikiObjectService objectService;
    private RWikiObject rwo;
    private boolean withBreadcrumbs = true;
    private boolean canEdit = false;
    private boolean canRead = false;
    private String previewContent = null;
    public static final String PERMISSION_PROBLEM = "You do not have permission to view this page";

    public RenderBean(RWikiObject rwo, ToolRenderService toolRenderService, RWikiObjectService objectService, boolean withBreadcrumbs) {
        this.rwo = rwo;
        this.toolRenderService = toolRenderService;
        this.objectService = objectService;
        this.withBreadcrumbs = withBreadcrumbs;
        this.canEdit = objectService.checkUpdate(rwo);
        this.canRead = objectService.checkRead(rwo);
    }

    public RenderBean(String name, String defaultRealm, ToolRenderService toolRenderService, RWikiObjectService objectService, boolean withBreadcrumbs) {
        this.objectService = objectService;
        this.toolRenderService = toolRenderService;
        this.withBreadcrumbs = withBreadcrumbs;
        String pageName = NameHelper.globaliseName((String)name, (String)defaultRealm);
        String pageRealm = defaultRealm;
        try {
            this.rwo = objectService.getRWikiObject(pageName, pageRealm);
            this.canEdit = objectService.checkUpdate(this.rwo);
            this.canRead = objectService.checkRead(this.rwo);
        }
        catch (PermissionException e) {
            this.rwo = objectService.createNewRWikiCurrentObject();
            this.rwo.setName(pageName);
            ResourceLoaderBean rlb = ResourceLoaderHelperBean.getResourceLoaderBean();
            this.rwo.setContent(rlb.getString("renderbean.permission_problem", PERMISSION_PROBLEM));
        }
    }

    public RWikiObjectService getObjectService() {
        return this.objectService;
    }

    public void setObjectService(RWikiObjectService objectService) {
        this.objectService = objectService;
    }

    public ToolRenderService getToolRenderService() {
        return this.toolRenderService;
    }

    public void setRenderService(ToolRenderService toolRenderService) {
        this.toolRenderService = toolRenderService;
    }

    public String getPreviewPage() {
        String oldcontent = this.rwo.getContent();
        this.rwo.setContent(this.previewContent);
        String page = this.toolRenderService.renderPage(this.rwo, false);
        this.rwo.setContent(oldcontent);
        return page;
    }

    public String getRenderedPage() {
        EventTrackingService ets;
        if (this.rwo != null && this.rwo.getName() != null && (ets = (EventTrackingService)ComponentManager.get(EventTrackingService.class)) != null) {
            ets.post(ets.newEvent("wiki.read", StringUtils.abbreviate((String)this.rwo.getName(), (int)250), false));
        }
        return this.toolRenderService.renderPage(this.rwo);
    }

    public String getPublicRenderedPage() {
        return this.toolRenderService.renderPublicPage(this.rwo, this.withBreadcrumbs);
    }

    public String getPrintRenderedPage() {
        return this.toolRenderService.renderPrintPage(this.rwo, this.withBreadcrumbs);
    }

    public String renderPage() {
        return this.toolRenderService.renderPage(this.rwo);
    }

    public String publicRenderedPage() {
        return this.toolRenderService.renderPublicPage(this.rwo, this.withBreadcrumbs);
    }

    public String printRenderedPage() {
        return this.toolRenderService.renderPrintPage(this.rwo, this.withBreadcrumbs);
    }

    public String renderPage(String name, String defaultRealm) {
        String pageName = NameHelper.globaliseName((String)name, (String)defaultRealm);
        String pageRealm = NameHelper.localizeSpace((String)pageName, (String)defaultRealm);
        try {
            RWikiCurrentObject page = this.objectService.getRWikiObject(pageName, pageRealm);
            return this.toolRenderService.renderPage((RWikiObject)page, defaultRealm);
        }
        catch (PermissionException e) {
            RWikiObject page = this.objectService.createNewRWikiCurrentObject();
            page.setName(pageName);
            ResourceLoaderBean rlb = ResourceLoaderHelperBean.getResourceLoaderBean();
            page.setContent(rlb.getString("renderbean.permission_problem", PERMISSION_PROBLEM));
            return this.toolRenderService.renderPage(page, defaultRealm);
        }
    }

    public String publicRenderPage(String name, String defaultRealm, boolean withBreadcrumbs) {
        String pageName = NameHelper.globaliseName((String)name, (String)defaultRealm);
        String pageSpace = NameHelper.localizeSpace((String)pageName, (String)defaultRealm);
        try {
            RWikiCurrentObject page = this.objectService.getRWikiObject(pageName, pageSpace);
            return this.toolRenderService.renderPublicPage((RWikiObject)page, defaultRealm, withBreadcrumbs);
        }
        catch (PermissionException e) {
            RWikiObject page = this.objectService.createNewRWikiCurrentObject();
            page.setName(pageName);
            ResourceLoaderBean rlb = ResourceLoaderHelperBean.getResourceLoaderBean();
            page.setContent(rlb.getString("renderbean.permission_problem", PERMISSION_PROBLEM));
            return this.toolRenderService.renderPublicPage(page, defaultRealm, withBreadcrumbs);
        }
    }

    public String printRenderPage(String name, String defaultRealm, boolean withBreadcrumbs) {
        String pageName = NameHelper.globaliseName((String)name, (String)defaultRealm);
        String pageSpace = NameHelper.localizeSpace((String)pageName, (String)defaultRealm);
        try {
            RWikiCurrentObject page = this.objectService.getRWikiObject(pageName, pageSpace);
            return this.toolRenderService.renderPrintPage((RWikiObject)page, defaultRealm, withBreadcrumbs);
        }
        catch (PermissionException e) {
            RWikiObject page = this.objectService.createNewRWikiCurrentObject();
            page.setName(pageName);
            ResourceLoaderBean rlb = ResourceLoaderHelperBean.getResourceLoaderBean();
            page.setContent(rlb.getString("renderbean.permission_problem", PERMISSION_PROBLEM));
            return this.toolRenderService.renderPrintPage(page, defaultRealm, withBreadcrumbs);
        }
    }

    public RWikiObject getRwikiObject() {
        return this.rwo;
    }

    public String getLocalisedPageName() {
        return NameHelper.localizeName((String)this.rwo.getName(), (String)this.rwo.getRealm());
    }

    public Integer getLocalisedPageNameLength() {
        return NameHelper.localizeName((String)this.rwo.getName(), (String)this.rwo.getRealm()).length();
    }

    public String getEditUrl() {
        ViewBean vb = new ViewBean(this.rwo.getName(), this.rwo.getRealm());
        return vb.getEditUrl();
    }

    public boolean getExists() {
        return this.objectService.exists(this.rwo.getName(), this.rwo.getRealm());
    }

    public boolean getHasContent() {
        if (!this.getExists()) {
            return false;
        }
        String content = this.rwo.getContent();
        return content != null && content.trim().length() > 0;
    }

    public List getComments() {
        List commentsList = this.objectService.findRWikiSubPages(this.rwo.getName() + ".");
        1 lop = new /* Unavailable Anonymous Inner Class!! */;
        return this.objectService.createListProxy(commentsList, (ObjectProxy)lop);
    }

    public String getCommentPageLink() {
        String pageName = this.rwo.getName();
        String link = "";
        ViewBean vb = new ViewBean(this.rwo.getName(), NameHelper.localizeSpace((String)this.rwo.getName(), (String)this.rwo.getRealm()));
        vb.setLocalSpace(vb.getPageSpace());
        if (pageName != null && !"".equals(pageName)) {
            vb.setPageName(pageName);
            link = "<a href=\"" + XmlEscaper.xmlEscape((String)vb.getViewUrl()) + "\">" + XmlEscaper.xmlEscape((String)vb.getLocalName()) + "</a>";
        }
        return link;
    }

    public boolean getCanEdit() {
        return this.canEdit;
    }

    public void setCanEdit(boolean canEdit) {
        this.canEdit = canEdit;
    }

    public boolean getCanRead() {
        return this.canRead;
    }

    public void setCanRead(boolean canRead) {
        this.canRead = canRead;
    }

    public String getListCommentsURL() {
        ViewBean vb = new ViewBean(this.rwo.getName(), NameHelper.localizeSpace((String)this.rwo.getName(), (String)this.rwo.getRealm()));
        return vb.getListCommentsURL();
    }

    public String getNewCommentURL() {
        ViewBean vb = new ViewBean(this.rwo.getName(), NameHelper.localizeSpace((String)this.rwo.getName(), (String)this.rwo.getRealm()));
        return vb.getNewCommentURL();
    }

    public String getEditCommentURL() {
        ViewBean vb = new ViewBean(this.rwo.getName(), NameHelper.localizeSpace((String)this.rwo.getName(), (String)this.rwo.getRealm()));
        return vb.getEditCommentURL();
    }

    public String getCommentLevel() {
        int i;
        String localName = NameHelper.localizeName((String)this.rwo.getName(), (String)NameHelper.localizeSpace((String)this.rwo.getName(), (String)this.rwo.getRealm()));
        int p = localName.indexOf(".", 0);
        for (i = 1; p > 0 && i <= 5; ++i) {
            p = localName.indexOf(".", p + 1);
        }
        return String.valueOf(i);
    }

    public String getListPresenceURL() {
        ViewBean vb = new ViewBean(this.rwo.getName(), NameHelper.localizeSpace((String)this.rwo.getName(), (String)this.rwo.getRealm()));
        return vb.getListPresenceURL();
    }

    public String getOpenPageChatURL() {
        ViewBean vb = new ViewBean(this.rwo.getName(), NameHelper.localizeSpace((String)this.rwo.getName(), (String)this.rwo.getRealm()));
        return vb.getOpenPageChatURL();
    }

    public String getOpenSpaceChatURL() {
        ViewBean vb = new ViewBean(this.rwo.getName(), NameHelper.localizeSpace((String)this.rwo.getName(), (String)this.rwo.getRealm()));
        return vb.getOpenSpaceChatURL();
    }

    public String getListPageChatURL() {
        ViewBean vb = new ViewBean(this.rwo.getName(), NameHelper.localizeSpace((String)this.rwo.getName(), (String)this.rwo.getRealm()));
        return vb.getListPageChatURL();
    }

    public String getListSpaceChatURL() {
        ViewBean vb = new ViewBean(this.rwo.getName(), NameHelper.localizeSpace((String)this.rwo.getName(), (String)this.rwo.getRealm()));
        return vb.getListSpaceChatURL();
    }

    public void setPreviewContent(String previewContent) {
        this.previewContent = previewContent;
    }

    static /* synthetic */ ToolRenderService access$000(RenderBean x0) {
        return x0.toolRenderService;
    }

    static /* synthetic */ RWikiObjectService access$100(RenderBean x0) {
        return x0.objectService;
    }

    static /* synthetic */ boolean access$200(RenderBean x0) {
        return x0.withBreadcrumbs;
    }
}

