/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.command;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.AuthzPermissionException;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.tool.cover.SessionManager;
import uk.ac.cam.caret.sakai.rwiki.tool.RequestScopeSuperBean;
import uk.ac.cam.caret.sakai.rwiki.tool.api.HttpCommand;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.AuthZGroupEditBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ErrorBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ResourceLoaderBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ViewBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.ViewParamsHelperBean;
import uk.ac.cam.caret.sakai.rwiki.tool.command.Dispatcher;

public class EditAuthZGroupCommand
implements HttpCommand {
    private static Log log = LogFactory.getLog(EditAuthZGroupCommand.class);
    private String editRealmPath;
    private String cancelEditPath;
    private String successfulPath;
    private String permissionPath;
    private String unknownRealmPath;
    private String idInUsePath;
    private AuthzGroupService realmService;

    public void init() {
        ComponentManager cm = org.sakaiproject.component.cover.ComponentManager.getInstance();
        this.realmService = (AuthzGroupService)this.load(cm, AuthzGroupService.class.getName());
    }

    private Object load(ComponentManager cm, String name) {
        Object o = cm.get(name);
        if (o == null) {
            log.error((Object)("Cant find Spring component named " + name));
        }
        return o;
    }

    public void execute(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestScopeSuperBean rssb = RequestScopeSuperBean.getFromRequest((HttpServletRequest)request);
        ViewParamsHelperBean vphb = rssb.getNameHelperBean();
        AuthZGroupEditBean realmEditBean = rssb.getRealmEditBean();
        String requestedRealmId = realmEditBean.getLocalSpace();
        String saveType = vphb.getSaveType();
        try {
            AuthzGroup realmEdit;
            if (realmEditBean.getRealmEdit() == null) {
                realmEdit = this.realmService.getAuthzGroup(requestedRealmId);
                realmEditBean.setRealmEdit(realmEdit);
            } else {
                realmEdit = realmEditBean.getRealmEdit();
                if (!requestedRealmId.equals(realmEdit.getId())) {
                    ErrorBean errorBean = rssb.getErrorBean();
                    ResourceLoaderBean rlb = rssb.getResourceLoaderBean();
                    errorBean.addError(rlb.getString("editauthz.currently_editing1", "You are currently editing: ") + realmEdit.getId() + rlb.getString("editauthz.currently_editing2", ". You must finish editing this realm first"));
                    realmEditBean.setLocalSpace(realmEdit.getId());
                    saveType = null;
                }
            }
            if (saveType == null || "".equals(saveType)) {
                this.editDispatch(dispatcher, request, response);
                return;
            }
            if (saveType.equals("cancel")) {
                realmEditBean.setRealmEdit(null);
                this.cancelDispatch(dispatcher, request, response);
                String pageName = vphb.getGlobalName();
                String realm = vphb.getLocalSpace();
                ViewBean vb = new ViewBean(pageName, realm);
                String requestURL = request.getRequestURL().toString();
                SessionManager.getCurrentToolSession().setAttribute("uk.ac.cam.caret.sakai.rwiki.tool.RWikiServlet.last-request-url", (Object)(requestURL + vb.getInfoUrl()));
                return;
            }
            if (saveType.equals("save")) {
                Map requestMap = request.getParameterMap();
                for (Role roleEdit : realmEdit.getRoles()) {
                    this.updateRoleEdit(roleEdit, requestMap);
                }
                this.realmService.save(realmEdit);
                realmEditBean.setRealmEdit(null);
                this.successfulDispatch(dispatcher, request, response);
                String pageName = vphb.getGlobalName();
                String realm = vphb.getLocalSpace();
                ViewBean vb = new ViewBean(pageName, realm);
                String requestURL = request.getRequestURL().toString();
                SessionManager.getCurrentToolSession().setAttribute("uk.ac.cam.caret.sakai.rwiki.tool.RWikiServlet.last-request-url", (Object)(requestURL + vb.getInfoUrl()));
            }
        }
        catch (GroupNotDefinedException e) {
            realmEditBean.setRealmEdit(null);
            this.unknownRealmDispatch(dispatcher, request, response);
            return;
        }
        catch (AuthzPermissionException e) {
            realmEditBean.setRealmEdit(null);
            this.permissionDeniedDispatch(dispatcher, request, response);
            return;
        }
    }

    public String getIdInUsePath() {
        return this.idInUsePath;
    }

    public void setIdInUsePath(String idInUsePath) {
        this.idInUsePath = idInUsePath;
    }

    public String getPermissionPath() {
        return this.permissionPath;
    }

    public void setPermissionPath(String permissionPath) {
        this.permissionPath = permissionPath;
    }

    public String getUnknownRealmPath() {
        return this.unknownRealmPath;
    }

    public void setUnknownRealmPath(String unknownRealmPath) {
        this.unknownRealmPath = unknownRealmPath;
    }

    public String getCancelEditPath() {
        return this.cancelEditPath;
    }

    public void setCancelEditPath(String cancelEditPath) {
        this.cancelEditPath = cancelEditPath;
    }

    public String getEditRealmPath() {
        return this.editRealmPath;
    }

    public void setEditRealmPath(String editRealmPath) {
        this.editRealmPath = editRealmPath;
    }

    public String getSuccessfulPath() {
        return this.successfulPath;
    }

    public void setSuccessfulPath(String successfulPath) {
        this.successfulPath = successfulPath;
    }

    private void successfulDispatch(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        dispatcher.dispatch(this.successfulPath, request, response);
    }

    private void cancelDispatch(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        dispatcher.dispatch(this.cancelEditPath, request, response);
    }

    private void editDispatch(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        dispatcher.dispatch(this.editRealmPath, request, response);
    }

    private void permissionDeniedDispatch(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        dispatcher.dispatch(this.permissionPath, request, response);
    }

    private void unknownRealmDispatch(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        dispatcher.dispatch(this.unknownRealmPath, request, response);
    }

    private void updateRoleEdit(Role roleEdit, Map map) {
        String id = roleEdit.getId();
        if (map.get("create_" + id) != null) {
            if (!roleEdit.isAllowed("rwiki.create")) {
                roleEdit.allowFunction("rwiki.create");
            }
        } else if (roleEdit.isAllowed("rwiki.create")) {
            roleEdit.disallowFunction("rwiki.create");
        }
        if (map.get("read_" + id) != null) {
            if (!roleEdit.isAllowed("rwiki.read")) {
                roleEdit.allowFunction("rwiki.read");
            }
        } else if (roleEdit.isAllowed("rwiki.read")) {
            roleEdit.disallowFunction("rwiki.read");
        }
        if (map.get("update_" + id) != null) {
            if (!roleEdit.isAllowed("rwiki.update")) {
                roleEdit.allowFunction("rwiki.update");
            }
        } else if (roleEdit.isAllowed("rwiki.update")) {
            roleEdit.disallowFunction("rwiki.update");
        }
        if (map.get("admin_" + id) != null) {
            if (!roleEdit.isAllowed("rwiki.admin")) {
                roleEdit.allowFunction("rwiki.admin");
            }
        } else if (roleEdit.isAllowed("rwiki.admin")) {
            roleEdit.disallowFunction("rwiki.admin");
        }
        if (map.get("superadmin_" + id) != null) {
            if (!roleEdit.isAllowed("rwiki.superadmin")) {
                roleEdit.allowFunction("rwiki.superadmin");
            }
        } else if (roleEdit.isAllowed("rwiki.superadmin")) {
            roleEdit.disallowFunction("rwiki.superadmin");
        }
    }
}

