/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.command;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.tool.api.ActiveTool;
import org.sakaiproject.tool.api.ActiveToolManager;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.cover.ToolManager;
import uk.ac.cam.caret.sakai.rwiki.tool.api.HttpCommand;
import uk.ac.cam.caret.sakai.rwiki.tool.command.Dispatcher;

public class HelperCommand
implements HttpCommand {
    private static Log log = LogFactory.getLog(HelperCommand.class);
    private ActiveToolManager activeToolManager;
    private SessionManager sessionManager;

    public void init() {
        ComponentManager cm = org.sakaiproject.component.cover.ComponentManager.getInstance();
        this.activeToolManager = (ActiveToolManager)this.load(cm, ActiveToolManager.class.getName());
        this.sessionManager = (SessionManager)this.load(cm, SessionManager.class.getName());
    }

    private Object load(ComponentManager cm, String name) {
        Object o = cm.get(name);
        if (o == null) {
            log.error((Object)("Cant find Spring component named " + name));
        }
        return o;
    }

    public void execute(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestPath = request.getRequestURI().substring(request.getContextPath().length() + request.getServletPath().length());
        String[] parts = requestPath.split("/");
        String helperId = null;
        if ("websphere".equals(ServerConfigurationService.getString((String)"servlet.container"))) {
            if (parts.length < 5) {
                throw new IllegalArgumentException("You must provide a helper name to request.");
            }
            helperId = parts[4];
        } else {
            if (parts.length < 3) {
                throw new IllegalArgumentException("You must provide a helper name to request.");
            }
            helperId = parts[2];
        }
        ActiveTool helperTool = this.activeToolManager.getActiveTool(helperId);
        StringBuffer context = new StringBuffer(request.getContextPath()).append(request.getServletPath());
        StringBuffer toolPath = new StringBuffer();
        if ("websphere".equals(ServerConfigurationService.getString((String)"servlet.container"))) {
            int i;
            String tid = ToolManager.getCurrentPlacement().getId();
            context.append("/tool/");
            context.append(tid);
            for (i = 3; i < 5; ++i) {
                context.append('/');
                context.append(parts[i]);
            }
            for (i = 5; i < parts.length; ++i) {
                toolPath.append('/');
                toolPath.append(parts[i]);
            }
        } else {
            int i;
            for (i = 1; i < 3; ++i) {
                context.append('/');
                context.append(parts[i]);
            }
            for (i = 3; i < parts.length; ++i) {
                toolPath.append('/');
                toolPath.append(parts[i]);
            }
        }
        request.removeAttribute("sakai.request.native.url");
        helperTool.help(request, response, context.toString(), toolPath.toString());
    }
}

