/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.command;

import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.tool.cover.SessionManager;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiObjectService;
import uk.ac.cam.caret.sakai.rwiki.service.exception.PermissionException;
import uk.ac.cam.caret.sakai.rwiki.service.exception.VersionException;
import uk.ac.cam.caret.sakai.rwiki.tool.RequestScopeSuperBean;
import uk.ac.cam.caret.sakai.rwiki.tool.api.HttpCommand;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.EditBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ErrorBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ResourceLoaderBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ViewBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.ResourceLoaderHelperBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.ViewParamsHelperBean;
import uk.ac.cam.caret.sakai.rwiki.tool.command.Dispatcher;
import uk.ac.cam.caret.sakai.rwiki.tool.command.helper.ErrorBeanHelper;

public class RevertCommand
implements HttpCommand {
    private static Log log = LogFactory.getLog(RevertCommand.class);
    private String successfulPath;
    private RWikiObjectService objectService;
    private String noUpdatePath;
    private String contentChangedPath;

    public void init() {
        ComponentManager cm = org.sakaiproject.component.cover.ComponentManager.getInstance();
        this.objectService = (RWikiObjectService)this.load(cm, RWikiObjectService.class.getName());
    }

    private Object load(ComponentManager cm, String name) {
        Object o = cm.get(name);
        if (o == null) {
            log.error((Object)("Cant find Spring component named " + name));
        }
        return o;
    }

    public void execute(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestScopeSuperBean rssb = RequestScopeSuperBean.getFromRequest((HttpServletRequest)request);
        ViewParamsHelperBean vphb = rssb.getNameHelperBean();
        String revision = request.getParameter("revision");
        String version = request.getParameter("version");
        Date versionDate = new Date(Long.parseLong(version));
        int revisionInt = Integer.parseInt(revision);
        String name = vphb.getGlobalName();
        String realm = vphb.getLocalSpace();
        try {
            this.objectService.revert(name, realm, versionDate, revisionInt);
        }
        catch (VersionException e) {
            EditBean editBean = rssb.getEditBean();
            editBean.setPreviousRevision(revisionInt);
            editBean.setPreviousVersion(version);
            editBean.setSaveType("revert");
            this.contentChangedDispatch(dispatcher, request, response);
            return;
        }
        catch (PermissionException e) {
            this.noUpdateAllowed(dispatcher, request, response);
            return;
        }
        this.successfulUpdateDispatch(dispatcher, request, response);
        ViewBean vb = new ViewBean(name, realm);
        String requestURL = request.getRequestURL().toString();
        SessionManager.getCurrentToolSession().setAttribute("uk.ac.cam.caret.sakai.rwiki.tool.RWikiServlet.last-request-url", (Object)(requestURL + vb.getViewUrl()));
    }

    private void successfulUpdateDispatch(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        dispatcher.dispatch(this.successfulPath, request, response);
    }

    private void contentChangedDispatch(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ErrorBean errorBean = ErrorBeanHelper.getErrorBean((HttpServletRequest)request);
        ResourceLoaderBean rlb = ResourceLoaderHelperBean.getResourceLoaderBean();
        errorBean.addError(rlb.getString("revertcmd.content_changed", "Content has changed since you last viewed it. Please update the new content or overwrite it with the submitted content."));
        dispatcher.dispatch(this.contentChangedPath, request, response);
    }

    private void noUpdateAllowed(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ErrorBean errorBean = ErrorBeanHelper.getErrorBean((HttpServletRequest)request);
        ResourceLoaderBean rlb = ResourceLoaderHelperBean.getResourceLoaderBean();
        errorBean.addError(rlb.getString("revertcmd.noupdate_allowed", "You do not have permission to update this page."));
        dispatcher.dispatch(this.noUpdatePath, request, response);
    }

    public String getContentChangedPath() {
        return this.contentChangedPath;
    }

    public void setContentChangedPath(String contentChangedPath) {
        this.contentChangedPath = contentChangedPath;
    }

    public String getNoUpdatePath() {
        return this.noUpdatePath;
    }

    public void setNoUpdatePath(String noUpdatePath) {
        this.noUpdatePath = noUpdatePath;
    }

    public String getSuccessfulPath() {
        return this.successfulPath;
    }

    public void setSuccessfulPath(String successfulPath) {
        this.successfulPath = successfulPath;
    }
}

