/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.command;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.ToolManager;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiObjectService;
import uk.ac.cam.caret.sakai.rwiki.service.exception.PermissionException;
import uk.ac.cam.caret.sakai.rwiki.service.exception.VersionException;
import uk.ac.cam.caret.sakai.rwiki.tool.RequestScopeSuperBean;
import uk.ac.cam.caret.sakai.rwiki.tool.api.HttpCommand;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ErrorBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ResourceLoaderBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ViewBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.ResourceLoaderHelperBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.ViewParamsHelperBean;
import uk.ac.cam.caret.sakai.rwiki.tool.command.Dispatcher;
import uk.ac.cam.caret.sakai.rwiki.tool.command.helper.ErrorBeanHelper;
import uk.ac.cam.caret.sakai.rwiki.tool.util.WikiPageAction;

public class SaveCommand
implements HttpCommand {
    private static Log log = LogFactory.getLog(SaveCommand.class);
    private static final String ATTACHMENT_HELPER = "sakai.filepicker";
    protected RWikiObjectService objectService;
    private String contentChangedPath;
    private String noUpdatePath;
    private String successfulPath;
    private String previewPath;
    private String cancelPath;
    private SessionManager sessionManager;

    public void init() {
        ComponentManager cm = org.sakaiproject.component.cover.ComponentManager.getInstance();
        this.sessionManager = (SessionManager)this.load(cm, SessionManager.class.getName());
        this.objectService = (RWikiObjectService)this.load(cm, RWikiObjectService.class.getName());
    }

    private Object load(ComponentManager cm, String name) {
        Object o = cm.get(name);
        if (o == null) {
            log.error((Object)("Cant find Spring component named " + name));
        }
        return o;
    }

    public void execute(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestScopeSuperBean rssb = RequestScopeSuperBean.getFromRequest((HttpServletRequest)request);
        ResourceLoaderBean rlb = rssb.getResourceLoaderBean();
        ViewParamsHelperBean vphb = rssb.getNameHelperBean();
        String tid = ToolManager.getCurrentPlacement().getId();
        String content = vphb.getContent();
        String save = vphb.getSaveType();
        String name = vphb.getGlobalName();
        String realm = vphb.getLocalSpace();
        if (save == null) {
            save = "save";
        }
        if (save.equals("overwrite")) {
            content = vphb.getSubmittedContent();
            vphb.setContent(content);
        } else {
            if (save.equals("preview")) {
                vphb.setSaveState("save-preview");
                this.previewDispatch(dispatcher, request, response);
                return;
            }
            if (save.equals("attachlink") || save.equals("attachembed")) {
                ToolSession session = this.sessionManager.getCurrentToolSession();
                Map parameterMap = request.getParameterMap();
                session.setAttribute("STORED_PARAMETERS", (Object)parameterMap);
                ViewBean vb = rssb.getViewBean();
                WikiPageAction returnAction = WikiPageAction.LINK_ATTACHMENT_RETURN_ACTION;
                if (save.equals("attachembed")) {
                    returnAction = WikiPageAction.EMBED_ATTACHMENT_RETURN_ACTION;
                }
                if ("websphere".equals(ServerConfigurationService.getString((String)"servlet.container"))) {
                    session.setAttribute("sakai.filepickersakai.tool.helper.done.url", (Object)(request.getContextPath() + request.getServletPath() + "/tool/" + tid + vb.getActionUrl(returnAction, true)));
                } else {
                    session.setAttribute("sakai.filepickersakai.tool.helper.done.url", (Object)(request.getContextPath() + request.getServletPath() + vb.getActionUrl(returnAction, true)));
                }
                session.setAttribute("sakaiproject.filepicker.attachLinks", (Object)"sakaiproject.filepicker.attachLinks");
                String fromText = returnAction.equals(WikiPageAction.LINK_ATTACHMENT_RETURN_ACTION) ? vb.getLocalName() + rlb.getString("save.as_link", " as link") : vb.getLocalName() + rlb.getString("save.as_embed", " as embed");
                session.setAttribute("sakaiproject.filepicker.from", (Object)fromText);
                if ("websphere".equals(ServerConfigurationService.getString((String)"servlet.container"))) {
                    response.sendRedirect("helper/sakai.filepicker/tool");
                } else {
                    response.sendRedirect(request.getContextPath() + request.getServletPath() + "/helper/" + ATTACHMENT_HELPER + "/tool");
                }
                return;
            }
            if (save.equals("cancel")) {
                vphb.setSaveState("save-cancel");
                this.cancelDispatch(dispatcher, request, response);
                ViewBean vb = new ViewBean(name, realm);
                String requestURL = request.getRequestURL().toString();
                this.sessionManager.getCurrentToolSession().setAttribute("uk.ac.cam.caret.sakai.rwiki.tool.RWikiServlet.last-request-url", (Object)(requestURL + vb.getViewUrl()));
                return;
            }
        }
        String version = vphb.getSubmittedVersion();
        Date versionDate = new Date(Long.parseLong(version));
        try {
            this.doUpdate(name, realm, versionDate, content);
        }
        catch (VersionException e) {
            vphb.setSaveState("save-versionexcep");
            this.contentChangedDispatch(dispatcher, request, response);
            return;
        }
        catch (PermissionException e) {
            this.noUpdateAllowed(dispatcher, request, response);
            return;
        }
        vphb.setSaveState("save-ok");
        this.successfulUpdateDispatch(dispatcher, request, response);
        ViewBean vb = new ViewBean(name, realm);
        String requestURL = request.getRequestURL().toString();
        this.sessionManager.getCurrentToolSession().setAttribute("uk.ac.cam.caret.sakai.rwiki.tool.RWikiServlet.last-request-url", (Object)(requestURL + vb.getViewUrl()));
    }

    protected void doUpdate(String name, String realm, Date versionDate, String content) {
        this.objectService.update(name, realm, versionDate, content);
    }

    private void cancelDispatch(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        dispatcher.dispatch(this.cancelPath, request, response);
    }

    private void previewDispatch(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        dispatcher.dispatch(this.previewPath, request, response);
    }

    protected void successfulUpdateDispatch(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        dispatcher.dispatch(this.successfulPath, request, response);
    }

    private void contentChangedDispatch(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ErrorBean errorBean = ErrorBeanHelper.getErrorBean((HttpServletRequest)request);
        ResourceLoaderBean rlb = ResourceLoaderHelperBean.getResourceLoader((HttpServletRequest)request);
        errorBean.addError(rlb.getString("save.content_changed", "Content has changed since you last viewed it. Please update the new content or overwrite it with the submitted content."));
        dispatcher.dispatch(this.contentChangedPath, request, response);
    }

    private void noUpdateAllowed(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ErrorBean errorBean = ErrorBeanHelper.getErrorBean((HttpServletRequest)request);
        ResourceLoaderBean rlb = ResourceLoaderHelperBean.getResourceLoader((HttpServletRequest)request);
        errorBean.addError(rlb.getString("save.noupdate_permission", "You do not have permission to update this page."));
        dispatcher.dispatch(this.noUpdatePath, request, response);
    }

    public String getSuccessfulPath() {
        return this.successfulPath;
    }

    public void setSuccessfulPath(String successfulPath) {
        this.successfulPath = successfulPath;
    }

    public String getContentChangedPath() {
        return this.contentChangedPath;
    }

    public void setContentChangedPath(String contentChangedPath) {
        this.contentChangedPath = contentChangedPath;
    }

    public String getNoUpdatePath() {
        return this.noUpdatePath;
    }

    public void setNoUpdatePath(String noUpdatePath) {
        this.noUpdatePath = noUpdatePath;
    }

    public String getPreviewPath() {
        return this.previewPath;
    }

    public void setPreviewPath(String previewPath) {
        this.previewPath = previewPath;
    }

    public String getCancelPath() {
        return this.cancelPath;
    }

    public void setCancelPath(String cancelPath) {
        this.cancelPath = cancelPath;
    }
}

