/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.entityproviders;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.cam.caret.sakai.rwiki.service.api.PageLinkRenderer;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ViewBean;
import uk.ac.cam.caret.sakai.rwiki.utils.NameHelper;
import uk.ac.cam.caret.sakai.rwiki.utils.XmlEscaper;

public class DirectServletPageLinkRenderer
implements PageLinkRenderer {
    private static Log log = LogFactory.getLog(DirectServletPageLinkRenderer.class);
    private boolean cachable = false;
    private boolean useCache = false;
    public String localRealm;
    public String localSpace;
    public String extension;

    public DirectServletPageLinkRenderer(String localRealm) {
        this(localRealm, localRealm, "json");
    }

    public DirectServletPageLinkRenderer(String localSpace, String localRealm, String extension) {
        this.localSpace = localSpace;
        this.localRealm = localRealm;
        this.extension = extension;
    }

    public void appendLink(StringBuffer buffer, String name, String view) {
        this.appendLink(buffer, name, view, null);
    }

    public void appendLink(StringBuffer buffer, String name, String view, String anchor) {
        name = NameHelper.globaliseName((String)name, (String)this.localSpace);
        ViewBean vb = new ViewBean(name, this.localRealm);
        if (anchor != null && !"".equals(anchor)) {
            vb.setAnchor(anchor);
        }
        try {
            buffer.append("<a class=\"wiki-page-link\" href=\"").append("/direct/wiki" + this.localRealm + "/page/" + URLEncoder.encode(view, "UTF-8").replaceAll("\\+", "%20") + "." + this.extension).append("\">" + XmlEscaper.xmlEscape((String)view) + "</a>");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"UTF-8 is unsupported in the the encoding of URLs. The url was not appended.");
        }
    }

    public void appendCreateLink(StringBuffer buffer, String name, String view) {
    }

    public void setCachable(boolean cachable) {
        this.cachable = cachable;
    }

    public boolean isCachable() {
        return this.cachable;
    }

    public boolean canUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public void appendLink(StringBuffer buffer, String name, String view, String anchor, boolean autoGenerated) {
        this.appendLink(buffer, name, view, anchor);
    }
}

