/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.entityproviders;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Describeable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.exception.EntityException;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;
import uk.ac.cam.caret.sakai.rwiki.service.api.PageLinkRenderer;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiObjectService;
import uk.ac.cam.caret.sakai.rwiki.service.api.RenderService;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiCurrentObject;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.tool.entityproviders.DirectServletPageLinkRenderer;
import uk.ac.cam.caret.sakai.rwiki.tool.entityproviders.SparseComment;
import uk.ac.cam.caret.sakai.rwiki.tool.entityproviders.SparsePage;
import uk.ac.cam.caret.sakai.rwiki.tool.entityproviders.SparserPage;
import uk.ac.cam.caret.sakai.rwiki.utils.NameHelper;

public class RWikiEntityProvider
extends AbstractEntityProvider
implements AutoRegisterEntityProvider,
ActionsExecutable,
Outputable,
Describeable {
    private static Log log = LogFactory.getLog(RWikiEntityProvider.class);
    public static final String ENTITY_PREFIX = "wiki";
    private RWikiObjectService objectService;
    private RenderService renderService;
    private UserDirectoryService userDirectoryService;

    public String getEntityPrefix() {
        return ENTITY_PREFIX;
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"json", "xml"};
    }

    @EntityCustomAction(action="site", viewKey="list")
    public Object handleSite(EntityView view, Map<String, Object> params) {
        String userId = this.developerHelperService.getCurrentUserId();
        if (userId == null) {
            throw new EntityException("You must be logged in to retrieve pages", "", 401);
        }
        String format = view.getFormat();
        if (view.getPathSegments().length == 3) {
            String siteId = view.getPathSegment(2);
            SparserPage homePage = new SparserPage("home", siteId, format);
            this.getSubPages(homePage, "/site/" + siteId, siteId, userId, format);
            return homePage;
        }
        if (view.getPathSegments().length == 5) {
            String defaultRealm;
            String siteId = view.getPathSegment(2);
            String pageName = view.getPathSegment(4);
            if (this.objectService.exists(pageName, defaultRealm = "/site/" + siteId)) {
                RWikiCurrentObject page = this.objectService.getRWikiObject(pageName, defaultRealm);
                if (!this.objectService.checkRead((RWikiObject)page)) {
                    log.warn((Object)("User '" + userId + "' does not have read permissions for page '" + page.getName() + "'. This page will not be returned in the JSON."));
                    throw new EntityException("Forbidden: You do not have permission to read this page", "", 403);
                }
                SparsePage sparsePage = new SparsePage(pageName, siteId, format);
                String localSpace = NameHelper.localizeSpace((String)page.getName(), (String)defaultRealm);
                DirectServletPageLinkRenderer plr = new DirectServletPageLinkRenderer(localSpace, defaultRealm, format);
                String rendered = this.renderService.renderPage((RWikiObject)page, localSpace, (PageLinkRenderer)plr);
                sparsePage.setHtml(rendered);
                this.addComments((RWikiObject)page, sparsePage);
                return sparsePage;
            }
            log.warn((Object)("Bad request '" + view.getOriginalEntityUrl() + "'"));
            throw new EntityException("Bad request: You must supply a valid page name", "", 400);
        }
        log.warn((Object)("Bad request '" + view.getOriginalEntityUrl() + "'"));
        throw new EntityException("Bad request: To get the pages in a site you need a url like '/direct/wiki/site/SITEID.json' or '/direct/wiki/site/SITEID/page/PAGENAME.json'", "", 400);
    }

    private void getSubPages(SparserPage parent, String realm, String siteId, String userId, String format) {
        RWikiCurrentObject page = this.objectService.getRWikiObject(parent.getName(), realm);
        if (!this.objectService.checkRead((RWikiObject)page)) {
            log.warn((Object)("User '" + userId + "' does not have read permissions for page '" + parent.getName() + "'. This page will not be returned in the JSON."));
            return;
        }
        String referenced = page.getReferenced();
        if (referenced != null) {
            String[] parts = referenced.split("::");
            List<String> children = Arrays.asList(parts);
            for (String childName : children) {
                if ("".equals(childName) || !this.objectService.exists(childName = childName.substring(childName.lastIndexOf("/") + 1), realm)) continue;
                SparserPage child = new SparserPage(childName, siteId, format);
                parent.addChildPage(child);
                this.getSubPages(child, realm, siteId, userId, format);
            }
        }
        int commentCount = this.objectService.findRWikiSubPages(page.getName() + ".").size();
        parent.setNumberOfComments(commentCount);
    }

    private void addComments(RWikiObject page, SparsePage sparsePage) {
        List comments = this.objectService.findRWikiSubPages(page.getName() + ".");
        String realm = page.getRealm();
        HashMap<String, SparseComment> commentMap = new HashMap<String, SparseComment>();
        for (RWikiObject comment : comments) {
            String userDisplayName = comment.getUser();
            try {
                userDisplayName = this.userDirectoryService.getUser(userDisplayName).getDisplayName();
            }
            catch (UserNotDefinedException unde) {
                log.warn((Object)("No user for id '" + userDisplayName + "'. The user id will be returned instead."));
            }
            String name = comment.getName();
            String localName = NameHelper.localizeName((String)name, (String)NameHelper.localizeSpace((String)name, (String)realm));
            String dottyBit = localName.substring(localName.indexOf(".", 0));
            String[] commentIds = dottyBit.split("\\.");
            if (commentIds.length == 2) {
                SparseComment topLevelComment = new SparseComment(userDisplayName, comment.getVersion().getTime(), comment.getContent());
                commentMap.put(commentIds[1], topLevelComment);
                sparsePage.addComment(topLevelComment);
                continue;
            }
            if (commentIds.length <= 2) continue;
            SparseComment parent = (SparseComment)commentMap.get(commentIds[commentIds.length - 2]);
            if (parent == null) {
                log.warn((Object)("No comment in the map for " + commentIds[commentIds.length - 2] + ". Skipping ..."));
                continue;
            }
            SparseComment child = new SparseComment(userDisplayName, comment.getVersion().getTime(), comment.getContent());
            parent.addChildComment(child);
            commentMap.put(commentIds[commentIds.length - 1], child);
        }
    }

    public void setObjectService(RWikiObjectService objectService) {
        this.objectService = objectService;
    }

    public void setRenderService(RenderService renderService) {
        this.renderService = renderService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }
}

