/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.entityproviders;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SparserPage {
    private static Log log = LogFactory.getLog(SparserPage.class);
    private List<SparserPage> childPages = new ArrayList();
    private String name = "";
    private String url = "";
    private int numberOfComments = 0;

    public SparserPage(String name, String siteId, String format) {
        this.name = name;
        try {
            this.url = "/direct/wiki/" + siteId + "/page/" + URLEncoder.encode(name, "UTF-8").replaceAll("\\+", "%20") + "." + format;
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"UTF-8 is unsupported in the the encoding of URLs. The url was not set.");
        }
    }

    public void addChildPage(SparserPage childPage) {
        this.childPages.add(childPage);
    }

    public List<SparserPage> getChildPages() {
        return this.childPages;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setNumberOfComments(int numberOfComments) {
        this.numberOfComments = numberOfComments;
    }

    public int getNumberOfComments() {
        return this.numberOfComments;
    }
}

