/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.service.impl;

import uk.ac.cam.caret.sakai.rwiki.service.api.PageLinkRenderer;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ViewBean;
import uk.ac.cam.caret.sakai.rwiki.utils.NameHelper;
import uk.ac.cam.caret.sakai.rwiki.utils.XmlEscaper;

public class PageLinkRendererImpl
implements PageLinkRenderer {
    private boolean cacheable = true;
    private boolean useCache = true;
    public String localRealm;
    public String localSpace;

    public PageLinkRendererImpl(String localRealm) {
        this(localRealm, localRealm);
    }

    public PageLinkRendererImpl(String localSpace, String localRealm) {
        this.localSpace = localSpace;
        this.localRealm = localRealm;
    }

    public void appendLink(StringBuffer buffer, String name, String view) {
        this.appendLink(buffer, name, view, null);
    }

    public void appendLink(StringBuffer buffer, String name, String view, String anchor) {
        name = NameHelper.globaliseName((String)name, (String)this.localSpace);
        ViewBean vb = new ViewBean(name, this.localRealm);
        if (anchor != null && !"".equals(anchor)) {
            vb.setAnchor(anchor);
        }
        buffer.append("<a href=\"" + XmlEscaper.xmlEscape((String)vb.getViewUrl()) + "\">" + XmlEscaper.xmlEscape((String)view) + "</a>");
    }

    public void appendCreateLink(StringBuffer buffer, String name, String view) {
        this.cacheable = false;
        name = NameHelper.globaliseName((String)name, (String)this.localSpace);
        ViewBean vb = new ViewBean(name, this.localRealm);
        buffer.append("<a href=\"" + XmlEscaper.xmlEscape((String)vb.getViewUrl()) + "\">" + XmlEscaper.xmlEscape((String)view) + "?</a>");
    }

    public boolean isCachable() {
        return this.cacheable;
    }

    public boolean canUseCache() {
        return this.useCache;
    }

    public void setCachable(boolean cachable) {
        this.cacheable = cachable;
    }

    public void setUseCache(boolean b) {
        this.useCache = b;
    }

    public void appendLink(StringBuffer buffer, String name, String view, String anchor, boolean autoGenerated) {
        this.appendLink(buffer, name, view, anchor);
    }
}

