/**********************************************************************************
 * $URL: https://source.sakaiproject.org/svn/rwiki/tags/sakai-10.4/rwiki-tool/tool/src/java/uk/ac/cam/caret/sakai/rwiki/tool/bean/ErrorBean.java $
 * $Id: ErrorBean.java 20354 2007-01-17 10:30:57Z ian@caret.cam.ac.uk $
 ***********************************************************************************
 *
 * Copyright (c) 2003, 2004, 2005, 2006 The Sakai Foundation.
 *
 * Licensed under the Educational Community License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.opensource.org/licenses/ecl1.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************/

package uk.ac.cam.caret.sakai.rwiki.tool.bean;

import java.util.ArrayList;
import java.util.List;

/**
 * A basic error bean that has a list of errors generated by the view and
 * controller.
 * 
 * @author andrew
 */

public class ErrorBean
{
	private List errors = new ArrayList();

	public String getError(int i)
	{
		return (String) errors.get(i);
	}

	public void addError(String errorMessage)
	{
		errors.add(errorMessage);
	}

	public List getErrors()
	{
		return errors;
	}

	public void setErrors(List errors)
	{
		this.errors = errors;
	}

}
