/**********************************************************************************
 * $URL: https://source.sakaiproject.org/svn/rwiki/tags/sakai-10.4/rwiki-tool/tool/src/java/uk/ac/cam/caret/sakai/rwiki/tool/bean/ResourceLoaderBean.java $
 * $Id: ResourceLoaderBean.java 20448 2007-01-18 23:12:24Z ian@caret.cam.ac.uk $
 ***********************************************************************************
 *
 * Copyright (c) 2003, 2004, 2005, 2006 The Sakai Foundation.
 *
 * Licensed under the Educational Community License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.opensource.org/licenses/ecl1.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************/
package uk.ac.cam.caret.sakai.rwiki.tool.bean;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.util.ResourceLoader;

/**
 * @author ieb
 */
public class ResourceLoaderBean implements Map
{
	private static Log log = LogFactory.getLog(ResourceLoaderBean.class);

	private static final String RESOURCE_BUNDLE = "uk.ac.cam.caret.sakai.rwiki.tool.bundle.Messages";

	private static final ResourceLoader rl = new ResourceLoader(RESOURCE_BUNDLE);


	public ResourceLoaderBean()
	{

	}

	public void init(HttpServletRequest request)
	{
		if (log.isDebugEnabled())
		{
			for (Iterator<String> i = rl.keySet().iterator(); i.hasNext();)

			{
				String key = i.next();
				log.debug(" Key " + key + ":" + rl.get(key));
			}
		}
	}

	public String getString(String name)
	{
		return rl.getString(name);
	}

	public String getFormattedMessage(String key, Object[] args)
	{
		return rl.getFormattedMessage(key, args);
	}

	/*
	 * Map interfaces to enable direct EL binding
	 */

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#clear()
	 */
	public void clear()
	{
		throw new UnsupportedOperationException("Read Only Map");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#containsKey(java.lang.Object)
	 */
	public boolean containsKey(Object key)
	{
		return rl.containsKey(key);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#containsValue(java.lang.Object)
	 */
	public boolean containsValue(Object arg0)
	{
		return rl.containsValue(arg0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#entrySet()
	 */
	public Set entrySet()
	{
		return rl.entrySet();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#get(java.lang.Object)
	 */
	public Object get(Object key)
	{
		return rl.get(key);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#isEmpty()
	 */
	public boolean isEmpty()
	{
		return rl.isEmpty();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#keySet()
	 */
	public Set keySet()
	{
		return rl.keySet();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#put(java.lang.Object, java.lang.Object)
	 */
	public Object put(Object arg0, Object arg1)
	{
		throw new UnsupportedOperationException("Read Only Map");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#putAll(java.util.Map)
	 */
	public void putAll(Map arg0)
	{
		throw new UnsupportedOperationException("Read Only Map");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#remove(java.lang.Object)
	 */
	public Object remove(Object arg0)
	{
		throw new UnsupportedOperationException("Read Only Map");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#size()
	 */
	public int size()
	{
		return rl.size();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#values()
	 */
	public Collection values()
	{
		return rl.values();
	}

	/**
	 * @param string
	 * @param string2
	 * @return
	 */
	public String getString(String key, String dflt)
	{
		return rl.getString(key, dflt);
	}

}
