/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.tool.cover.ToolManager;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import uk.ac.cam.caret.sakai.rwiki.tool.MapDispatcher;
import uk.ac.cam.caret.sakai.rwiki.tool.RequestHelper;
import uk.ac.cam.caret.sakai.rwiki.tool.RequestScopeSuperBean;
import uk.ac.cam.caret.sakai.rwiki.tool.api.HttpCommand;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.PrePopulateBean;
import uk.ac.cam.caret.sakai.rwiki.tool.command.Dispatcher;
import uk.ac.cam.caret.sakai.rwiki.tool.util.WikiPageAction;
import uk.ac.cam.caret.sakai.rwiki.utils.TimeLogger;

public class RWikiServlet
extends HttpServlet {
    private static Log log = LogFactory.getLog(RWikiServlet.class);
    private static final long serialVersionUID = 676743152200357706L;
    public static final String SAVED_REQUEST_URL = "uk.ac.cam.caret.sakai.rwiki.tool.RWikiServlet.last-request-url";
    private WebApplicationContext wac;
    private String headerPreContent;
    private String headerScriptSource;
    private String footerScript;
    private Dispatcher dispatcher = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        ServletContext sc = servletConfig.getServletContext();
        this.wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)sc);
        this.headerPreContent = servletConfig.getInitParameter("headerPreContent");
        this.headerScriptSource = servletConfig.getInitParameter("headerScriptSource");
        this.footerScript = servletConfig.getInitParameter("footerScript");
        try {
            boolean logResponse = "true".equalsIgnoreCase(servletConfig.getInitParameter("log-response"));
            TimeLogger.setLogResponse((boolean)logResponse);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            boolean logFullResponse = "true".equalsIgnoreCase(servletConfig.getInitParameter("log-full-response"));
            TimeLogger.setLogFullResponse((boolean)logFullResponse);
        }
        catch (Exception ex) {
            // empty catch block
        }
        String basePath = servletConfig.getServletContext().getRealPath("/");
        this.dispatcher = new MapDispatcher(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.execute(request, response);
        }
        finally {
            RequestScopeSuperBean.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.execute(request, response);
        }
        finally {
            RequestScopeSuperBean.clearInstance();
        }
    }

    public void execute(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.wac == null) {
            this.wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            if (this.wac == null) {
                response.sendError(503, "Cannot get WebApplicationContext");
                return;
            }
        }
        log.debug((Object)"========================Page Start==========");
        request.setAttribute("sakai.request.native.url", (Object)"sakai.request.native.url");
        String targetURL = this.persistState(request);
        String action = request.getParameter("action");
        if (!(StringUtils.isEmpty((String)targetURL) || StringUtils.equals((String)action, (String)"search") || StringUtils.equals((String)action, (String)"full_search"))) {
            response.sendRedirect(targetURL);
            return;
        }
        this.prePopulateRealm(request);
        this.addWikiStylesheet(request);
        request.setAttribute("footerScript", (Object)this.footerScript);
        if (this.headerScriptSource != null && this.headerScriptSource.length() > 0) {
            request.setAttribute("headerScriptSource", (Object)this.headerScriptSource);
        }
        RequestHelper helper = (RequestHelper)this.wac.getBean(RequestHelper.class.getName());
        HttpCommand command = helper.getCommandForRequest(request);
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null && userAgent.indexOf("MSIE 6") >= 0) {
            response.addHeader("Expires", "0");
            response.addHeader("Pragma", "cache");
            response.addHeader("Cache-Control", "private");
        }
        command.execute(this.dispatcher, request, response);
        request.removeAttribute("sakai.request.native.url");
        log.debug((Object)"=====================Page End=============");
    }

    public void prePopulateRealm(HttpServletRequest request) {
        RequestScopeSuperBean rssb = RequestScopeSuperBean.createAndAttach((HttpServletRequest)request, (ApplicationContext)this.wac);
        PrePopulateBean ppBean = rssb.getPrePopulateBean();
        ppBean.doPrepopulate();
    }

    public void addWikiStylesheet(HttpServletRequest request) {
        String sakaiHeader = (String)request.getAttribute("sakai.html.head");
        request.setAttribute("sakai.html.head", (Object)(this.headerPreContent + sakaiHeader));
    }

    private String persistState(HttpServletRequest request) {
        ToolSession ts = SessionManager.getCurrentToolSession();
        if (this.isPageToolDefault(request)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Incomming URL is " + request.getRequestURL().toString() + "?" + request.getQueryString()));
                log.debug((Object)("Restore " + ts.getAttribute(SAVED_REQUEST_URL)));
            }
            return (String)ts.getAttribute(SAVED_REQUEST_URL);
        }
        if (this.isPageRestorable(request)) {
            ts.setAttribute(SAVED_REQUEST_URL, (Object)(request.getRequestURL().toString() + "?" + request.getQueryString()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saved " + ts.getAttribute(SAVED_REQUEST_URL)));
            }
        }
        return null;
    }

    private boolean isPageToolDefault(HttpServletRequest request) {
        String action;
        if ("websphere".equals(ServerConfigurationService.getString((String)"servlet.container"))) {
            String tid = ToolManager.getCurrentPlacement().getId();
            if (request.getPathInfo() != null && request.getPathInfo().startsWith("/tool/" + tid + "/helper/")) {
                return false;
            }
        } else if (request.getPathInfo() != null && request.getPathInfo().startsWith("/helper/")) {
            return false;
        }
        if ((action = request.getParameter("action")) != null && action.length() > 0) {
            return false;
        }
        String pageName = request.getParameter("pageName");
        return pageName == null || pageName.trim().length() == 0;
    }

    private boolean isPageRestorable(HttpServletRequest request) {
        if ("Title".equals(request.getParameter("panel"))) {
            return false;
        }
        if (WikiPageAction.PUBLICVIEW_ACTION.getName().equals(request.getParameter("action"))) {
            return false;
        }
        if (WikiPageAction.PRINTVIEW_ACTION.getName().equals(request.getParameter("action"))) {
            return false;
        }
        return "GET".equalsIgnoreCase(request.getMethod());
    }
}

