/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import uk.ac.cam.caret.sakai.rwiki.tool.api.CommandService;
import uk.ac.cam.caret.sakai.rwiki.tool.api.HttpCommand;

public class RequestHelper {
    private static Log log = LogFactory.getLog(RequestHelper.class);
    public static final String PANEL = "panel";
    public static final String ACTION = "action";
    public static final String TITLE_PANEL = "Title";
    public static final String HELPER_PATH = "helper";
    public static final String WIKI_PATH = "wiki";
    private String defaultAction = "view";
    private CommandService commandService;

    public void init() {
    }

    public HttpCommand getCommandForRequest(HttpServletRequest request) {
        String panel = request.getParameter(PANEL);
        String action = request.getParameter(ACTION);
        if (TITLE_PANEL.equals(panel)) {
            action = panel;
        }
        String requestPath = request.getRequestURI().substring(request.getContextPath().length() + request.getServletPath().length());
        if ("websphere".equals(ServerConfigurationService.getString((String)"servlet.container"))) {
            String[] parts = requestPath.split("/");
            if (parts.length >= 4 && parts[3].equals(HELPER_PATH)) {
                action = HELPER_PATH;
            }
        } else if (requestPath != null && requestPath.startsWith("/helper/")) {
            action = HELPER_PATH;
        }
        if (action == null) {
            action = this.defaultAction;
        }
        return this.commandService.getCommand(action);
    }

    public CommandService getCommandService() {
        return this.commandService;
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }

    public String getDefaultAction() {
        return this.defaultAction;
    }

    public void setDefaultAction(String defaultAction) {
        this.defaultAction = defaultAction;
    }
}

