/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.bean;

import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.commons.jrcs.diff.Revision;
import org.apache.commons.jrcs.diff.RevisionVisitor;
import org.apache.commons.jrcs.diff.myers.MyersDiff;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.GenericDiffBean;

public class GenericDiffBean {
    private String leftContent;
    private String rightContent;
    private Revision difference;
    private Object[] objectifiedRight;
    private Object[] objectifiedLeft;

    public GenericDiffBean(String leftContent, String rightContent) {
        this.setLeftContent(leftContent);
        this.setRightContent(rightContent);
        this.init();
    }

    public GenericDiffBean() {
    }

    public void init() {
        MyersDiff diffAlgorithm = new MyersDiff();
        try {
            this.objectifiedLeft = this.leftContent.split("\n");
            this.objectifiedRight = this.rightContent.split("\n");
            this.difference = diffAlgorithm.diff(this.objectifiedLeft, this.objectifiedRight);
        }
        catch (DifferentiationFailedException e) {
            throw new RuntimeException("DifferentiationFailedException occured: This should never happen!", e);
        }
    }

    public String getColorDiffTable() {
        ColorDiffTableRevisionVisitor rv = new ColorDiffTableRevisionVisitor(this);
        this.difference.accept((RevisionVisitor)rv);
        return rv.getTableRows();
    }

    public String getColorDiffString() {
        ColorDiffRevisionVisitor rv = new ColorDiffRevisionVisitor(this);
        this.difference.accept((RevisionVisitor)rv);
        return rv.getDiffString();
    }

    public String getUnixDiffString() {
        return this.difference.toString();
    }

    public String getLeftContent() {
        return this.leftContent;
    }

    public void setLeftContent(String leftContent) {
        this.leftContent = leftContent.replaceAll("\r\n?", "\n");
    }

    public String getRightContent() {
        return this.rightContent;
    }

    public void setRightContent(String rightContent) {
        this.rightContent = rightContent.replaceAll("\r\n?", "\n");
    }

    public Revision getDifference() {
        return this.difference;
    }

    static /* synthetic */ Object[] access$000(GenericDiffBean x0) {
        return x0.objectifiedLeft;
    }

    static /* synthetic */ Object[] access$100(GenericDiffBean x0) {
        return x0.objectifiedRight;
    }
}

